/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.fx.listeners;

import java.util.HashMap;
import java.util.HashSet;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.transform.Transform;

public abstract class VisualChangeListener {
    private Node observed;
    private Node parent;
    private HashMap<ChangeListener<Transform>, Node> localToParentTransformListeners = new HashMap();
    private boolean layoutBoundsChanged = false;
    private boolean boundsInLocalChanged = false;
    private boolean boundsInParentChanged = false;
    private Bounds oldBoundsInLocal = null;
    private Bounds newBoundsInLocal = null;
    private ChangeListener<? super Bounds> layoutBoundsListener = new ChangeListener<Bounds>(){

        public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
            if (VisualChangeListener.this.isValidBounds(newValue)) {
                VisualChangeListener.this.layoutBoundsChanged = true;
                VisualChangeListener.this.onBoundsChanged();
            }
        }
    };
    private final ChangeListener<? super Bounds> boundsInLocalListener = new ChangeListener<Bounds>(){

        public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
            if (VisualChangeListener.this.isValidBounds(newValue)) {
                VisualChangeListener.this.oldBoundsInLocal = oldValue;
                VisualChangeListener.this.newBoundsInLocal = newValue;
                VisualChangeListener.this.boundsInLocalChanged = true;
                VisualChangeListener.this.onBoundsChanged();
            }
        }
    };
    private ChangeListener<? super Bounds> boundsInParentListener = new ChangeListener<Bounds>(){

        public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
            if (VisualChangeListener.this.isValidBounds(newValue)) {
                VisualChangeListener.this.boundsInParentChanged = true;
                VisualChangeListener.this.onBoundsChanged();
            }
        }
    };

    protected abstract void boundsInLocalChanged(Bounds var1, Bounds var2);

    private Node getNearestCommonAncestor(Node source, Node target) {
        if (source == target) {
            return source;
        }
        HashSet<Node> parents = new HashSet<Node>();
        Node m = source;
        Node n = target;
        while (m != null || n != null) {
            if (m != null) {
                if (parents.contains(m)) {
                    return m;
                }
                parents.add(m);
                if (n != null && parents.contains(n)) {
                    return n;
                }
                m = m.getParent();
            }
            if (n == null) continue;
            if (parents.contains(n)) {
                return n;
            }
            parents.add(n);
            if (m != null && parents.contains(m)) {
                return m;
            }
            n = n.getParent();
        }
        return null;
    }

    public boolean isRegistered() {
        return this.parent != null;
    }

    private boolean isValidBounds(Bounds b) {
        if (Double.isNaN(b.getMinX()) || Double.isInfinite(b.getMinX())) {
            return false;
        }
        if (Double.isNaN(b.getMinY()) || Double.isInfinite(b.getMinY())) {
            return false;
        }
        if (Double.isNaN(b.getMaxX()) || Double.isInfinite(b.getMaxX())) {
            return false;
        }
        return !Double.isNaN(b.getMaxY()) && !Double.isInfinite(b.getMaxY());
    }

    private boolean isValidTransform(Transform t) {
        if (Double.isNaN(t.getMxx()) || Double.isInfinite(t.getMxx())) {
            return false;
        }
        if (Double.isNaN(t.getMxy()) || Double.isInfinite(t.getMxy())) {
            return false;
        }
        if (Double.isNaN(t.getMxz()) || Double.isInfinite(t.getMxz())) {
            return false;
        }
        if (Double.isNaN(t.getMyx()) || Double.isInfinite(t.getMyx())) {
            return false;
        }
        if (Double.isNaN(t.getMyy()) || Double.isInfinite(t.getMyy())) {
            return false;
        }
        if (Double.isNaN(t.getMyz()) || Double.isInfinite(t.getMyz())) {
            return false;
        }
        if (Double.isNaN(t.getMzx()) || Double.isInfinite(t.getMzx())) {
            return false;
        }
        if (Double.isNaN(t.getMzy()) || Double.isInfinite(t.getMzy())) {
            return false;
        }
        if (Double.isNaN(t.getMzz()) || Double.isInfinite(t.getMzz())) {
            return false;
        }
        if (Double.isNaN(t.getTx()) || Double.isInfinite(t.getTx())) {
            return false;
        }
        if (Double.isNaN(t.getTy()) || Double.isInfinite(t.getTy())) {
            return false;
        }
        return !Double.isNaN(t.getTz()) && !Double.isInfinite(t.getTz());
    }

    protected abstract void localToParentTransformChanged(Node var1, Transform var2, Transform var3);

    protected void onBoundsChanged() {
        if (this.layoutBoundsChanged && this.boundsInLocalChanged && this.boundsInParentChanged) {
            this.layoutBoundsChanged = false;
            this.boundsInLocalChanged = false;
            this.boundsInParentChanged = false;
            this.boundsInLocalChanged(this.oldBoundsInLocal, this.newBoundsInLocal);
        }
    }

    public void register(Node observed, Node observer) {
        Object transformChangeListener;
        Node current;
        if (observed == null) {
            throw new IllegalArgumentException("Observed may not be null.");
        }
        if (observer == null) {
            throw new IllegalArgumentException("Observer not be null.");
        }
        Node commonAncestor = this.getNearestCommonAncestor(observed, observer);
        if (commonAncestor == null) {
            throw new IllegalArgumentException("Source and target do not share a common ancestor.");
        }
        Node tmp = observed;
        while (tmp != null && tmp != commonAncestor) {
            tmp = tmp.getParent();
        }
        if (tmp == null) {
            throw new IllegalArgumentException("TransformReference needs to be ancestor of the given observed node.");
        }
        if (this.observed != null) {
            this.unregister();
        }
        this.observed = observed;
        this.parent = commonAncestor;
        observed.layoutBoundsProperty().addListener(this.layoutBoundsListener);
        observed.boundsInLocalProperty().addListener(this.boundsInLocalListener);
        observed.boundsInParentProperty().addListener(this.boundsInParentListener);
        tmp = observed;
        while (tmp != null && tmp != this.parent) {
            current = tmp;
            transformChangeListener = new ChangeListener<Transform>(){

                public void changed(ObservableValue<? extends Transform> observable, Transform oldValue, Transform newValue) {
                    if (VisualChangeListener.this.isValidTransform(newValue)) {
                        VisualChangeListener.this.localToParentTransformChanged(current, oldValue, newValue);
                    }
                }
            };
            tmp.localToParentTransformProperty().addListener((ChangeListener)transformChangeListener);
            this.localToParentTransformListeners.put((ChangeListener<Transform>)transformChangeListener, tmp);
            tmp = tmp.getParent();
        }
        tmp = observer;
        while (tmp != null && tmp != this.parent) {
            current = tmp;
            transformChangeListener = new ChangeListener<Transform>(){

                public void changed(ObservableValue<? extends Transform> observable, Transform oldValue, Transform newValue) {
                    if (VisualChangeListener.this.isValidTransform(newValue)) {
                        VisualChangeListener.this.localToParentTransformChanged(current, oldValue, newValue);
                    }
                }
            };
            tmp.localToParentTransformProperty().addListener((ChangeListener)transformChangeListener);
            this.localToParentTransformListeners.put((ChangeListener<Transform>)transformChangeListener, tmp);
            tmp = tmp.getParent();
        }
    }

    public void unregister() {
        if (!this.isRegistered()) {
            return;
        }
        this.observed.layoutBoundsProperty().removeListener(this.layoutBoundsListener);
        this.observed.boundsInLocalProperty().removeListener(this.boundsInLocalListener);
        this.observed.boundsInParentProperty().removeListener(this.boundsInParentListener);
        for (ChangeListener<Transform> l : this.localToParentTransformListeners.keySet()) {
            this.localToParentTransformListeners.get(l).localToParentTransformProperty().removeListener(l);
        }
        this.parent = null;
        this.observed = null;
        this.localToParentTransformListeners.clear();
    }
}

