/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.factory;

import org.eclipse.jpt.common.utility.factory.InterruptibleFactory;

public class ThreadLocalInterruptibleFactory<T>
implements InterruptibleFactory<T> {
    private final ThreadLocal<InterruptibleFactory<? extends T>> threadLocal;
    private final InterruptibleFactory<? extends T> defaultInterruptibleFactory;

    public ThreadLocalInterruptibleFactory(InterruptibleFactory<? extends T> defaultInterruptibleFactory) {
        if (defaultInterruptibleFactory == null) {
            throw new NullPointerException();
        }
        this.defaultInterruptibleFactory = defaultInterruptibleFactory;
        this.threadLocal = this.buildThreadLocal();
    }

    private ThreadLocal<InterruptibleFactory<? extends T>> buildThreadLocal() {
        return new ThreadLocal<InterruptibleFactory<? extends T>>();
    }

    @Override
    public T create() throws InterruptedException {
        return this.get().create();
    }

    private InterruptibleFactory<? extends T> get() {
        InterruptibleFactory<? extends T> factory = this.threadLocal.get();
        return factory != null ? factory : this.defaultInterruptibleFactory;
    }

    public void set(InterruptibleFactory<? extends T> factory) {
        this.threadLocal.set(factory);
    }

    public String toString() {
        return this.get().toString();
    }
}

