/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.archive.converter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.archive.converter.AbstractXmlConverter;
import org.eclipse.jubula.client.archive.schema.ExecCategory;
import org.eclipse.jubula.client.archive.schema.Project;
import org.eclipse.jubula.client.archive.schema.RefTestSuite;
import org.eclipse.jubula.client.archive.schema.TestJobs;
import org.eclipse.jubula.client.archive.schema.TestSuite;

public class RefTSNameConverter
extends AbstractXmlConverter {
    private static final int HIGHEST_META_DATA_VERSION_NUMBER = 6;
    private Map<String, TestSuite> m_testSuiteMap = new HashMap<String, TestSuite>();
    private List<TestJobs> m_testJobs = new ArrayList<TestJobs>();

    @Override
    protected boolean conversionIsNecessary(Project xml) {
        return xml.getMetaDataVersion() <= 6;
    }

    @Override
    protected void convertImpl(Project xml) {
        List<ExecCategory> execList = xml.getExecCategoriesList();
        for (ExecCategory execCategory : execList) {
            this.getAllTestJobsAndSuites(execCategory.getCategoryList());
        }
        for (TestJobs jobs : this.m_testJobs) {
            for (TestJobs.Testjobelement element : jobs.getTestjobelementList()) {
                RefTestSuite refTS;
                TestSuite ts;
                if (!(element instanceof RefTestSuite) || (ts = this.m_testSuiteMap.get((refTS = (RefTestSuite)((Object)element)).getTsGuid())) == null || !StringUtils.equals((String)refTS.getName(), (String)ts.getName())) continue;
                refTS.setName(null);
            }
        }
    }

    private void getAllTestJobsAndSuites(List<ExecCategory> execList) {
        if (execList.size() > 0) {
            for (ExecCategory execCategory : execList) {
                for (TestSuite ts : execCategory.getTestsuiteList()) {
                    this.m_testSuiteMap.put(ts.getGUID(), ts);
                }
                for (TestJobs job : execCategory.getTestjobList()) {
                    this.m_testJobs.add(job);
                }
                this.getAllTestJobsAndSuites(execCategory.getCategoryList());
            }
        }
    }
}

