/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.propertysources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.controllers.propertydescriptors.JBPropertyDescriptor;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.AbstractNodePropertySource;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.AbstractPropertySource;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.DisabledLabelProvider;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class RefTestSuiteGUIPropertySource
extends AbstractNodePropertySource {
    private static final String P_REF_TS_DISPLAY_NAME = org.eclipse.jubula.client.ui.rcp.i18n.Messages.RefTestSuiteGUIPropertySourceRefTSName;
    private static final String P_SPEC_TS_DISPLAY_NAME = org.eclipse.jubula.client.ui.rcp.i18n.Messages.RefTestSuiteGUIPropertySourceSpecTSName;
    private static final String P_AUT_ID_DISPLAY_NAME = org.eclipse.jubula.client.ui.rcp.i18n.Messages.RefTestSuiteGUIPropertySourceAutIdName;
    private String[] m_autIdList = new String[0];
    private IPropertyDescriptor m_autIdPropDesc = null;
    private IPropertyDescriptor m_namePropDesc = null;
    private IPropertyDescriptor m_specNameDesc = null;

    public RefTestSuiteGUIPropertySource(IRefTestSuitePO reftestsuiteGui) {
        super((INodePO)reftestsuiteGui);
        this.fillAutIdList(reftestsuiteGui);
    }

    private void fillAutIdList(IRefTestSuitePO refTestSuite) {
        HashSet<String> idSet = new HashSet<String>();
        ITestSuitePO ts = refTestSuite.getTestSuite();
        IAUTMainPO aut = ts.getAut();
        if (aut != null) {
            idSet.addAll(aut.getAutIds());
            for (IAUTConfigPO conf : aut.getAutConfigSet()) {
                idSet.add(conf.getValue("AUT_ID", ""));
            }
        }
        ArrayList idList = new ArrayList(idSet);
        Collections.sort(idList);
        this.m_autIdList = idList.toArray(new String[idList.size()]);
    }

    @Override
    protected void initPropDescriptor() {
        if (!this.getPropertyDescriptorList().isEmpty()) {
            this.clearPropertyDescriptors();
        }
        if (this.m_namePropDesc == null) {
            this.m_namePropDesc = new TextPropertyDescriptor((Object)new ExecNameController(), P_REF_TS_DISPLAY_NAME);
        }
        this.addPropertyDescriptor(this.m_namePropDesc);
        if (this.m_specNameDesc == null) {
            JBPropertyDescriptor specNameDesc = new JBPropertyDescriptor(new SpecNameController(), P_SPEC_TS_DISPLAY_NAME);
            specNameDesc.setLabelProvider((ILabelProvider)new DisabledLabelProvider());
            this.m_specNameDesc = specNameDesc;
        }
        this.addPropertyDescriptor(this.m_specNameDesc);
        super.initPropDescriptor();
        if (this.getTaskIdPropDesc() == null) {
            JBPropertyDescriptor taskIdPropDesc = new JBPropertyDescriptor(new AbstractNodePropertySource.ReadOnlyTaskIdController(this), Messages.AbstractGuiNodePropertySourceTaskId);
            taskIdPropDesc.setLabelProvider((ILabelProvider)new DisabledLabelProvider());
            this.setTaskIdPropDesc((IPropertyDescriptor)taskIdPropDesc);
        }
        this.addPropertyDescriptor(this.getTaskIdPropDesc());
        this.addPropertyDescriptor(this.getAutIdPropDesc());
    }

    private IPropertyDescriptor getAutIdPropDesc() {
        if (this.m_autIdPropDesc == null) {
            ComboBoxPropertyDescriptor cbpd = new ComboBoxPropertyDescriptor((Object)new AutIdController(), P_AUT_ID_DISPLAY_NAME, this.m_autIdList);
            cbpd.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof Integer) {
                        if (RefTestSuiteGUIPropertySource.this.m_autIdList.length == 0 || (Integer)element == -1) {
                            return "";
                        }
                        return RefTestSuiteGUIPropertySource.this.m_autIdList[(Integer)element];
                    }
                    Assert.notReached((String)(String.valueOf(org.eclipse.jubula.client.ui.rcp.i18n.Messages.WrongTypeOfElement) + "."));
                    return String.valueOf(element);
                }
            });
            this.m_autIdPropDesc = cbpd;
        }
        return this.m_autIdPropDesc;
    }

    private class AutIdController
    extends AbstractPropertySource.AbstractPropertyController {
        private AutIdController() {
        }

        public boolean setProperty(Object value) {
            IRefTestSuitePO refTestSuite = (IRefTestSuitePO)RefTestSuiteGUIPropertySource.this.getPoNode();
            if (!(value instanceof String)) {
                if (value instanceof Integer) {
                    int pos = (Integer)value;
                    if (RefTestSuiteGUIPropertySource.this.m_autIdList.length > pos && pos >= 0) {
                        refTestSuite.setTestSuiteAutID(RefTestSuiteGUIPropertySource.this.m_autIdList[pos]);
                        return true;
                    }
                } else {
                    return false;
                }
            }
            refTestSuite.setTestSuiteAutID((String)value);
            return true;
        }

        public Object getProperty() {
            IRefTestSuitePO refTestSuite = (IRefTestSuitePO)RefTestSuiteGUIPropertySource.this.getPoNode();
            String autID = refTestSuite.getTestSuiteAutID();
            int i = 0;
            while (i < RefTestSuiteGUIPropertySource.this.m_autIdList.length) {
                if (RefTestSuiteGUIPropertySource.this.m_autIdList[i].equals(autID)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public Image getImage() {
            return DEFAULT_IMAGE;
        }
    }

    protected class ExecNameController
    extends AbstractNodePropertySource.ElementNameController {
        protected ExecNameController() {
            super(RefTestSuiteGUIPropertySource.this);
        }

        @Override
        public Object getProperty() {
            IRefTestSuitePO refTs;
            String name;
            if (RefTestSuiteGUIPropertySource.this.getPoNode() != null && (name = (refTs = (IRefTestSuitePO)RefTestSuiteGUIPropertySource.this.getPoNode()).getRealName()) != null) {
                return name;
            }
            return "";
        }
    }

    protected class SpecNameController
    extends AbstractPropertySource.AbstractPropertyController {
        protected SpecNameController() {
        }

        public boolean setProperty(Object value) {
            return true;
        }

        public Object getProperty() {
            IRefTestSuitePO exTc = (IRefTestSuitePO)RefTestSuiteGUIPropertySource.this.getPoNode();
            if (exTc.getTestSuite() != null) {
                return exTc.getTestSuite().getName();
            }
            return "";
        }

        @Override
        public Image getImage() {
            return READONLY_IMAGE;
        }
    }
}

