/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.meta.commands.processes;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jwt.meta.model.processes.ActivityNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveActivityNodeCommand
extends RemoveCommand {
    private EditingDomain editingDomain;
    protected CompoundCommand removeEdgesCommands;

    public RemoveActivityNodeCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        super(domain, owner, feature, collection);
        this.editingDomain = domain;
    }

    public void doExecute() {
        ArrayList<ActivityNode> newCollection = new ArrayList<ActivityNode>();
        for (ActivityNode actNode : this.collection) {
            if (actNode.eContainer() == null) continue;
            newCollection.add(actNode);
        }
        this.collection = newCollection;
        this.removeEdgesCommands = new CompoundCommand();
        for (ActivityNode node : this.collection) {
            if (!node.getIn().isEmpty()) {
                this.removeEdgesCommands.append(DeleteCommand.create((EditingDomain)this.editingDomain, node.getIn()));
            }
            if (node.getOut().isEmpty()) continue;
            this.removeEdgesCommands.append(DeleteCommand.create((EditingDomain)this.editingDomain, node.getOut()));
        }
        if (this.removeEdgesCommands.canExecute()) {
            this.removeEdgesCommands.execute();
        }
        this.doExecuteOriginal();
    }

    protected void doExecuteOriginal() {
        super.doExecute();
    }

    public void doRedo() {
        if (!this.removeEdgesCommands.isEmpty()) {
            this.removeEdgesCommands.redo();
        }
        super.doRedo();
    }

    public void doUndo() {
        super.doUndo();
        if (!this.removeEdgesCommands.isEmpty()) {
            this.removeEdgesCommands.undo();
        }
    }

    public void doDispose() {
        super.doDispose();
        if (this.removeEdgesCommands != null) {
            this.removeEdgesCommands.dispose();
        }
    }
}

