/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.actions.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jwt.we.editors.actions.WEActionHandler;
import org.eclipse.jwt.we.editors.pages.activityEditor.internal.IActivityEditor;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.ui.IWorkbenchPart;

public final class AlignmentHandler
extends WEActionHandler {
    public AlignmentHandler() {
        super(true);
    }

    protected List getSelectedEditParts(Request request) {
        List editparts = new ArrayList(GeneralHelper.getActiveInstance().getCurrentActivitySheet().getGraphicalViewer().getSelectedEditParts());
        if (editparts.isEmpty() || !(editparts.get(0) instanceof GraphicalEditPart)) {
            return Collections.EMPTY_LIST;
        }
        Object primary = editparts.get(editparts.size() - 1);
        editparts = ToolUtilities.getSelectionWithoutDependants(editparts);
        ToolUtilities.filterEditPartsUnderstanding(editparts, (Request)request);
        if (editparts.size() < 2 || !editparts.contains(primary)) {
            return Collections.EMPTY_LIST;
        }
        EditPart parent = ((EditPart)editparts.get(0)).getParent();
        int i = 1;
        while (i < editparts.size()) {
            EditPart part = (EditPart)editparts.get(i);
            if (part.getParent() != parent) {
                return Collections.EMPTY_LIST;
            }
            ++i;
        }
        return editparts;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (GeneralHelper.getActiveInstance() == null) {
            this.setEnabled(false);
            return;
        }
        if (GeneralHelper.getActiveInstance().getActiveEditor() instanceof IActivityEditor) {
            Command cmd = this.createAlignmentCommand(8);
            if (cmd != null && cmd.canExecute()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            return;
        }
        this.setEnabled(false);
    }

    private int getCommandType(ExecutionEvent event) {
        String commandId = "";
        try {
            commandId = event.getCommand().getId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (commandId.equals("org.eclipse.jwt.we.alignTopCommand")) {
            return 8;
        }
        if (commandId.equals("org.eclipse.jwt.we.alignBottomCommand")) {
            return 32;
        }
        if (commandId.equals("org.eclipse.jwt.we.alignRightCommand")) {
            return 4;
        }
        if (commandId.equals("org.eclipse.jwt.we.alignLeftCommand")) {
            return 1;
        }
        if (commandId.equals("org.eclipse.jwt.we.alignCenterCommand")) {
            return 2;
        }
        if (commandId.equals("org.eclipse.jwt.we.alignMiddleCommand")) {
            return 16;
        }
        return 0;
    }

    protected Rectangle calculateAlignmentRectangle(Request request) {
        List editparts = this.getSelectedEditParts(request);
        if (editparts == null || editparts.isEmpty()) {
            return null;
        }
        GraphicalEditPart part = (GraphicalEditPart)editparts.get(editparts.size() - 1);
        PrecisionRectangle rect = new PrecisionRectangle(part.getFigure().getBounds());
        part.getFigure().translateToAbsolute((Translatable)rect);
        return rect;
    }

    private Command createAlignmentCommand(int alignmentType) {
        AlignmentRequest request = new AlignmentRequest((Object)"align");
        request.setAlignmentRectangle(this.calculateAlignmentRectangle((Request)request));
        request.setAlignment(alignmentType);
        List editparts = this.getSelectedEditParts((Request)request);
        if (editparts.size() < 2) {
            return null;
        }
        CompoundCommand command = new CompoundCommand();
        int i = 0;
        while (i < editparts.size()) {
            EditPart editpart = (EditPart)editparts.get(i);
            command.add(editpart.getCommand((Request)request));
            ++i;
        }
        return command;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Command command = this.createAlignmentCommand(this.getCommandType(event));
        if (command != null && command.canExecute()) {
            GeneralHelper.getActiveInstance().getEditDomain().getCommandStack().execute(command);
        }
        return null;
    }
}

