/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.docker.core.IRegistry;
import org.eclipse.linuxtools.docker.core.IRegistryAccount;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.RegistryAccountManager;
import org.eclipse.linuxtools.internal.docker.core.RegistryInfo;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImagePullPushPageModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImagePushPageModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.RegistryAccountDialog;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;

public abstract class ImagePullPushPage<M extends ImagePullPushPageModel>
extends WizardPage {
    protected final DataBindingContext dbc;
    protected final String DOCKER_DAEMON_DEFAULT = "https://index.docker.io";
    private final M model;

    public ImagePullPushPage(String pageName, String title, M model) {
        super(pageName, title, SWTImagesFactory.DESC_BANNER_REPOSITORY);
        this.setMessage(WizardMessages.getString("ImagePull.desc"));
        this.dbc = new DataBindingContext();
        this.model = model;
    }

    M getModel() {
        return this.model;
    }

    IObservableValue<IRegistry> createRegistrySelectionControls(Composite parent) {
        Label accountLabel = new Label(parent, 0);
        accountLabel.setText(WizardMessages.getString("ImagePullPushPage.registry.account.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)accountLabel);
        Combo registryAccountCombo = new Combo(parent, 12);
        registryAccountCombo.setToolTipText(WizardMessages.getString("ImagePullPushPage.registry.account.desc"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)registryAccountCombo);
        ComboViewer registryAccountComboViewer = new ComboViewer(registryAccountCombo);
        registryAccountComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        registryAccountComboViewer.setLabelProvider((IBaseLabelProvider)new RegistryAccountLabelProvider());
        List<IRegistry> allRegistryAccounts = this.getRegistryAccounts();
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        IRegistry defaultRegistry = null;
        String lastRegistry = store.getString("lastRegistryAccount");
        if (!allRegistryAccounts.isEmpty()) {
            defaultRegistry = allRegistryAccounts.get(0);
        }
        IRegistry selectedRegistry = allRegistryAccounts.stream().filter(x -> ((RegistryInfo)x).getRegistryId().equals(lastRegistry)).findFirst().orElse(defaultRegistry);
        registryAccountComboViewer.setInput(allRegistryAccounts);
        if (selectedRegistry != null) {
            ((ImagePullPushPageModel)this.getModel()).setSelectedRegistry(selectedRegistry);
        }
        IObservableValue registryAccountObservable = BeanProperties.value(ImagePushPageModel.class, (String)"selectedRegistry").observe(this.model);
        this.dbc.bindValue((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)registryAccountComboViewer), registryAccountObservable);
        Link addRegistryLink = new Link(parent, 0);
        addRegistryLink.setText(WizardMessages.getString("ImagePullPushPage.add.link"));
        GridDataFactory.fillDefaults().align(131072, 0x1000000).grab(false, false).applyTo((Control)addRegistryLink);
        addRegistryLink.addSelectionListener(this.onAddRegistry(registryAccountComboViewer));
        return registryAccountObservable;
    }

    private SelectionListener onAddRegistry(ComboViewer registryAccountComboViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            RegistryAccountDialog dialog = new RegistryAccountDialog(this.getShell(), WizardMessages.getString("ImagePullPushPage.addregistry.title"), "https://index.docker.io", WizardMessages.getString("RegistryAccountDialog.add.explanation"));
            if (dialog.open() == 0) {
                RegistryAccountManager.getInstance().add(dialog.getSignonInformation());
                List<IRegistry> updatedRegistryAccounts = this.getRegistryAccounts();
                registryAccountComboViewer.setInput(updatedRegistryAccounts);
                ((ImagePullPushPageModel)this.model).setSelectedRegistry((IRegistry)dialog.getSignonInformation());
            }
        });
    }

    protected List<IRegistry> getRegistryAccounts() {
        ArrayList<IRegistry> accounts = new ArrayList<IRegistry>(RegistryAccountManager.getInstance().getAccounts());
        accounts.add(0, (IRegistry)new RegistryInfo("https://index.docker.io", true));
        return accounts;
    }

    static final class RegistryAccountLabelProvider
    extends ColumnLabelProvider {
        RegistryAccountLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IRegistryAccount) {
                IRegistryAccount registryAccount = (IRegistryAccount)element;
                StringBuilder textBuilder = new StringBuilder();
                if (registryAccount.getUsername() != null) {
                    textBuilder.append(registryAccount.getUsername()).append('@');
                }
                textBuilder.append(registryAccount.getServerAddress());
                return textBuilder.toString();
            }
            if (element instanceof IRegistry) {
                IRegistry registry = (IRegistry)element;
                return registry.getServerAddress();
            }
            return null;
        }
    }
}

