/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.uml.tools.utils.ActivityEdgeUtil;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.StructuredActivityNode;

public class ActivityEdgeReparentCommand
extends AbstractTransactionalCommand {
    private ActivityEdge edge;

    public ActivityEdgeReparentCommand(TransactionalEditingDomain domain, ActivityEdge edge) {
        super(domain, "ActivityEdge reparent command", null);
        this.edge = edge;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.changeContainer(this.edge);
        return CommandResult.newOKCommandResult();
    }

    private boolean changeContainer(ActivityEdge edge) {
        Element proposedContainer = ActivityEdgeUtil.deduceContainer((EObject)edge.getSource(), (EObject)edge.getTarget());
        if (proposedContainer == null) {
            return false;
        }
        if (proposedContainer != edge.getOwner()) {
            if (proposedContainer instanceof Activity) {
                ((Activity)proposedContainer).getEdges().add((Object)edge);
            } else if (proposedContainer instanceof StructuredActivityNode) {
                ((StructuredActivityNode)proposedContainer).getEdges().add((Object)edge);
            }
        }
        return true;
    }
}

