/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.visitor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.ProblemSeverities;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.core.compiler.ast.nodes.AnonymousClassDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.ArrayVariableReference;
import org.eclipse.php.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.core.compiler.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPCallExpression;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.core.compiler.ast.nodes.PHPFieldDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPMethodDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPModuleDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.TraitUseStatement;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.core.compiler.ast.nodes.VarComment;
import org.eclipse.php.core.compiler.ast.validator.IValidatorExtension;
import org.eclipse.php.core.compiler.ast.validator.IValidatorVisitor;
import org.eclipse.php.core.compiler.ast.visitor.PHPASTVisitor;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.compiler.ast.parser.Messages;
import org.eclipse.php.internal.core.compiler.ast.parser.PHPProblemIdentifier;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.evaluators.PHPEvaluationUtils;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;

public class ValidatorVisitor
extends PHPASTVisitor
implements IValidatorVisitor {
    private static final String EXTENSION_POINT = "org.eclipse.php.core.validatorExtension";
    private static final String ATTR_CLASS = "class";
    private static final String PAAMAYIM_NEKUDOTAIM = "::";
    private static final List<String> TYPE_SKIP = new ArrayList<String>();
    private static final List<String> COMMENT_TYPE_SKIP = new ArrayList<String>();
    private Map<String, UsePartInfo> usePartInfo = new LinkedHashMap<String, UsePartInfo>();
    private Map<String, Boolean> elementExists = new HashMap<String, Boolean>();
    private NamespaceDeclaration currentNamespace;
    private Set<String> typeDeclared = new HashSet<String>();
    private ArrayList<VarComment> varComments = new ArrayList();
    private boolean hasNamespace;
    private ISourceModule sourceModule;
    private PHPVersion version;
    private IBuildContext context;
    private IValidatorExtension[] extensions;
    private Stack<NamespaceDeclaration> fNamespaceDeclarations = new Stack();

    static {
        TYPE_SKIP.add("parent");
        TYPE_SKIP.add("self");
        TYPE_SKIP.add("static");
        TYPE_SKIP.add("null");
        COMMENT_TYPE_SKIP.add("true");
        COMMENT_TYPE_SKIP.add("false");
    }

    public ValidatorVisitor(IBuildContext context) {
        this.context = context;
        this.sourceModule = context.getSourceModule();
        this.version = ProjectOptions.getPHPVersion((IModelElement)this.sourceModule);
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT);
        ArrayList<IValidatorExtension> list = new ArrayList<IValidatorExtension>(elements.length);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            try {
                IValidatorExtension tmp;
                Object ext = el.createExecutableExtension(ATTR_CLASS);
                if (ext != null && ext instanceof IValidatorExtension && (tmp = (IValidatorExtension)ext).isSupported(context)) {
                    tmp.init(context, this);
                    list.add(tmp);
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        this.extensions = list.toArray(new IValidatorExtension[0]);
    }

    public boolean visit(ModuleDeclaration s) throws Exception {
        if (s instanceof PHPModuleDeclaration) {
            this.varComments.addAll(((PHPModuleDeclaration)s).getVarComments());
        }
        return super.visit(s);
    }

    public boolean endvisit(ModuleDeclaration s) throws Exception {
        boolean res = super.endvisit(s);
        if (!this.hasNamespace) {
            this.checkUnusedImport();
        }
        return res;
    }

    @Override
    public boolean visit(NamespaceDeclaration s) throws Exception {
        this.hasNamespace = true;
        this.currentNamespace = s;
        this.fNamespaceDeclarations.push(s);
        if (this.fNamespaceDeclarations.size() > 1) {
            this.reportProblem((ASTNode)s, Messages.NestedNamespaceDeclarations, PHPProblemIdentifier.NestedNamespaceDeclarations, ProblemSeverities.Error);
        }
        this.visitGeneral((ASTNode)s);
        return true;
    }

    @Override
    public boolean endvisit(NamespaceDeclaration s) throws Exception {
        boolean res = super.endvisit(s);
        this.checkUnusedImport();
        this.fNamespaceDeclarations.pop();
        return res;
    }

    @Override
    public boolean visit(PHPMethodDeclaration s) throws Exception {
        if (s.getPHPDoc() != null) {
            s.getPHPDoc().traverse(this);
        }
        return this.visitGeneral((ASTNode)s);
    }

    @Override
    public boolean visit(PHPFieldDeclaration s) throws Exception {
        if (s.getPHPDoc() != null) {
            s.getPHPDoc().traverse(this);
        }
        return super.visit(s);
    }

    @Override
    public boolean visit(PHPCallExpression node) throws Exception {
        if (node.getReceiver() != null) {
            node.getReceiver().traverse((ASTVisitor)this);
        }
        if (node.getArgs() != null) {
            node.getArgs().traverse((ASTVisitor)this);
        }
        this.visitGeneral((ASTNode)node);
        return false;
    }

    @Override
    public boolean visit(FullyQualifiedReference node) throws Exception {
        if (node.getElementType() == 1) {
            return this.visit((TypeReference)node);
        }
        return super.visit(node);
    }

    @Override
    public boolean visit(TypeReference node) throws Exception {
        return this.visit(node, ProblemSeverities.Error, false);
    }

    private boolean visit(TypeReference node, ProblemSeverity severity, boolean isInDoc) throws Exception {
        boolean isFound;
        boolean skip = false;
        skip = isInDoc ? PHPSimpleTypes.isSimpleType(node.getName()) : PHPSimpleTypes.isHintable(node.getName(), this.version);
        if (skip || TYPE_SKIP.contains(node.getName().toLowerCase())) {
            this.visitGeneral((ASTNode)node);
            return true;
        }
        TypeReferenceInfo tri = new TypeReferenceInfo(node, false);
        String nodeName = tri.getTypeName();
        String key = null;
        key = tri.isGlobal() ? nodeName : this.getFirstSegmentOfTypeName(nodeName);
        UsePartInfo info = this.usePartInfo.get(key.toLowerCase());
        if (info != null) {
            info.increaseRefCount();
        }
        if (!(isFound = this.findElement(tri))) {
            this.reportProblem((ASTNode)node, Messages.UndefinedType, (IProblemIdentifier)PHPProblemIdentifier.UndefinedType, node.getName(), severity);
        }
        this.visitGeneral((ASTNode)node);
        return false;
    }

    @Override
    public boolean visit(AnonymousClassDeclaration s) throws Exception {
        List<TypeReference> interfaces;
        int end = s.start();
        int start = end - 1;
        while (this.sourceModule.getSource().charAt(start) != ' ') {
            --start;
        }
        this.checkUnimplementedMethods((Statement)s, start + 1, end);
        IModelElement element = this.sourceModule.getElementAt(s.start());
        if (s.getSuperClass() != null && element != null) {
            this.checkSuperclass(s.getSuperClass(), false, element.getElementName());
        }
        if ((interfaces = s.getInterfaceList()) != null && element != null) {
            for (TypeReference itf : interfaces) {
                this.checkSuperclass(itf, true, element.getElementName());
            }
        }
        return super.visit(s);
    }

    @Override
    public boolean visit(ClassDeclaration s) throws Exception {
        Collection<TypeReference> interfaces;
        this.checkUnimplementedMethods((Statement)s, (ASTNode)s.getRef());
        if (s.getSuperClass() != null) {
            this.checkSuperclass(s.getSuperClass(), false, s.getName());
        }
        if ((interfaces = s.getInterfaceList()) != null && interfaces.size() > 0) {
            for (TypeReference itf : interfaces) {
                this.checkSuperclass(itf, true, s.getName());
            }
        }
        return this.visitGeneral((ASTNode)s);
    }

    @Override
    public boolean visit(ClassInstanceCreation s) throws Exception {
        if (s.getClassName() instanceof TypeReference) {
            IType[] types;
            TypeReferenceInfo tri = new TypeReferenceInfo((TypeReference)s.getClassName(), false);
            IType[] iTypeArray = types = this.getAllTypes(tri.getFullyQualifiedName(), this.sourceModule, s.getClassName().sourceStart());
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                if (PHPFlags.isTrait(type.getFlags()) || PHPFlags.isInterface((int)type.getFlags()) || PHPFlags.isAbstract((int)type.getFlags())) {
                    this.reportProblem((ASTNode)s.getClassName(), Messages.CannotInstantiateType, (IProblemIdentifier)PHPProblemIdentifier.CannotInstantiateType, type.getElementName(), ProblemSeverities.Error);
                    break;
                }
                ++n2;
            }
        }
        return this.visitGeneral((ASTNode)s);
    }

    @Override
    public boolean visit(InterfaceDeclaration s) throws Exception {
        if (s.getSuperClasses() == null) {
            return this.visitGeneral((ASTNode)s);
        }
        for (ASTNode node : s.getSuperClasses().getChilds()) {
            this.checkSuperclass((TypeReference)node, true, s.getName());
        }
        return this.visitGeneral((ASTNode)s);
    }

    @Override
    public boolean visit(TypeDeclaration s) throws Exception {
        if (!(s instanceof NamespaceDeclaration)) {
            this.checkDuplicateTypeDeclaration(s);
        }
        return super.visit(s);
    }

    @Override
    public boolean visit(UsePart part) throws Exception {
        int elementType;
        UsePartInfo info = new UsePartInfo(part);
        TypeReferenceInfo tri = info.getTypeReferenceInfo();
        if (tri.getTypeReference() instanceof FullyQualifiedReference && ((elementType = ((FullyQualifiedReference)tri.getTypeReference()).getElementType()) == 3 || elementType == 2)) {
            this.visitGeneral(part);
            return false;
        }
        String name = tri.getTypeName();
        String currentNamespaceName = this.currentNamespace == null || this.currentNamespace.isGlobal() ? "" : this.currentNamespace.getName();
        String lcName = info.getRealName().toLowerCase();
        if (!this.findElement(tri)) {
            info.isProblemReported = true;
            this.reportProblem((ASTNode)tri.getTypeReference(), Messages.ImportNotFound, (IProblemIdentifier)PHPProblemIdentifier.ImportNotFound, name, ProblemSeverities.Error);
        } else if (this.usePartInfo.get(lcName) != null) {
            info.isProblemReported = true;
            this.reportProblem((ASTNode)tri.getTypeReference(), Messages.DuplicateImport, (IProblemIdentifier)PHPProblemIdentifier.DuplicateImport, new String[]{name, info.getRealName()}, ProblemSeverities.Error);
        } else if (!info.isAlias && info.getNamespaceName().equals(currentNamespaceName)) {
            info.isProblemReported = true;
            this.reportProblem((ASTNode)tri.getTypeReference(), Messages.UnnecessaryImport, (IProblemIdentifier)PHPProblemIdentifier.UnnecessaryImport, new String[]{name}, ProblemSeverities.Warning);
        }
        this.usePartInfo.put(lcName, info);
        this.visitGeneral(part);
        return false;
    }

    @Override
    public boolean visit(TraitUseStatement s) throws Exception {
        List<TypeReference> traits = s.getTraitList();
        block0: for (TypeReference trait : traits) {
            IType[] types;
            TypeReferenceInfo tri = new TypeReferenceInfo(trait, false);
            IType[] iTypeArray = types = this.getAllTypes(tri.getFullyQualifiedName(), this.sourceModule, trait.start());
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                if (!PHPFlags.isTrait(type.getFlags())) {
                    this.reportProblem((ASTNode)trait, Messages.CannotUseTypeAsTrait, (IProblemIdentifier)PHPProblemIdentifier.CannotUseTypeAsTrait, new String[]{trait.getName()}, ProblemSeverities.Error);
                    continue block0;
                }
                ++n2;
            }
        }
        return this.visitGeneral((ASTNode)s);
    }

    private void visitCommentType(TypeReference typeReference, ProblemSeverity severity) throws Exception {
        if (COMMENT_TYPE_SKIP.contains(typeReference.getName().toLowerCase())) {
            return;
        }
        String name = typeReference.getName();
        assert (name.length() > 0);
        int idx = name.indexOf(PAAMAYIM_NEKUDOTAIM);
        if (idx == -1) {
            if (PHPTextSequenceUtilities.readIdentifierStartIndex(this.version, name, name.length(), false) == 0) {
                this.visit(typeReference, severity, true);
            }
        } else if (idx > 0 && PHPTextSequenceUtilities.readIdentifierStartIndex(this.version, name, idx, false) == 0) {
            this.visit(new TypeReference(typeReference.start(), typeReference.start() + idx, name.substring(0, idx)), severity, true);
        }
    }

    private void visitCommentTypes(TypeReference fullTypeReference) throws Exception {
        TypeReference typeReference;
        String typeName;
        String fullTypeName = fullTypeReference.getName();
        Matcher matcher = PHPEvaluationUtils.TYPE_DELIMS_PATTERN.matcher(fullTypeName);
        int start = 0;
        while (matcher.find()) {
            if (matcher.start() != start) {
                typeName = fullTypeName.substring(start, matcher.start());
                typeReference = new TypeReference(fullTypeReference.start() + start, fullTypeReference.start() + start + typeName.length(), typeName);
                this.visitCommentType(typeReference, ProblemSeverities.Warning);
            }
            start = matcher.end();
        }
        if (start == 0) {
            this.visitCommentType(fullTypeReference, ProblemSeverities.Warning);
        } else if (start != fullTypeName.length()) {
            typeName = fullTypeName.substring(start);
            typeReference = new TypeReference(fullTypeReference.start() + start, fullTypeReference.start() + start + typeName.length(), typeName);
            this.visitCommentType(typeReference, ProblemSeverities.Warning);
        }
    }

    @Override
    public boolean visit(PHPDocTag phpDocTag) throws Exception {
        for (TypeReference fullTypeReference : phpDocTag.getTypeReferences()) {
            this.visitCommentTypes(fullTypeReference);
        }
        this.visitGeneral(phpDocTag);
        return false;
    }

    private boolean visit(VarComment varComment) throws Exception {
        TypeReference[] typeReferenceArray = varComment.getTypeReferences();
        int n = typeReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            TypeReference fullTypeReference = typeReferenceArray[n2];
            this.visitCommentTypes(fullTypeReference);
            ++n2;
        }
        this.visitGeneral(varComment);
        return false;
    }

    private void checkVarComment(VariableReference s) throws Exception {
        int minPos = this.currentNamespace != null ? this.currentNamespace.sourceStart() : 0;
        int maxPos = s.sourceStart();
        Iterator<VarComment> itr = this.varComments.iterator();
        while (itr.hasNext()) {
            VarComment varComment = itr.next();
            if (varComment.sourceStart() < minPos) {
                itr.remove();
                continue;
            }
            if (varComment.sourceEnd() > maxPos) break;
            this.visit(varComment);
            itr.remove();
        }
    }

    @Override
    public boolean visit(VariableReference s) throws Exception {
        this.checkVarComment(s);
        return super.visit(s);
    }

    @Override
    public boolean visit(ArrayVariableReference s) throws Exception {
        this.checkVarComment(s);
        return super.visit(s);
    }

    private void checkDuplicateTypeDeclaration(TypeDeclaration node) {
        String name = node.getName();
        String currentNamespaceName = this.currentNamespace == null || this.currentNamespace.isGlobal() ? "" : this.currentNamespace.getName();
        boolean isDuplicateWithUse = false;
        UsePartInfo info = this.usePartInfo.get(name.toLowerCase());
        if (info != null) {
            String fullyQualifiedName = PHPModelUtils.concatFullyQualifiedNames("\\", currentNamespaceName, name);
            if (!info.getFullyQualifiedName().equals(fullyQualifiedName)) {
                isDuplicateWithUse = true;
            }
        }
        if (isDuplicateWithUse || !this.typeDeclared.add(name.toLowerCase())) {
            this.reportProblem((ASTNode)node.getRef(), Messages.DuplicateDeclaration, (IProblemIdentifier)PHPProblemIdentifier.DuplicateDeclaration, name, ProblemSeverities.Error);
        }
    }

    private void checkUnimplementedMethods(Statement statement, ASTNode classNode) throws ModelException {
        this.checkUnimplementedMethods(statement, classNode.sourceStart(), classNode.sourceEnd());
    }

    private void checkUnimplementedMethods(Statement statement, int nodeStart, int nodeEnd) throws ModelException {
        IModelElement element = this.sourceModule.getElementAt(statement.start());
        if (!(element instanceof IType)) {
            return;
        }
        IType type = (IType)element;
        if (type.getSuperClasses().length > 0 && !PHPFlags.isAbstract((int)type.getFlags())) {
            IMethod[] methods;
            IMethod[] iMethodArray = methods = PHPModelUtils.getUnimplementedMethods(type, null);
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (!method.getParent().getElementName().equals(type.getElementName())) {
                    StringBuilder methodName = new StringBuilder(method.getParent().getElementName()).append(PAAMAYIM_NEKUDOTAIM);
                    PHPModelUtils.getMethodLabel(method, methodName);
                    String message = Messages.getString("AbstractMethodMustBeImplemented", type.getElementName(), methodName.toString());
                    this.reportProblem(nodeStart, nodeEnd, message, PHPProblemIdentifier.AbstractMethodMustBeImplemented, ProblemSeverities.Error);
                }
                ++n2;
            }
        }
    }

    private void checkSuperclass(TypeReference superClass, boolean isInterface, String className) throws ModelException {
        if (superClass != null) {
            IType[] types;
            TypeReferenceInfo refInfo = new TypeReferenceInfo(superClass, false);
            IType[] iTypeArray = types = this.getAllTypes(refInfo.getFullyQualifiedName(), this.sourceModule, superClass.sourceStart());
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                if (!isInterface) {
                    if (PHPFlags.isTrait(type.getFlags()) || PHPFlags.isInterface((int)type.getFlags())) {
                        this.reportProblem((ASTNode)superClass, Messages.SuperclassMustBeAClass, (IProblemIdentifier)PHPProblemIdentifier.SuperclassMustBeAClass, new String[]{superClass.getName(), className}, ProblemSeverities.Error);
                    }
                    if (PHPFlags.isFinal((int)type.getFlags())) {
                        this.reportProblem((ASTNode)superClass, Messages.ClassExtendFinalClass, (IProblemIdentifier)PHPProblemIdentifier.ClassExtendFinalClass, new String[]{className, type.getElementName()}, ProblemSeverities.Error);
                    }
                } else if (PHPFlags.isTrait(type.getFlags()) || !PHPFlags.isInterface((int)type.getFlags())) {
                    this.reportProblem((ASTNode)superClass, Messages.SuperInterfaceMustBeAnInterface, (IProblemIdentifier)PHPProblemIdentifier.SuperInterfaceMustBeAnInterface, new String[]{superClass.getName(), className}, ProblemSeverities.Error);
                }
                ++n2;
            }
        }
    }

    private void checkUnusedImport() {
        Collection<UsePartInfo> useInfos = this.usePartInfo.values();
        for (UsePartInfo useInfo : useInfos) {
            if (useInfo.isProblemReported || useInfo.getRefCount() != 0) continue;
            FullyQualifiedReference m = useInfo.getUsePart().getNamespace();
            String name = useInfo.getUsePart().getFullUseStatementName();
            this.reportProblem((ASTNode)m, Messages.UnusedImport, (IProblemIdentifier)PHPProblemIdentifier.UnusedImport, name, ProblemSeverities.Warning);
        }
        this.usePartInfo.clear();
        this.elementExists.clear();
        this.typeDeclared.clear();
    }

    private boolean findElement(TypeReferenceInfo info) {
        String name = info.getFullyQualifiedName();
        if (this.elementExists.containsKey(name)) {
            return this.elementExists.get(name);
        }
        boolean isFound = false;
        try {
            TypeReference type = info.getTypeReference();
            int elementType = 1;
            if (type instanceof FullyQualifiedReference) {
                elementType = ((FullyQualifiedReference)type).getElementType();
            }
            switch (elementType) {
                case 1: {
                    IType[] elements = PHPModelUtils.getTypes(name, this.sourceModule, type.start(), null);
                    if (elements.length == 0) {
                        elements = PHPModelUtils.getTraits(name, this.sourceModule, type.start(), null, null);
                    }
                    if (elements.length == 0 && info.isUseStatement() && (elements = this.sourceModule.codeSelect(type.start(), type.end() - type.start())).length == 0) {
                        IType[] namespaces;
                        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)this.sourceModule.getScriptProject());
                        IType[] iTypeArray = namespaces = PHPModelAccess.getDefault().findNamespaces(null, info.getTypeName(), ISearchEngine.MatchRule.PREFIX, 0, 0, scope, null);
                        int n = namespaces.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IType namespace = iTypeArray[n2];
                            String namespaceName = namespace.getElementName();
                            String typeName = info.getTypeName();
                            if (namespaceName.length() > typeName.length() && namespaceName.charAt(typeName.length()) == '\\') {
                                isFound = true;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (elements.length > 0) {
                        isFound = true;
                    }
                    break;
                }
                case 2: 
                case 3: {
                    isFound = true;
                    break;
                }
                default: {
                    isFound = false;
                    break;
                }
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        this.elementExists.put(name, isFound);
        return isFound;
    }

    private void reportProblem(ASTNode s, String message, IProblemIdentifier id, String[] stringArguments, ProblemSeverity severity) {
        message = MessageFormat.format(message, stringArguments);
        this.reportProblem(s, message, id, severity);
    }

    @Override
    public void reportProblem(ASTNode s, String message, IProblemIdentifier id, ProblemSeverity severity) {
        IValidatorExtension[] iValidatorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IValidatorExtension extension = iValidatorExtensionArray[n2];
            if (extension.skipProblem(s, message, id)) {
                return;
            }
            ++n2;
        }
        int start = 0;
        int end = 0;
        if (s != null) {
            start = s.sourceStart();
            end = s.sourceEnd();
        } else {
            start = end = this.context.getLineTracker().getLineOffset(1);
        }
        this.reportProblem(start, end, message, id, severity);
    }

    private void reportProblem(ASTNode s, String message, IProblemIdentifier id, String stringArguments, ProblemSeverity severity) {
        this.reportProblem(s, message, id, new String[]{stringArguments}, severity);
    }

    @Override
    public void reportProblem(int start, int end, String message, IProblemIdentifier id, ProblemSeverity severity) {
        IValidatorExtension[] iValidatorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IValidatorExtension extension = iValidatorExtensionArray[n2];
            if (extension.skipProblem(start, end, message, id)) {
                return;
            }
            ++n2;
        }
        ISourceLineTracker tracker = this.context.getLineTracker();
        int line = tracker.getLineNumberOfOffset(start);
        DefaultProblem problem = new DefaultProblem(this.context.getFile().getName(), message, id, null, severity, start, end, line, 0);
        this.context.getProblemReporter().reportProblem((IProblem)problem);
    }

    private String getFirstSegmentOfTypeName(String typeName) {
        if (typeName != null) {
            String[] segments;
            String[] stringArray = segments = typeName.split("\\\\");
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                if (segment.trim().length() > 0) {
                    return segment;
                }
                ++n2;
            }
        }
        return "";
    }

    private IType[] getAllTypes(String typeName, ISourceModule sourceModule, int offset) {
        try {
            ArrayList<IType> lists = new ArrayList<IType>();
            IType[] types = PHPModelUtils.getTypes(typeName, sourceModule, offset, null);
            lists.addAll(Arrays.asList(types));
            types = PHPModelUtils.getTraits(typeName, sourceModule, offset, null, null);
            lists.addAll(Arrays.asList(types));
            return lists.toArray(new IType[0]);
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
            return new IType[0];
        }
    }

    public boolean visitGeneral(ASTNode node) throws Exception {
        IValidatorExtension[] iValidatorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IValidatorExtension extension = iValidatorExtensionArray[n2];
            extension.visit(node);
            ++n2;
        }
        return true;
    }

    public void endvisitGeneral(ASTNode node) throws Exception {
        IValidatorExtension[] iValidatorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IValidatorExtension extension = iValidatorExtensionArray[n2];
            extension.endvisit(node);
            ++n2;
        }
    }

    @Override
    public UsePartInfo getUsePartInfo(String name) {
        return this.usePartInfo.get(name);
    }

    @Override
    public boolean hasNamespace() {
        return this.hasNamespace;
    }

    @Override
    public NamespaceDeclaration getCurrentNamespace() {
        return this.currentNamespace;
    }

    private class TypeReferenceInfo
    implements IValidatorVisitor.ITypeReferenceInfo {
        private TypeReference typeReference;
        private boolean isGlobal = false;
        private boolean hasNamespace = false;
        private String namespaceName = "";
        private String typeName;
        private String fullyQualifiedName;
        private boolean isUseStatement;

        public TypeReferenceInfo(TypeReference typeReference, boolean isUseStatement) {
            this.typeReference = typeReference;
            this.isUseStatement = isUseStatement;
            FullyQualifiedReference fullTypeReference = null;
            if (typeReference instanceof FullyQualifiedReference && (fullTypeReference = (FullyQualifiedReference)typeReference).getNamespace() != null) {
                if (!fullTypeReference.getNamespace().isLocal()) {
                    this.hasNamespace = true;
                    this.namespaceName = fullTypeReference.getNamespace().getName();
                }
                if (!isUseStatement) {
                    String[] segments = this.namespaceName.split("\\\\", 2);
                    UsePartInfo info = (UsePartInfo)ValidatorVisitor.this.usePartInfo.get(segments[0].toLowerCase());
                    if (info != null) {
                        String restSegs = "";
                        if (segments.length > 1) {
                            restSegs = segments[1];
                        }
                        this.namespaceName = PHPModelUtils.concatFullyQualifiedNames(info.getFullyQualifiedName(), restSegs);
                    }
                }
            }
            if (fullTypeReference != null && this.hasNamespace) {
                this.isGlobal = fullTypeReference.getNamespace().isGlobal();
                this.typeName = fullTypeReference.getFullyQualifiedName();
            } else {
                this.typeName = typeReference.getName();
            }
            this.fullyQualifiedName = fullTypeReference != null && this.isGlobal ? fullTypeReference.getFullyQualifiedName() : (this.hasNamespace ? PHPModelUtils.concatFullyQualifiedNames(this.namespaceName, typeReference.getName()) : this.typeName);
            if (!isUseStatement && !this.fullyQualifiedName.startsWith("\\")) {
                String key = ValidatorVisitor.this.getFirstSegmentOfTypeName(this.fullyQualifiedName).toLowerCase();
                if (ValidatorVisitor.this.usePartInfo.containsKey(key)) {
                    this.fullyQualifiedName = ((UsePartInfo)ValidatorVisitor.this.usePartInfo.get(key)).getFullyQualifiedName();
                } else if (ValidatorVisitor.this.currentNamespace != null && !ValidatorVisitor.this.currentNamespace.isGlobal()) {
                    this.fullyQualifiedName = PHPModelUtils.concatFullyQualifiedNames(ValidatorVisitor.this.currentNamespace.getName(), this.fullyQualifiedName);
                }
            }
            if (this.fullyQualifiedName.length() > 0 && this.fullyQualifiedName.charAt(0) != '\\') {
                this.fullyQualifiedName = String.valueOf('\\') + this.fullyQualifiedName;
            }
        }

        @Override
        public boolean isGlobal() {
            return this.isGlobal;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public String getNamespaceName() {
            return this.namespaceName;
        }

        @Override
        public TypeReference getTypeReference() {
            return this.typeReference;
        }

        @Override
        public boolean isUseStatement() {
            return this.isUseStatement;
        }
    }

    private class UsePartInfo
    implements IValidatorVisitor.IUsePartInfo {
        private UsePart usePart;
        private String realName;
        private int refCount;
        private String fullyQualifiedName;
        private TypeReferenceInfo tri;
        private boolean isAlias = false;
        private boolean isProblemReported = false;

        public UsePartInfo(UsePart usePart) {
            this.usePart = usePart;
            this.tri = usePart.getGroupNamespace() == null ? new TypeReferenceInfo(usePart.getNamespace(), true) : new TypeReferenceInfo(ASTUtils.createFakeGroupUseType(usePart), true);
            if (usePart.getAlias() != null) {
                this.realName = usePart.getAlias().getName();
                this.isAlias = true;
            } else {
                this.realName = usePart.getNamespace().getName();
            }
            if (this.tri.getNamespaceName() != null) {
                this.fullyQualifiedName = this.tri.getNamespaceName();
            }
            this.fullyQualifiedName = PHPModelUtils.concatFullyQualifiedNames(this.fullyQualifiedName, usePart.getNamespace().getName());
            if (this.fullyQualifiedName.length() > 0 && this.fullyQualifiedName.charAt(0) != '\\') {
                this.fullyQualifiedName = String.valueOf('\\') + this.fullyQualifiedName;
            }
        }

        @Override
        public UsePart getUsePart() {
            return this.usePart;
        }

        @Override
        public int getRefCount() {
            return this.refCount;
        }

        @Override
        public void increaseRefCount() {
            ++this.refCount;
        }

        @Override
        public String getRealName() {
            return this.realName;
        }

        @Override
        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        @Override
        public String getNamespaceName() {
            return this.tri.getNamespaceName();
        }

        @Override
        public TypeReferenceInfo getTypeReferenceInfo() {
            return this.tri;
        }

        @Override
        public boolean isAlias() {
            return this.isAlias;
        }

        public String toString() {
            String str = "use " + this.fullyQualifiedName;
            if (this.isAlias) {
                str = String.valueOf(str) + " as " + this.realName;
            }
            return str;
        }
    }
}

