/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTr2QVTc;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtrelation.Key;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;

public class QVTrNameGenerator {
    public static final @NonNull String IDENTIFIED_INSTANCE_VARIABLE_NAME = "identifiedInstance";
    public static final @NonNull String KEYED_INSTANCE_PROPERTY_NAME = "instance";
    public static final @NonNull String KEY2INSTANCE_VARIABLE_NAME = "key2instance";
    protected final @NonNull QVTr2QVTc qvtr2qvtc;

    public QVTrNameGenerator(@NonNull QVTr2QVTc qvtr2qvtc) {
        this.qvtr2qvtc = qvtr2qvtc;
    }

    public @NonNull String createKeyFunctionName(@NonNull TypedModel rTypedModel, @NonNull Key rKey) {
        @NonNull Class identifiedClass = QVTrelationUtil.getIdentifies((Key)rKey);
        return "Key_" + QVTrelationUtil.getName((NamedElement)rTypedModel) + "_" + QVTrelationUtil.getName((NamedElement)identifiedClass);
    }

    public @NonNull String createKeyedVariableName(@NonNull Variable identifiedVariable) {
        return String.valueOf(QVTrelationUtil.getName((NamedElement)identifiedVariable)) + "_key";
    }

    public @NonNull String createMappingName(@NonNull RelationDomain rDomain) {
        Relation rRelation = QVTrelationUtil.getContainingRelation((EObject)rDomain);
        String rRelationName = PivotUtil.getName((NamedElement)rRelation);
        String rEnforcedDomainName = PivotUtil.getName((NamedElement)rDomain);
        return String.valueOf(rRelationName) + '_' + rEnforcedDomainName;
    }

    public @NonNull String createSignatureClassName(@NonNull Class signatureClass) {
        return "S" + signatureClass.getName().substring(1);
    }

    public @NonNull String createTraceClassName(@NonNull Relation relation) {
        return "T" + QVTrelationUtil.getName((NamedElement)relation);
    }

    public @NonNull String createTracePropertyName(@NonNull VariableDeclaration variable) {
        return QVTrelationUtil.getName((NamedElement)variable);
    }

    public @NonNull String createWhenInvocationPropertyName(@NonNull Relation relation) {
        return "when_" + QVTrelationUtil.getName((NamedElement)relation);
    }

    public @NonNull String createWhereInvocationPropertyName(@NonNull Relation relation) {
        return "where_" + QVTrelationUtil.getName((NamedElement)relation);
    }

    public @NonNull String createWhenMappingClassName(@NonNull RelationDomain rInvokedDomain) {
        Relation invokedRelation = QVTrelationUtil.getContainingRelation((EObject)rInvokedDomain);
        return "when_" + invokedRelation.getName() + '_' + rInvokedDomain.getName();
    }

    public @NonNull String createWhereMappingClassName(@NonNull RelationDomain rInvokedDomain) {
        Relation invokedRelation = QVTrelationUtil.getContainingRelation((EObject)rInvokedDomain);
        return "where_" + invokedRelation.getName() + '_' + rInvokedDomain.getName();
    }

    public <T> @NonNull String getUniqueName(@NonNull Map<@NonNull String, @NonNull T> name2object, @NonNull String name, @NonNull T object) {
        String uniqueName = name;
        int suffix = 0;
        while (name2object.get(uniqueName) != null) {
            uniqueName = String.valueOf(name) + ++suffix;
        }
        name2object.put(uniqueName, object);
        return uniqueName;
    }
}

