/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.apidocs.rcp;

import com.google.common.base.Optional;
import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.recommenders.apidocs.rcp.ApidocProvider;
import org.eclipse.recommenders.apidocs.rcp.ApidocProviderDescription;
import org.eclipse.recommenders.internal.apidocs.rcp.ApidocsPreferences;
import org.eclipse.recommenders.internal.apidocs.rcp.ApidocsRcpPlugin;
import org.eclipse.recommenders.internal.apidocs.rcp.l10n.LogMessages;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ApidocsRcpModule
extends AbstractModule {
    private static final String EXT_ID_PROVIDER = "org.eclipse.recommenders.apidocs.rcp.providers";

    protected void configure() {
        this.bind(ApidocsPreferences.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    @Extdoc
    IPreferenceStore providePreferenceStore() {
        return ApidocsRcpPlugin.getDefault().getPreferenceStore();
    }

    @Provides
    @Singleton
    List<ApidocProvider> provideProviders() {
        return ApidocsRcpModule.instantiateProvidersFromRegistry();
    }

    private static List<ApidocProvider> instantiateProvidersFromRegistry() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_ID_PROVIDER);
        LinkedList<ApidocProvider> providers = new LinkedList<ApidocProvider>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            Optional<ApidocProvider> opt = ApidocsRcpModule.createProvider(element);
            if (opt.isPresent()) {
                providers.add((ApidocProvider)opt.get());
            }
            ++n2;
        }
        Collections.sort(providers, new Comparator<ApidocProvider>(){

            @Override
            public int compare(ApidocProvider o1, ApidocProvider o2) {
                String n1 = o1.getDescription().getName();
                String n2 = o2.getDescription().getName();
                if (n1.equals("Javadoc")) {
                    return -1;
                }
                if (n2.equals("Javadoc")) {
                    return 1;
                }
                return n1.compareTo(n2);
            }
        });
        return providers;
    }

    static Optional<ApidocProvider> createProvider(IConfigurationElement element) {
        String pluginId = element.getContributor().getName();
        try {
            String imagePath = element.getAttribute("image");
            String name = element.getAttribute("name");
            Image image = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)imagePath).createImage();
            ApidocProvider provider = (ApidocProvider)element.createExecutableExtension("class");
            ApidocProviderDescription description = new ApidocProviderDescription(name, image);
            provider.setDescription(description);
            return Optional.of((Object)provider);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_INSTANTIATE_PROVIDER, (Throwable)e, (Object[])new Object[]{pluginId, element.getAttribute("class")});
            return Optional.absent();
        }
    }

    @BindingAnnotation
    @Target(value={ElementType.METHOD, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Extdoc {
    }
}

