/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;

public final class ShowingViewUtil {
    private ShowingViewUtil() {
    }

    public static List<View> getModelChildren(Object model) {
        if (model instanceof View) {
            List<View> modelChildren = null;
            ViewQuery viewQuery = new ViewQuery((View)model);
            if (viewQuery.isInShowingMode()) {
                modelChildren = new ArrayList(((View)model).getChildren()).stream().filter(View.class::isInstance).map(View.class::cast).collect(Collectors.toList());
            } else {
                modelChildren = new ArrayList(((View)model).getVisibleChildren()).stream().filter(View.class::isInstance).map(View.class::cast).collect(Collectors.toList());
                DiagramElementEditPartOperation.removeInvisibleElements(modelChildren);
            }
            return modelChildren;
        }
        return Collections.EMPTY_LIST;
    }

    public static List<View> getSourceConnectionsConnectingVisibleViews(View view) {
        if (!view.eIsSet((EStructuralFeature)NotationPackage.Literals.VIEW__SOURCE_EDGES)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<View> sourceConnections = new ArrayList<View>();
        ViewQuery viewQuery = new ViewQuery(view);
        boolean isIsInShowingMode = viewQuery.isInShowingMode();
        for (Edge edge : view.getSourceEdges()) {
            View target = edge.getTarget();
            if (!isIsInShowingMode && (!edge.isVisible() || !ShowingViewUtil.isVisible(target))) continue;
            sourceConnections.add((View)edge);
        }
        if (!isIsInShowingMode) {
            DiagramElementEditPartOperation.removeInvisibleElements(sourceConnections);
        }
        return sourceConnections;
    }

    public static void setVisibility(AbstractGraphicalEditPart editPart, boolean visibility, int noSelectionStatus, boolean autoConnectionsVisibility) {
        if (!visibility && editPart.getSelected() != noSelectionStatus) {
            editPart.getViewer().deselect((EditPart)editPart);
        }
        View view = (View)editPart.getModel();
        ViewQuery viewQuery = new ViewQuery(view);
        IFigure figure = editPart.getFigure();
        if (figure.isVisible() == visibility && !viewQuery.isInShowingMode()) {
            return;
        }
        if (autoConnectionsVisibility) {
            ShowingViewUtil.setConnectionsVisibility(editPart, view, noSelectionStatus, visibility);
        }
        if (viewQuery.isInShowingMode()) {
            figure.setVisible(true);
        } else {
            figure.setVisible(visibility);
        }
        figure.revalidate();
    }

    private static boolean isVisible(View view) {
        boolean result = false;
        if (view != null && view.isVisible()) {
            EObject parent = view.eContainer();
            result = parent instanceof View ? ShowingViewUtil.isVisible((View)parent) : true;
        }
        return result;
    }

    public static List<View> getTargetConnectionsConnectingVisibleViews(View view) {
        if (!view.eIsSet((EStructuralFeature)NotationPackage.Literals.VIEW__TARGET_EDGES)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<View> targteConnections = new ArrayList<View>();
        Iterator iter = view.getTargetEdges().iterator();
        ViewQuery viewQuery = new ViewQuery(view);
        boolean isIsInShowingMode = viewQuery.isInShowingMode();
        while (iter.hasNext()) {
            Edge edge = (Edge)iter.next();
            View source = edge.getSource();
            if (isIsInShowingMode || edge.isVisible() && ShowingViewUtil.isVisible(source)) {
                targteConnections.add((View)edge);
            }
            if (isIsInShowingMode) continue;
            DiagramElementEditPartOperation.removeInvisibleElements(targteConnections);
        }
        return targteConnections;
    }

    public static void setConnectionsVisibility(AbstractGraphicalEditPart editPart, View view, int selectionStatus, boolean isVisible) {
        List srcConnections = editPart.getSourceConnections();
        ViewQuery viewQuery = new ViewQuery(view);
        boolean isInShowingMode = viewQuery.isInShowingMode();
        ShowingViewUtil.updateVisibility(editPart, selectionStatus, isVisible, srcConnections, isInShowingMode);
        List targetConnections = editPart.getTargetConnections();
        ShowingViewUtil.updateVisibility(editPart, selectionStatus, isVisible, targetConnections, isInShowingMode);
    }

    private static void updateVisibility(AbstractGraphicalEditPart editPart, int selectionStatus, boolean isVisible, List<Object> connections, boolean isInShowingMode) {
        for (ConnectionEditPart connectionEditPart : connections) {
            if (connectionEditPart.getFigure().isVisible() == isVisible && !isInShowingMode) continue;
            if (!isVisible && connectionEditPart.getSelected() != selectionStatus) {
                connectionEditPart.getViewer().deselect((EditPart)editPart);
            }
            if (isInShowingMode) {
                connectionEditPart.getFigure().setVisible(true);
            } else {
                connectionEditPart.getFigure().setVisible(isVisible);
            }
            connectionEditPart.getFigure().revalidate();
        }
    }

    public static void initGraphicsForVisibleAndInvisibleElements(IFigure figure, Graphics graphics, View correspondingView) {
        graphics.pushState();
        ViewQuery viewQuery = new ViewQuery(correspondingView);
        if (figure.isVisible() != correspondingView.isVisible() && viewQuery.isInShowingMode()) {
            graphics.setAlpha(50);
        }
    }
}

