/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.action;

import org.eclipse.core.resources.IResource;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.resource.ILocalResource;

public interface ISyncStateFilter
extends IStateFilter {
    public static final ISyncStateFilter SF_ONREPOSITORY = new AbstractSyncStateFilter(){

        public boolean acceptRemote(IResource resource, String state, int mask) {
            return !IStateFilter.SF_NOTEXISTS.accept(resource, state, mask);
        }

        public boolean acceptGroupNodes() {
            return true;
        }

        protected boolean acceptImpl(ILocalResource local, IResource resource, String state, int mask) {
            return IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask);
        }

        protected boolean allowsRecursionImpl(ILocalResource local, IResource resource, String state, int mask) {
            return true;
        }
    };
    public static final ISyncStateFilter SF_OVERRIDE = new AbstractSyncStateFilter(){

        public boolean acceptRemote(IResource resource, String state, int mask) {
            return !IStateFilter.SF_NOTEXISTS.accept(resource, state, mask);
        }

        public boolean acceptGroupNodes() {
            return true;
        }

        protected boolean acceptImpl(ILocalResource local, IResource resource, String state, int mask) {
            return IStateFilter.SF_REVERTABLE.accept(resource, state, mask) || IStateFilter.SF_UNVERSIONED.accept(resource, state, mask);
        }

        protected boolean allowsRecursionImpl(ILocalResource local, IResource resource, String state, int mask) {
            return true;
        }
    };

    public boolean acceptRemote(IResource var1, String var2, int var3);

    public boolean acceptGroupNodes();

    public static abstract class AbstractSyncStateFilter
    extends IStateFilter.AbstractStateFilter
    implements ISyncStateFilter {
    }

    public static class StateFilterWrapper
    implements ISyncStateFilter {
        protected IStateFilter local;
        protected IStateFilter remote;
        protected boolean acceptGroupNodes;

        public StateFilterWrapper(IStateFilter filter, boolean acceptGroupNodes) {
            this(filter, null, acceptGroupNodes);
        }

        public StateFilterWrapper(IStateFilter local, IStateFilter remote, boolean acceptGroupNodes) {
            this.local = local;
            this.remote = remote;
            this.acceptGroupNodes = acceptGroupNodes;
        }

        public boolean acceptGroupNodes() {
            return this.acceptGroupNodes;
        }

        public boolean acceptRemote(IResource resource, String state, int mask) {
            return this.remote != null && this.remote.accept(resource, state, mask);
        }

        public boolean accept(IResource resource, String state, int mask) {
            return this.local != null && this.local.accept(resource, state, mask);
        }

        public boolean accept(ILocalResource resource) {
            return this.local != null && this.local.accept(resource);
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return true;
        }

        public boolean allowsRecursion(ILocalResource resource) {
            return true;
        }
    }
}

