/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources;

import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.resourcesstatus.ResourcesEntryModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class ResourcesEntry
extends TimeGraphEntry
implements Comparable<ITimeGraphEntry> {
    private static final Comparator<ResourcesEntry> COMPARATOR = Comparator.comparing(ResourcesEntry::getType).thenComparingInt(ResourcesEntry::getId);
    private final int fId;
    private final @NonNull ITmfTrace fTrace;
    private final ResourcesEntryModel.Type fType;

    public ResourcesEntry(ResourcesEntryModel model, @NonNull ITmfTrace trace) {
        super((TimeGraphEntryModel)model);
        this.fId = model.getResourceId();
        this.fTrace = trace;
        this.fType = model.getType();
    }

    public int getId() {
        return this.fId;
    }

    public @NonNull ITmfTrace getTrace() {
        return this.fTrace;
    }

    public ResourcesEntryModel.Type getType() {
        return this.fType;
    }

    public boolean hasTimeEvents() {
        return this.fType != ResourcesEntryModel.Type.TRACE;
    }

    @Override
    public int compareTo(ITimeGraphEntry other) {
        if (!(other instanceof ResourcesEntry)) {
            return -1;
        }
        return COMPARATOR.compare(this, (ResourcesEntry)other);
    }
}

