/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.resourcesstatus.ResourcesEntryModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.resourcesstatus.ResourcesStatusDataProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.registry.LinuxStyle;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources.ResourcesEntry;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.ui.views.FormatTimeUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEventStyleStrings;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NamedTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class ResourcesPresentationProvider
extends TimeGraphPresentationProvider {
    private Color fColorWhite;
    private Color fColorGray;
    private Integer fAverageCharWidth;
    private static final Map<Integer, StateItem> STATE_MAP;
    private static final List<StateItem> STATE_LIST;
    private static final StateItem[] STATE_TABLE;

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)0, (Object)ResourcesPresentationProvider.createState(LinuxStyle.IDLE));
        builder.put((Object)2, (Object)ResourcesPresentationProvider.createState(LinuxStyle.USERMODE));
        builder.put((Object)4, (Object)ResourcesPresentationProvider.createState(LinuxStyle.SYSCALL));
        builder.put((Object)16, (Object)ResourcesPresentationProvider.createState(LinuxStyle.INTERRUPTED));
        builder.put((Object)8, (Object)ResourcesPresentationProvider.createState(LinuxStyle.SOFT_IRQ));
        builder.put((Object)1, (Object)ResourcesPresentationProvider.createState(LinuxStyle.SOFT_IRQ_RAISED));
        STATE_MAP = builder.build();
        STATE_LIST = ImmutableList.copyOf(STATE_MAP.values());
        STATE_TABLE = STATE_LIST.toArray(new StateItem[STATE_LIST.size()]);
    }

    private static StateItem createState(LinuxStyle style) {
        int rgbInt = (Integer)style.toMap().getOrDefault(ITimeEventStyleStrings.fillColor(), 0);
        RGB color = new RGB(rgbInt >> 24 & 0xFF, rgbInt >> 16 & 0xFF, rgbInt >> 8 & 0xFF);
        return new StateItem(color, style.getLabel());
    }

    private static StateItem getEventState(TimeEvent event) {
        if (event.hasValue()) {
            ResourcesEntry entry = (ResourcesEntry)event.getEntry();
            int value = event.getValue();
            if (entry.getType() == ResourcesEntryModel.Type.CPU) {
                return STATE_MAP.get(value);
            }
            if (entry.getType() == ResourcesEntryModel.Type.IRQ) {
                return STATE_MAP.get(16);
            }
            if (entry.getType() == ResourcesEntryModel.Type.SOFT_IRQ) {
                if (value == 1) {
                    return STATE_MAP.get(1);
                }
                return STATE_MAP.get(8);
            }
        }
        return null;
    }

    public int getStateTableIndex(ITimeEvent event) {
        StateItem state = ResourcesPresentationProvider.getEventState((TimeEvent)event);
        if (state != null) {
            return STATE_LIST.indexOf(state);
        }
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        return -2;
    }

    public StateItem[] getStateTable() {
        return STATE_TABLE;
    }

    public String getEventName(ITimeEvent event) {
        StateItem state = ResourcesPresentationProvider.getEventState((TimeEvent)event);
        if (state != null) {
            return state.getStateString();
        }
        if (event instanceof NullTimeEvent) {
            return null;
        }
        return Messages.ResourcesView_multipleStates;
    }

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        if (event instanceof TimeEvent && ((TimeEvent)event).hasValue()) {
            TimeEvent tcEvent = (TimeEvent)event;
            ResourcesEntry entry = (ResourcesEntry)event.getEntry();
            if (tcEvent.hasValue()) {
                if (entry.getType().equals((Object)ResourcesEntryModel.Type.IRQ) || entry.getType().equals((Object)ResourcesEntryModel.Type.SOFT_IRQ)) {
                    int cpu = tcEvent.getValue();
                    if (cpu >= 0) {
                        LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>(1);
                        retMap.put(Messages.ResourcesView_attributeCpuName, String.valueOf(cpu));
                        return retMap;
                    }
                } else if (entry.getType().equals((Object)ResourcesEntryModel.Type.CPU)) {
                    int status = tcEvent.getValue();
                    ResourcesStatusDataProvider provider = (ResourcesStatusDataProvider)DataProviderManager.getInstance().getDataProvider(entry.getTrace(), "org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ResourcesStatusDataProvider", ResourcesStatusDataProvider.class);
                    if (provider != null) {
                        return ResourcesPresentationProvider.getTooltipForCpu(provider, entry.getModel().getId(), hoverTime, status);
                    }
                }
            }
        }
        return Collections.emptyMap();
    }

    private static Map<String, String> getTooltipForCpu(ResourcesStatusDataProvider provider, long id, long hoverTime, int status) {
        SelectionTimeQueryFilter filter = new SelectionTimeQueryFilter(Collections.singletonList(hoverTime), Collections.singleton(id));
        TmfModelResponse response = provider.fetchTooltip(filter, null);
        Map tooltip = (Map)response.getModel();
        if (tooltip == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>();
        if (status == 16) {
            String irq = (String)tooltip.get("IRQs");
            if (irq != null) {
                retMap.put(Messages.ResourcesView_attributeIrqName, irq);
            }
        } else if (status == 8) {
            String irq = (String)tooltip.get("Soft_IRQs");
            if (irq != null) {
                retMap.put(Messages.ResourcesView_attributeSoftIrqName, irq);
            }
        } else if (status == 2 || status == 4) {
            String syscallName;
            String execName;
            retMap.put(Messages.ResourcesView_attributeHoverTime, FormatTimeUtils.formatTime((long)hoverTime, (FormatTimeUtils.TimeFormat)FormatTimeUtils.TimeFormat.CALENDAR, (FormatTimeUtils.Resolution)FormatTimeUtils.Resolution.NANOSEC));
            String tidName = (String)tooltip.get("Current_thread");
            if (tidName != null) {
                retMap.put(Messages.ResourcesView_attributeTidName, tidName);
            }
            if ((execName = (String)tooltip.get("Exec_name")) != null) {
                retMap.put(Messages.ResourcesView_attributeProcessName, execName);
            }
            if ((syscallName = (String)tooltip.get("System_call")) != null) {
                retMap.put(Messages.ResourcesView_attributeSyscallName, syscallName);
            }
        }
        return retMap;
    }

    public void postDrawEvent(ITimeEvent event, Rectangle bounds, GC gc) {
        if (this.fColorGray == null) {
            this.fColorGray = gc.getDevice().getSystemColor(15);
        }
        if (this.fColorWhite == null) {
            this.fColorWhite = gc.getDevice().getSystemColor(1);
        }
        if (this.fAverageCharWidth == null) {
            this.fAverageCharWidth = gc.getFontMetrics().getAverageCharWidth();
        }
        if (bounds.width <= this.fAverageCharWidth) {
            return;
        }
        if (!(event instanceof NamedTimeEvent)) {
            return;
        }
        NamedTimeEvent tcEvent = (NamedTimeEvent)event;
        gc.setForeground(this.fColorWhite);
        Utils.drawText((GC)gc, (String)tcEvent.getLabel(), (int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height, (boolean)true, (boolean)true);
        gc.setForeground(this.fColorGray);
    }
}

