/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend.historytree;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.collect.BufferedBlockingQueue;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.IntegerRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.eclipse.tracecompass.internal.statesystem.core.Activator;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTInterval;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HistoryTreeBackend;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

public final class ThreadedHistoryTreeBackend
extends HistoryTreeBackend
implements Runnable {
    private static final int CHUNK_SIZE = 127;
    private final @NonNull BufferedBlockingQueue<HTInterval> intervalQueue;
    private final @NonNull Thread shtThread;
    private long fEndTime;

    public ThreadedHistoryTreeBackend(@NonNull String ssid, File newStateFile, int providerVersion, long startTime, int queueSize, int blockSize, int maxChildren) throws IOException {
        super(ssid, newStateFile, providerVersion, startTime, blockSize, maxChildren);
        this.fEndTime = startTime;
        this.intervalQueue = new BufferedBlockingQueue(queueSize / 127, 127);
        this.shtThread = new Thread((Runnable)this, "History Tree Thread");
        this.shtThread.start();
    }

    public ThreadedHistoryTreeBackend(@NonNull String ssid, File newStateFile, int providerVersion, long startTime, int queueSize) throws IOException {
        super(ssid, newStateFile, providerVersion, startTime);
        this.fEndTime = startTime;
        this.intervalQueue = new BufferedBlockingQueue(queueSize / 127, 127);
        this.shtThread = new Thread((Runnable)this, "History Tree Thread");
        this.shtThread.start();
    }

    @Override
    @Deprecated
    public void insertPastState(long stateStartTime, long stateEndTime, int quark, ITmfStateValue value) throws TimeRangeException {
        this.insertPastState(stateStartTime, stateEndTime, quark, value.unboxValue());
    }

    @Override
    public void insertPastState(long stateStartTime, long stateEndTime, int quark, Object value) throws TimeRangeException {
        HTInterval interval = new HTInterval(stateStartTime, stateEndTime, quark, value);
        this.intervalQueue.put((Object)interval);
        this.fEndTime = Math.max(this.fEndTime, stateEndTime);
    }

    @Override
    public long getEndTime() {
        return this.fEndTime;
    }

    @Override
    public void finishedBuilding(long endTime) {
        this.stopRunningThread(endTime);
        this.setFinishedBuilding(true);
    }

    @Override
    public void dispose() {
        if (!this.isFinishedBuilding()) {
            this.stopRunningThread(Long.MAX_VALUE);
        }
        super.dispose();
    }

    private void stopRunningThread(long endTime) {
        if (!this.shtThread.isAlive()) {
            return;
        }
        try {
            HTInterval pill = new HTInterval(Long.MIN_VALUE, endTime, -1, TmfStateValue.nullValue());
            this.intervalQueue.put((Object)pill);
            this.intervalQueue.flushInputBuffer();
            this.shtThread.join();
        }
        catch (TimeRangeException e) {
            Activator.getDefault().logError("Error closing state system", e);
        }
        catch (InterruptedException e) {
            Activator.getDefault().logError("State system interrupted", e);
        }
    }

    @Override
    public void run() {
        try {
            HTInterval currentInterval = (HTInterval)this.intervalQueue.blockingPeek();
            while (currentInterval.getStartTime() != Long.MIN_VALUE) {
                this.getSHT().insertInterval(currentInterval);
                this.intervalQueue.take();
                currentInterval = (HTInterval)this.intervalQueue.blockingPeek();
            }
            if (currentInterval.getAttribute() != -1) {
                throw new IllegalStateException();
            }
            this.getSHT().closeTree(currentInterval.getEndTime());
        }
        catch (TimeRangeException e) {
            Activator.getDefault().logError("Error starting the state system", e);
        }
    }

    @Override
    public void doQuery(List<ITmfStateInterval> currentStateInfo, long t) throws TimeRangeException, StateSystemDisposedException {
        super.doQuery(currentStateInfo, t);
        if (this.isFinishedBuilding()) {
            return;
        }
        int i = 0;
        while (i < currentStateInfo.size()) {
            if (currentStateInfo.get(i) == null) {
                ITmfStateInterval interval = this.doSingularQuery(t, i);
                currentStateInfo.set(i, interval);
            }
            ++i;
        }
    }

    @Override
    public ITmfStateInterval doSingularQuery(long t, int attributeQuark) throws TimeRangeException, StateSystemDisposedException {
        ITmfStateInterval ret = super.doSingularQuery(t, attributeQuark);
        if (ret != null) {
            return ret;
        }
        for (ITmfStateInterval interval : this.intervalQueue) {
            if (interval.getAttribute() != attributeQuark || !interval.intersects(t)) continue;
            return interval;
        }
        return super.doSingularQuery(t, attributeQuark);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public Iterable<@NonNull ITmfStateInterval> query2D(IntegerRangeCondition quarks, TimeRangeCondition times) throws TimeRangeException {
        @NonNull Iterable queuedIntervals = Iterables.filter(this.intervalQueue, interval -> !this.isFinishedBuilding() && quarks.test(interval.getAttribute()) && times.intersects(interval.getStartTime(), interval.getEndTime()));
        return Iterables.concat(super.query2D(quarks, times), (Iterable)queuedIntervals);
    }
}

