/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model;

import java.util.Collections;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlStateValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TmfXmlMapEntry {
    ITmfXmlStateValue fKey;
    ITmfXmlStateValue fValue;

    public TmfXmlMapEntry(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer container) {
        NodeList nodesSV = node.getElementsByTagName("stateValue");
        if (nodesSV.getLength() != 2) {
            throw new IllegalStateException("A map entry is composed of exactly 2 statevalues. Actual value is : " + nodesSV.getLength());
        }
        this.fKey = modelFactory.createStateValue((Element)NonNullUtils.checkNotNull((Object)nodesSV.item(0)), container, Collections.EMPTY_LIST);
        this.fValue = modelFactory.createStateValue((Element)NonNullUtils.checkNotNull((Object)nodesSV.item(1)), container, Collections.EMPTY_LIST);
    }

    public ITmfXmlStateValue getValue() {
        return this.fValue;
    }

    public ITmfXmlStateValue getKey() {
        return this.fKey;
    }
}

