/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class FindSupport {
    private static String[] NL_JAR_VARIANTS = FindSupport.buildNLVariants(Platform.getNL());

    private static String[] buildNLVariants(String nl) {
        ArrayList<String> result = new ArrayList<String>();
        Path base = new Path("nl");
        Path path = new Path(nl.replace('_', '/'));
        while (path.segmentCount() > 0) {
            result.add(base.append((IPath)path).toString());
            if (path.segmentCount() > 1) {
                result.add(base.append(path.toString().replace('/', '_')).toString());
            }
            path = path.removeLastSegments(1);
        }
        return result.toArray(new String[result.size()]);
    }

    public static URL find(Bundle bundle, IPath path) {
        return FindSupport.find(bundle, path, null);
    }

    public static URL[] findEntries(Bundle bundle, IPath path) {
        return FindSupport.findEntries(bundle, path, null);
    }

    public static URL[] findEntries(Bundle bundle, IPath path, Map<String, String> override) {
        ArrayList<URL> results = new ArrayList<URL>(1);
        FindSupport.find(bundle, path, override, results);
        return results.toArray(new URL[results.size()]);
    }

    public static URL find(Bundle b, IPath path, Map<String, String> override) {
        return FindSupport.find(b, path, override, null);
    }

    private static URL find(Bundle b, IPath path, Map<String, String> override, List<URL> multiple) {
        if (path == null) {
            return null;
        }
        URL result = null;
        if (path.isEmpty() || path.isRoot()) {
            result = FindSupport.findInPlugin(b, (IPath)Path.EMPTY, multiple);
            if (result == null || multiple != null) {
                result = FindSupport.findInFragments(b, (IPath)Path.EMPTY, multiple);
            }
            return result;
        }
        String first = path.segment(0);
        if (first.charAt(0) != '$') {
            result = FindSupport.findInPlugin(b, path, multiple);
            if (result == null || multiple != null) {
                result = FindSupport.findInFragments(b, path, multiple);
            }
            return result;
        }
        IPath rest = path.removeFirstSegments(1);
        if (first.equalsIgnoreCase("$nl$")) {
            return FindSupport.findNL(b, rest, override, multiple);
        }
        if (first.equalsIgnoreCase("$os$")) {
            return FindSupport.findOS(b, rest, override, multiple);
        }
        if (first.equalsIgnoreCase("$ws$")) {
            return FindSupport.findWS(b, rest, override, multiple);
        }
        if (first.equalsIgnoreCase("$files$")) {
            return null;
        }
        return null;
    }

    private static URL findOS(Bundle b, IPath path, Map<String, String> override, List<URL> multiple) {
        String os = null;
        if (override != null) {
            os = override.get("$os$");
        }
        if (os == null) {
            os = Platform.getOS();
        }
        if (os.length() == 0) {
            return null;
        }
        String osArch = null;
        if (override != null) {
            osArch = override.get("$arch$");
        }
        if (osArch == null) {
            osArch = Platform.getOSArch();
        }
        if (osArch.length() == 0) {
            return null;
        }
        URL result = null;
        IPath base = new Path("os").append(os).append(osArch);
        while (base.segmentCount() != 1) {
            IPath filePath = base.append(path);
            result = FindSupport.findInPlugin(b, filePath, multiple);
            if (result != null && multiple == null) {
                return result;
            }
            result = FindSupport.findInFragments(b, filePath, multiple);
            if (result != null && multiple == null) {
                return result;
            }
            base = base.removeLastSegments(1);
        }
        result = FindSupport.findInPlugin(b, path, multiple);
        if (result != null && multiple == null) {
            return result;
        }
        return FindSupport.findInFragments(b, path, multiple);
    }

    private static URL findWS(Bundle b, IPath path, Map<String, String> override, List<URL> multiple) {
        IPath filePath;
        URL result;
        String ws = null;
        if (override != null) {
            ws = override.get("$ws$");
        }
        if (ws == null) {
            ws = Platform.getWS();
        }
        if ((result = FindSupport.findInPlugin(b, filePath = new Path("ws").append(ws).append(path), multiple)) != null && multiple == null) {
            return result;
        }
        result = FindSupport.findInFragments(b, filePath, multiple);
        if (result != null && multiple == null) {
            return result;
        }
        result = FindSupport.findInPlugin(b, path, multiple);
        if (result != null && multiple == null) {
            return result;
        }
        return FindSupport.findInFragments(b, path, multiple);
    }

    private static URL findNL(Bundle b, IPath path, Map<String, String> override, List<URL> multiple) {
        String nl = null;
        String[] nlVariants = null;
        if (override != null) {
            nl = override.get("$nl$");
        }
        String[] stringArray = nlVariants = nl == null ? NL_JAR_VARIANTS : FindSupport.buildNLVariants(nl);
        if (nl != null && nl.length() == 0) {
            return null;
        }
        URL result = null;
        int i = 0;
        while (i < nlVariants.length) {
            IPath filePath = new Path(nlVariants[i]).append(path);
            result = FindSupport.findInPlugin(b, filePath, multiple);
            if (result != null && multiple == null) {
                return result;
            }
            result = FindSupport.findInFragments(b, filePath, multiple);
            if (result != null && multiple == null) {
                return result;
            }
            ++i;
        }
        result = FindSupport.findInPlugin(b, path, multiple);
        if (result != null && multiple == null) {
            return result;
        }
        return FindSupport.findInFragments(b, path, multiple);
    }

    private static URL findInPlugin(Bundle b, IPath filePath, List<URL> multiple) {
        URL result = b.getEntry(filePath.toString());
        if (result != null && multiple != null) {
            multiple.add(result);
        }
        return result;
    }

    private static URL findInFragments(Bundle b, IPath filePath, List<URL> multiple) {
        Bundle[] fragments = Platform.getFragments((Bundle)b);
        if (fragments == null) {
            return null;
        }
        URL fileURL = null;
        int i = 0;
        while (i < fragments.length && fileURL == null) {
            fileURL = fragments[i].getEntry(filePath.toString());
            if (fileURL != null && multiple != null) {
                multiple.add(fileURL);
                fileURL = null;
            }
            ++i;
        }
        return fileURL;
    }

    public static final InputStream openStream(Bundle bundle, IPath file, boolean localized) throws IOException {
        URL url = null;
        if (!localized) {
            url = FindSupport.findInPlugin(bundle, file, null);
            if (url == null) {
                url = FindSupport.findInFragments(bundle, file, null);
            }
        } else {
            url = FindSupport.find(bundle, file);
        }
        if (url != null) {
            return url.openStream();
        }
        throw new IOException("Cannot find " + file.toString());
    }
}

