/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryexplorer;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.tooling.ui.ViatraQueryGUIPlugin;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.IModelConnector;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.adapters.EMFModelConnector;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.detail.DetailsViewerUtil;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.flyout.FlyoutControlComposite;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.flyout.FlyoutPreferences;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.flyout.IFlyoutPreferences;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.PatternMatchContent;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.PatternMatcherContent;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.PatternMatcherRootContentKey;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.QueryExplorerLabelProvider;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.QueryExplorerObservableFactory;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.QueryExplorerTreeStructureAdvisor;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.RootContent;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.patternsviewer.PatternComponent;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.patternsviewer.PatternsViewerFlatContentProvider;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.patternsviewer.PatternsViewerFlatLabelProvider;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.patternsviewer.PatternsViewerHierarchicalContentProvider;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.patternsviewer.PatternsViewerHierarchicalLabelProvider;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.patternsviewer.PatternsViewerInput;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.util.CheckStateListener;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.util.CheckStateProvider;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.util.DoubleClickListener;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.util.QueryExplorerPatternRegistry;
import org.eclipse.viatra.query.tooling.ui.registry.QueryBackendRegistry;
import org.eclipse.viatra.query.tooling.ui.util.IModelConnectorListener;

public class QueryExplorer
extends ViewPart {
    private static final String PACKAGE_PRESENTATION_STATE = "packagePresentationState";
    private static final String PATTERNS_VIEWER_FLYOUT_STATE = "patternsViewerFlyoutState";
    private static final String DETAILS_VIEW_FLYOUT_STATE = "detailsViewFlyoutState";
    public static final String QUERY_EXPLORER_ANNOTATION = "QueryExplorer";
    public static final String QUERY_EXPLORER_CHECKED_PARAMETER = "checked";
    public static final String ID = "org.eclipse.viatra.query.tooling.ui.queryexplorer.QueryExplorer";
    private final Map<PatternMatcherRootContentKey, IModelConnector> modelConnectorMap = new HashMap<PatternMatcherRootContentKey, IModelConnector>();
    private final Map<IModelConnector, PatternMatcherRootContentKey> modelConnectorMapReversed = new HashMap<IModelConnector, PatternMatcherRootContentKey>();
    private TableViewer detailsTableViewer;
    private CheckboxTreeViewer patternsTreeViewer;
    private TreeViewer matcherTreeViewer;
    private final RootContent treeViewerRootContent;
    public static PatternsViewerInput patternsViewerInput;
    private FlyoutControlComposite patternsViewerFlyout;
    private FlyoutControlComposite detailsViewerFlyout;
    private IFlyoutPreferences detailsViewerFlyoutPreferences;
    private IFlyoutPreferences patternsViewerFlyoutPreferences;
    private final PatternsViewerFlatContentProvider flatCP;
    private final PatternsViewerFlatLabelProvider flatLP;
    private final PatternsViewerHierarchicalContentProvider hierarchicalCP;
    private final PatternsViewerHierarchicalLabelProvider hierarchicalLP;
    private final IModelConnectorListener listener;
    @Inject
    private Injector injector;
    @Inject
    private DetailsViewerUtil tableViewerUtil;
    private String mementoPackagePresentation = "flat";
    private QueryEvaluationHint hints;

    public QueryExplorer() {
        patternsViewerInput = new PatternsViewerInput();
        this.treeViewerRootContent = new RootContent();
        this.flatCP = new PatternsViewerFlatContentProvider();
        this.flatLP = new PatternsViewerFlatLabelProvider(patternsViewerInput);
        this.hierarchicalCP = new PatternsViewerHierarchicalContentProvider();
        this.hierarchicalLP = new PatternsViewerHierarchicalLabelProvider(patternsViewerInput);
        this.hints = new QueryEvaluationHint(null, QueryBackendRegistry.getInstance().getDefaultBackend());
        this.listener = new IModelConnectorListener(){

            @Override
            public void modelUnloaded(IModelConnector modelConnector) {
                if (!QueryExplorer.this.getSite().getShell().isDisposed()) {
                    QueryExplorer.this.unload(modelConnector);
                }
            }
        };
    }

    public QueryEvaluationHint getHints() {
        return this.hints;
    }

    public void setHints(QueryEvaluationHint hints) {
        Preconditions.checkNotNull((Object)hints);
        this.hints = hints;
    }

    public RootContent getRootContent() {
        return this.treeViewerRootContent;
    }

    public void load(PatternMatcherRootContentKey key, IModelConnector modelConnector) {
        if (!this.modelConnectorMap.containsKey(key)) {
            this.modelConnectorMap.put(key, modelConnector);
            this.modelConnectorMapReversed.put(modelConnector, key);
            this.treeViewerRootContent.addPatternMatcherRoot(key, this.getHints());
            if (modelConnector instanceof EMFModelConnector) {
                ((EMFModelConnector)modelConnector).addListener(this.listener);
            }
        }
    }

    private void unload(PatternMatcherRootContentKey key, IModelConnector modelConnector) {
        this.modelConnectorMapReversed.remove(modelConnector);
        this.modelConnectorMap.remove(key);
        this.treeViewerRootContent.removePatternMatcherRoot(key);
        if (modelConnector instanceof EMFModelConnector) {
            ((EMFModelConnector)modelConnector).removeListener(this.listener);
        }
        modelConnector.unloadModel();
    }

    public IModelConnector getModelConnector(PatternMatcherRootContentKey key) {
        return this.modelConnectorMap.get(key);
    }

    public Collection<PatternMatcherRootContentKey> getPatternMatcherRootContentKeys() {
        HashSet<PatternMatcherRootContentKey> keys = new HashSet<PatternMatcherRootContentKey>();
        keys.addAll(this.modelConnectorMap.keySet());
        return Collections.unmodifiableSet(keys);
    }

    public void unload(IModelConnector modelConnector) {
        if (this.modelConnectorMapReversed.containsKey(modelConnector)) {
            this.unload(this.modelConnectorMapReversed.get(modelConnector), modelConnector);
        }
    }

    public void unload(PatternMatcherRootContentKey key) {
        if (this.modelConnectorMap.containsKey(key)) {
            this.unload(key, this.modelConnectorMap.get(key));
        }
    }

    public static QueryExplorer getInstance() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return QueryExplorer.getInstance(activeWorkbenchWindow);
    }

    public static QueryExplorer getInstance(IWorkbenchWindow activeWorkbenchWindow) {
        IWorkbenchPart instance = null;
        if (activeWorkbenchWindow != null && activeWorkbenchWindow.getActivePage() != null && !((instance = activeWorkbenchWindow.getActivePage().getActivePart()) instanceof QueryExplorer)) {
            instance = activeWorkbenchWindow.getActivePage().findView(ID);
        }
        return (QueryExplorer)instance;
    }

    public TreeViewer getMatcherTreeViewer() {
        return this.matcherTreeViewer;
    }

    public PatternsViewerFlatContentProvider getFlatContentProvider() {
        return this.flatCP;
    }

    public PatternsViewerFlatLabelProvider getFlatLabelProvider() {
        return this.flatLP;
    }

    public PatternsViewerHierarchicalContentProvider getHierarchicalContentProvider() {
        return this.hierarchicalCP;
    }

    public PatternsViewerHierarchicalLabelProvider getHierarchicalLabelProvider() {
        return this.hierarchicalLP;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        int detailsState = 0;
        int patternsState = 1;
        if (memento != null) {
            if (memento.getInteger(DETAILS_VIEW_FLYOUT_STATE) != null) {
                detailsState = memento.getInteger(DETAILS_VIEW_FLYOUT_STATE);
            }
            if (memento.getInteger(PATTERNS_VIEWER_FLYOUT_STATE) != null) {
                patternsState = memento.getInteger(DETAILS_VIEW_FLYOUT_STATE);
            }
            if (memento.getString(PACKAGE_PRESENTATION_STATE) != null) {
                this.mementoPackagePresentation = memento.getString(PACKAGE_PRESENTATION_STATE);
            }
        }
        this.detailsViewerFlyoutPreferences = new FlyoutPreferences(2, detailsState, 300);
        this.patternsViewerFlyoutPreferences = new FlyoutPreferences(1, patternsState, 100);
        ViatraQueryGUIPlugin.getDefault().getPreferenceStore().setDefault("org.eclipse.viatra.query.tooling.ui.queryexplorer.WildcardMode", true);
    }

    public void clearTableViewer() {
        if (this.detailsTableViewer.getContentProvider() != null) {
            this.detailsTableViewer.setInput(null);
        }
    }

    public void createPartControl(Composite parent) {
        this.detailsViewerFlyout = new FlyoutControlComposite(parent, 0, this.detailsViewerFlyoutPreferences);
        this.detailsViewerFlyout.setTitleText("Details / Filters");
        this.detailsViewerFlyout.setValidDockLocations(2);
        this.patternsViewerFlyout = new FlyoutControlComposite(this.detailsViewerFlyout.getClientParent(), 0, this.patternsViewerFlyoutPreferences);
        this.patternsViewerFlyout.setTitleText("Pattern registry");
        this.patternsViewerFlyout.setValidDockLocations(1);
        this.matcherTreeViewer = new TreeViewer(this.patternsViewerFlyout.getClientParent());
        this.detailsTableViewer = new TableViewer(this.detailsViewerFlyout.getFlyoutParent(), 65536);
        this.matcherTreeViewer.setContentProvider((IContentProvider)new ObservableListTreeContentProvider((IObservableFactory)new QueryExplorerObservableFactory(), (TreeStructureAdvisor)new QueryExplorerTreeStructureAdvisor()));
        this.matcherTreeViewer.setLabelProvider((IBaseLabelProvider)new QueryExplorerLabelProvider());
        this.matcherTreeViewer.setInput((Object)this.treeViewerRootContent);
        this.treeViewerRootContent.setViewer(this.matcherTreeViewer);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.matcherTreeViewer);
        this.matcherTreeViewer.setComparator(null);
        IViewerObservableValue selection = ViewersObservables.observeSingleSelection((Viewer)this.matcherTreeViewer);
        selection.addValueChangeListener((IValueChangeListener)new RootContentSelectionChangeListener());
        DoubleClickListener doubleClickListener = new DoubleClickListener();
        this.injector.injectMembers((Object)doubleClickListener);
        this.matcherTreeViewer.addDoubleClickListener((IDoubleClickListener)doubleClickListener);
        this.patternsTreeViewer = new CheckboxTreeViewer(this.patternsViewerFlyout.getFlyoutParent(), 2082);
        this.patternsTreeViewer.setCheckStateProvider((ICheckStateProvider)new CheckStateProvider());
        this.patternsTreeViewer.addCheckStateListener((ICheckStateListener)new CheckStateListener(this));
        this.setPackagePresentation(this.mementoPackagePresentation, false);
        this.patternsTreeViewer.setInput((Object)patternsViewerInput);
        MenuManager matcherTreeViewerMenuManager = new MenuManager();
        matcherTreeViewerMenuManager.setRemoveAllWhenShown(true);
        matcherTreeViewerMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                QueryExplorer.this.fillContextMenu(mgr);
            }
        });
        Menu matcherTreeViewerMenu = matcherTreeViewerMenuManager.createContextMenu(this.matcherTreeViewer.getControl());
        this.matcherTreeViewer.getControl().setMenu(matcherTreeViewerMenu);
        this.getSite().registerContextMenu("org.eclipse.viatra.query.tooling.ui.queryexplorer.QueryExplorer.treeViewerMenu", matcherTreeViewerMenuManager, (ISelectionProvider)this.matcherTreeViewer);
        MenuManager patternsViewerMenuManager = new MenuManager();
        patternsViewerMenuManager.setRemoveAllWhenShown(true);
        patternsViewerMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                QueryExplorer.this.fillContextMenu(mgr);
            }
        });
        Menu patternsViewerMenu = patternsViewerMenuManager.createContextMenu(this.patternsTreeViewer.getControl());
        this.patternsTreeViewer.getControl().setMenu(patternsViewerMenu);
        this.getSite().registerContextMenu("org.eclipse.viatra.query.tooling.ui.queryexplorer.QueryExplorer.patternsViewerMenu", patternsViewerMenuManager, (ISelectionProvider)this.patternsTreeViewer);
        Table table = this.detailsTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.detailsTableViewer.getControl().setLayoutData((Object)gridData);
        this.getSite().setSelectionProvider((ISelectionProvider)this.matcherTreeViewer);
        this.initPatternsViewerWithGeneratedPatterns();
    }

    private void fillContextMenu(IMenuManager mgr) {
        mgr.add((IContributionItem)new GroupMarker("additions"));
    }

    public void setFocus() {
        this.matcherTreeViewer.getControl().setFocus();
    }

    private void initPatternsViewerWithGeneratedPatterns() {
        for (IQuerySpecification pattern : QueryExplorerPatternRegistry.getGeneratedQuerySpecifications()) {
            String patternFqn = pattern.getFullyQualifiedName();
            QueryExplorerPatternRegistry.getInstance().addGeneratedPattern(pattern);
            Optional<Boolean> checkedValue = QueryExplorerPatternRegistry.getQueryExplorerCheckedValue(pattern);
            Boolean computedCheckedValue = (Boolean)checkedValue.or((Object)false);
            if (computedCheckedValue.booleanValue()) {
                QueryExplorerPatternRegistry.getInstance().addActivePattern(pattern);
            }
            PatternComponent component = patternsViewerInput.getGeneratedPatternsRoot().addComponent(patternFqn);
            component.setCheckedState(computedCheckedValue);
        }
        this.patternsTreeViewer.refresh();
        patternsViewerInput.getGeneratedPatternsRoot().updateHasChildren();
        patternsViewerInput.getGenericPatternsRoot().setCheckedState(false);
    }

    public void refreshPatternsViewer() {
        this.patternsTreeViewer.refresh();
        patternsViewerInput.getGeneratedPatternsRoot().updateHasChildren();
        patternsViewerInput.getGenericPatternsRoot().updateHasChildren();
    }

    public PatternsViewerInput getPatternsViewerRoot() {
        return patternsViewerInput;
    }

    public CheckboxTreeViewer getPatternsViewer() {
        return this.patternsTreeViewer;
    }

    public FlyoutControlComposite getPatternsViewerFlyout() {
        return this.patternsViewerFlyout;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putInteger(DETAILS_VIEW_FLYOUT_STATE, this.detailsViewerFlyout.getPreferences().getState());
        memento.putInteger(PATTERNS_VIEWER_FLYOUT_STATE, this.patternsViewerFlyout.getPreferences().getState());
        memento.putString(PACKAGE_PRESENTATION_STATE, this.patternsTreeViewer.getContentProvider() == this.flatCP ? "flat" : "hierarchical");
    }

    public void setPackagePresentation(String command, boolean update) {
        if (command.contains("flat")) {
            this.patternsTreeViewer.setContentProvider((IContentProvider)this.flatCP);
            this.patternsTreeViewer.setLabelProvider((IBaseLabelProvider)this.flatLP);
        } else {
            this.patternsTreeViewer.setContentProvider((IContentProvider)this.hierarchicalCP);
            this.patternsTreeViewer.setLabelProvider((IBaseLabelProvider)this.hierarchicalLP);
        }
        if (update) {
            patternsViewerInput.getGeneratedPatternsRoot().updateHasChildren();
            patternsViewerInput.getGenericPatternsRoot().updateHasChildren();
        }
    }

    private class RootContentSelectionChangeListener
    implements IValueChangeListener {
        private RootContentSelectionChangeListener() {
        }

        public void handleValueChange(ValueChangeEvent event) {
            Object value = event.getObservableValue().getValue();
            QueryExplorer.this.clearTableViewer();
            if (value instanceof PatternMatcherContent) {
                PatternMatcherContent observableMatcher = (PatternMatcherContent)value;
                if (observableMatcher.getMatcher() != null) {
                    QueryExplorer.this.tableViewerUtil.prepareFor(observableMatcher, QueryExplorer.this.detailsTableViewer);
                    String patternFqn = observableMatcher.getMatcher().getSpecification().getFullyQualifiedName();
                    IQuerySpecification<?> pattern = QueryExplorerPatternRegistry.getInstance().getPatternByFqn(patternFqn);
                    List<PatternComponent> components = null;
                    if (QueryExplorerPatternRegistry.getInstance().isGenerated(pattern)) {
                        components = patternsViewerInput.getGeneratedPatternsRoot().find(patternFqn);
                        components.add(0, patternsViewerInput.getGeneratedPatternsRoot());
                    } else {
                        components = patternsViewerInput.getGenericPatternsRoot().find(patternFqn);
                        components.add(0, patternsViewerInput.getGenericPatternsRoot());
                    }
                    if (components != null) {
                        QueryExplorer.this.patternsTreeViewer.setSelection((ISelection)new TreeSelection(new TreePath(components.toArray())));
                    }
                } else {
                    QueryExplorer.this.clearTableViewer();
                }
            } else if (value instanceof PatternMatchContent) {
                PatternMatchContent match = (PatternMatchContent)value;
                QueryExplorer.this.tableViewerUtil.prepareFor(match, QueryExplorer.this.detailsTableViewer);
            }
        }
    }
}

