/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.platform;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.wb.internal.core.utils.platform.PluginUtilities;
import org.osgi.framework.Version;

public class PlatformInfo {
    public static final String UNKNOWN_IDE_NAME = "Unknown IDE";
    public static final PluginVersionIdentifier UNKNOWN_VERSION = new PluginVersionIdentifier(100, 1, 4);
    public static final String UNKNOWN_VERSION_STRING = UNKNOWN_VERSION.toString();
    public static final String UNKNOWN_BUILD_ID = "?BUILD-ID?";
    public static final String UNKNOWN_NL = "?NL?";
    private static String ideName;
    private static String ideVersionString;
    private static String ideNL;
    private static Version eclipseVersion;
    private static String eclipseBuildId;
    private static String eclipseBuildName;
    private static GregorianCalendar eclipseBuildDate;

    private PlatformInfo() {
    }

    public static String getIDEName() {
        if (ideName == null) {
            try {
                if (Platform.getProduct() != null) {
                    ideName = Platform.getProduct().getName();
                }
                if (ideName == null) {
                    ideName = UNKNOWN_IDE_NAME;
                } else if ((ideName = ideName.trim()).length() == 0) {
                    ideName = UNKNOWN_IDE_NAME;
                } else if (ideName.startsWith("Eclipse Pl")) {
                    ideName = "Eclipse";
                } else if (ideName.startsWith("Common OS-independent base of the Eclipse platform")) {
                    ideName = "Eclipse";
                }
            }
            catch (Exception exception) {
                ideName = UNKNOWN_IDE_NAME;
            }
        }
        return ideName;
    }

    public static String getIDEVersionString() {
        if (ideVersionString == null) {
            try {
                String pluginId = null;
                if (Platform.getProduct() != null) {
                    pluginId = Platform.getProduct().getDefiningBundle().getSymbolicName();
                }
                ideVersionString = PluginUtilities.getVersionString(pluginId);
            }
            catch (Exception exception) {}
            if (ideVersionString == null || ideVersionString.length() == 0) {
                ideVersionString = UNKNOWN_VERSION_STRING;
            }
        }
        return ideVersionString;
    }

    public static String getIDENL() {
        if (ideNL == null) {
            try {
                ideNL = Platform.getNL();
            }
            catch (Exception exception) {}
            if (ideNL == null) {
                ideNL = UNKNOWN_NL;
            }
        }
        return ideNL;
    }

    public static Version getEclipseVersion() {
        if (eclipseVersion == null) {
            try {
                Version version;
                eclipseVersion = PluginUtilities.getVersion("org.eclipse.core.runtime");
                if (eclipseVersion.getMajor() == 3 && eclipseVersion.getMinor() == 5 && (version = PluginUtilities.getVersion("org.eclipse.jdt.ui")).getMajor() == 3 && version.getMinor() == 6) {
                    eclipseVersion = version;
                }
                if (eclipseVersion.getQualifier().length() == 0) {
                    eclipseVersion = new Version(eclipseVersion.getMajor(), eclipseVersion.getMinor(), eclipseVersion.getMicro(), "v" + PlatformInfo.readBuildId("org.eclipse.jdt", "about.mappings"));
                }
            }
            catch (Exception exception) {}
            if (eclipseVersion == null) {
                eclipseVersion = Version.emptyVersion;
            }
        }
        return eclipseVersion;
    }

    public static String getEclipseBuildId() {
        if (eclipseBuildId == null) {
            try {
                eclipseBuildId = PlatformInfo.readBuildId("org.eclipse.jdt", "about.mappings");
            }
            catch (Exception exception) {}
            if (eclipseBuildId == null) {
                eclipseBuildId = UNKNOWN_BUILD_ID;
            }
        }
        return eclipseBuildId;
    }

    public static String getEclipseBuildName() {
        if (eclipseBuildName == null && (eclipseBuildName = "") == null) {
            eclipseBuildName = PlatformInfo.getEclipseBuildId();
        }
        return eclipseBuildName;
    }

    public static Calendar getEclipseBuildDate() {
        if (eclipseBuildDate == null) {
            try {
                String ymd = PlatformInfo.getEclipseBuildId();
                if (Character.isLetter(ymd.charAt(0))) {
                    ymd = ymd.substring(1);
                }
                int y = Integer.parseInt(ymd.substring(0, 4));
                int m = Integer.parseInt(ymd.substring(4, 6)) - 1;
                int d = Integer.parseInt(ymd.substring(6, 8));
                eclipseBuildDate = new GregorianCalendar(y, m, d);
            }
            catch (Exception exception) {}
            if (eclipseBuildDate == null) {
                eclipseBuildDate = new GregorianCalendar(2003, 0, 1);
            }
        }
        return eclipseBuildDate;
    }

    /*
     * Exception decompiling
     */
    private static String readBuildId(String pluginId, String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

