/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.tree;

import java.util.HashMap;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeAdaptor;
import org.antlr.stringtemplate.StringTemplate;

public class DOTTreeGenerator {
    public static StringTemplate _treeST = new StringTemplate("digraph {\n  ordering=out;\n  ranksep=.4;\n  node [shape=plaintext, fixedsize=true, fontsize=11, fontname=\"Courier\",\n        width=.25, height=.25];\n  edge [arrowsize=.5]\n  $nodes$\n  $edges$\n}\n");
    public static StringTemplate _nodeST = new StringTemplate("$name$ [label=\"$text$\"];\n");
    public static StringTemplate _edgeST = new StringTemplate("$parent$ -> $child$ // \"$parentText$\" -> \"$childText$\"\n");
    HashMap nodeToNumberMap = new HashMap();
    int nodeNumber = 0;

    public StringTemplate toDOT(Object object, TreeAdaptor treeAdaptor, StringTemplate stringTemplate, StringTemplate stringTemplate2) {
        StringTemplate stringTemplate3 = stringTemplate.getInstanceOf();
        this.nodeNumber = 0;
        this.toDOTDefineNodes(object, treeAdaptor, stringTemplate3);
        this.nodeNumber = 0;
        this.toDOTDefineEdges(object, treeAdaptor, stringTemplate3);
        return stringTemplate3;
    }

    public StringTemplate toDOT(Object object, TreeAdaptor treeAdaptor) {
        return this.toDOT(object, treeAdaptor, _treeST, _edgeST);
    }

    public StringTemplate toDOT(Tree tree) {
        return this.toDOT(tree, new CommonTreeAdaptor());
    }

    protected void toDOTDefineNodes(Object object, TreeAdaptor treeAdaptor, StringTemplate stringTemplate) {
        if (object == null) {
            return;
        }
        int n = treeAdaptor.getChildCount(object);
        if (n == 0) {
            return;
        }
        StringTemplate stringTemplate2 = this.getNodeST(treeAdaptor, object);
        stringTemplate.setAttribute("nodes", (Object)stringTemplate2);
        for (int i = 0; i < n; ++i) {
            Object object2 = treeAdaptor.getChild(object, i);
            StringTemplate stringTemplate3 = this.getNodeST(treeAdaptor, object2);
            stringTemplate.setAttribute("nodes", (Object)stringTemplate3);
            this.toDOTDefineNodes(object2, treeAdaptor, stringTemplate);
        }
    }

    protected void toDOTDefineEdges(Object object, TreeAdaptor treeAdaptor, StringTemplate stringTemplate) {
        if (object == null) {
            return;
        }
        int n = treeAdaptor.getChildCount(object);
        if (n == 0) {
            return;
        }
        String string = "n" + this.getNodeNumber(object);
        String string2 = treeAdaptor.getText(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = treeAdaptor.getChild(object, i);
            String string3 = treeAdaptor.getText(object2);
            String string4 = "n" + this.getNodeNumber(object2);
            StringTemplate stringTemplate2 = _edgeST.getInstanceOf();
            stringTemplate2.setAttribute("parent", (Object)string);
            stringTemplate2.setAttribute("child", (Object)string4);
            stringTemplate2.setAttribute("parentText", (Object)string2);
            stringTemplate2.setAttribute("childText", (Object)string3);
            stringTemplate.setAttribute("edges", (Object)stringTemplate2);
            this.toDOTDefineEdges(object2, treeAdaptor, stringTemplate);
        }
    }

    protected StringTemplate getNodeST(TreeAdaptor treeAdaptor, Object object) {
        String string = treeAdaptor.getText(object);
        StringTemplate stringTemplate = _nodeST.getInstanceOf();
        String string2 = "n" + this.getNodeNumber(object);
        stringTemplate.setAttribute("name", (Object)string2);
        stringTemplate.setAttribute("text", (Object)string);
        return stringTemplate;
    }

    protected int getNodeNumber(Object object) {
        Integer n = (Integer)this.nodeToNumberMap.get(object);
        if (n != null) {
            return n;
        }
        this.nodeToNumberMap.put(object, new Integer(this.nodeNumber));
        ++this.nodeNumber;
        return this.nodeNumber - 1;
    }
}

