/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.StringHelper;

public abstract class PointRangeQuery
extends Query {
    final String field;
    final int numDims;
    final int bytesPerDim;
    final byte[] lowerPoint;
    final byte[] upperPoint;

    protected PointRangeQuery(String field, byte[] lowerPoint, byte[] upperPoint, int numDims) {
        PointRangeQuery.checkArgs(field, lowerPoint, upperPoint);
        this.field = field;
        if (numDims <= 0) {
            throw new IllegalArgumentException("numDims must be positive, got " + numDims);
        }
        if (lowerPoint.length == 0) {
            throw new IllegalArgumentException("lowerPoint has length of zero");
        }
        if (lowerPoint.length % numDims != 0) {
            throw new IllegalArgumentException("lowerPoint is not a fixed multiple of numDims");
        }
        if (lowerPoint.length != upperPoint.length) {
            throw new IllegalArgumentException("lowerPoint has length=" + lowerPoint.length + " but upperPoint has different length=" + upperPoint.length);
        }
        this.numDims = numDims;
        this.bytesPerDim = lowerPoint.length / numDims;
        this.lowerPoint = lowerPoint;
        this.upperPoint = upperPoint;
    }

    public static void checkArgs(String field, Object lowerPoint, Object upperPoint) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (lowerPoint == null) {
            throw new IllegalArgumentException("lowerPoint must not be null");
        }
        if (upperPoint == null) {
            throw new IllegalArgumentException("upperPoint must not be null");
        }
    }

    @Override
    public final Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            private DocIdSet buildMatchingDocIdSet(LeafReader reader, PointValues values) throws IOException {
                final DocIdSetBuilder result = new DocIdSetBuilder(reader.maxDoc(), values, PointRangeQuery.this.field);
                values.intersect(PointRangeQuery.this.field, new PointValues.IntersectVisitor(){
                    DocIdSetBuilder.BulkAdder adder;

                    @Override
                    public void grow(int count) {
                        this.adder = result.grow(count);
                    }

                    @Override
                    public void visit(int docID) {
                        this.adder.add(docID);
                    }

                    @Override
                    public void visit(int docID, byte[] packedValue) {
                        for (int dim = 0; dim < PointRangeQuery.this.numDims; ++dim) {
                            int offset = dim * PointRangeQuery.this.bytesPerDim;
                            if (StringHelper.compare(PointRangeQuery.this.bytesPerDim, packedValue, offset, PointRangeQuery.this.lowerPoint, offset) < 0) {
                                return;
                            }
                            if (StringHelper.compare(PointRangeQuery.this.bytesPerDim, packedValue, offset, PointRangeQuery.this.upperPoint, offset) <= 0) continue;
                            return;
                        }
                        this.adder.add(docID);
                    }

                    @Override
                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        boolean crosses = false;
                        for (int dim = 0; dim < PointRangeQuery.this.numDims; ++dim) {
                            int offset = dim * PointRangeQuery.this.bytesPerDim;
                            if (StringHelper.compare(PointRangeQuery.this.bytesPerDim, minPackedValue, offset, PointRangeQuery.this.upperPoint, offset) > 0 || StringHelper.compare(PointRangeQuery.this.bytesPerDim, maxPackedValue, offset, PointRangeQuery.this.lowerPoint, offset) < 0) {
                                return PointValues.Relation.CELL_OUTSIDE_QUERY;
                            }
                            crosses |= StringHelper.compare(PointRangeQuery.this.bytesPerDim, minPackedValue, offset, PointRangeQuery.this.lowerPoint, offset) < 0 || StringHelper.compare(PointRangeQuery.this.bytesPerDim, maxPackedValue, offset, PointRangeQuery.this.upperPoint, offset) > 0;
                        }
                        if (crosses) {
                            return PointValues.Relation.CELL_CROSSES_QUERY;
                        }
                        return PointValues.Relation.CELL_INSIDE_QUERY;
                    }
                });
                return result.build();
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                boolean allDocsMatch;
                LeafReader reader = context.reader();
                PointValues values = reader.getPointValues();
                if (values == null) {
                    return null;
                }
                FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(PointRangeQuery.this.field);
                if (fieldInfo == null) {
                    return null;
                }
                if (fieldInfo.getPointDimensionCount() != PointRangeQuery.this.numDims) {
                    throw new IllegalArgumentException("field=\"" + PointRangeQuery.this.field + "\" was indexed with numDims=" + fieldInfo.getPointDimensionCount() + " but this query has numDims=" + PointRangeQuery.this.numDims);
                }
                if (PointRangeQuery.this.bytesPerDim != fieldInfo.getPointNumBytes()) {
                    throw new IllegalArgumentException("field=\"" + PointRangeQuery.this.field + "\" was indexed with bytesPerDim=" + fieldInfo.getPointNumBytes() + " but this query has bytesPerDim=" + PointRangeQuery.this.bytesPerDim);
                }
                if (values.getDocCount(PointRangeQuery.this.field) == reader.maxDoc()) {
                    byte[] fieldPackedLower = values.getMinPackedValue(PointRangeQuery.this.field);
                    byte[] fieldPackedUpper = values.getMaxPackedValue(PointRangeQuery.this.field);
                    allDocsMatch = true;
                    for (int i = 0; i < PointRangeQuery.this.numDims; ++i) {
                        int offset = i * PointRangeQuery.this.bytesPerDim;
                        if (StringHelper.compare(PointRangeQuery.this.bytesPerDim, PointRangeQuery.this.lowerPoint, offset, fieldPackedLower, offset) <= 0 && StringHelper.compare(PointRangeQuery.this.bytesPerDim, PointRangeQuery.this.upperPoint, offset, fieldPackedUpper, offset) >= 0) continue;
                        allDocsMatch = false;
                        break;
                    }
                } else {
                    allDocsMatch = false;
                }
                DocIdSetIterator iterator = allDocsMatch ? DocIdSetIterator.all(reader.maxDoc()) : this.buildMatchingDocIdSet(reader, values).iterator();
                return new ConstantScoreScorer((Weight)this, this.score(), iterator);
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public int getNumDims() {
        return this.numDims;
    }

    public int getBytesPerDim() {
        return this.bytesPerDim;
    }

    public byte[] getLowerPoint() {
        return (byte[])this.lowerPoint.clone();
    }

    public byte[] getUpperPoint() {
        return (byte[])this.upperPoint.clone();
    }

    @Override
    public final int hashCode() {
        int hash = this.classHash();
        hash = 31 * hash + this.field.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.lowerPoint);
        hash = 31 * hash + Arrays.hashCode(this.upperPoint);
        hash = 31 * hash + this.numDims;
        hash = 31 * hash + Objects.hashCode(this.bytesPerDim);
        return hash;
    }

    @Override
    public final boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo((PointRangeQuery)this.getClass().cast(o));
    }

    private boolean equalsTo(PointRangeQuery other) {
        return Objects.equals(this.field, other.field) && this.numDims == other.numDims && this.bytesPerDim == other.bytesPerDim && Arrays.equals(this.lowerPoint, other.lowerPoint) && Arrays.equals(this.upperPoint, other.upperPoint);
    }

    @Override
    public final String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field);
            sb.append(':');
        }
        for (int i = 0; i < this.numDims; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            int startOffset = this.bytesPerDim * i;
            sb.append('[');
            sb.append(this.toString(i, Arrays.copyOfRange(this.lowerPoint, startOffset, startOffset + this.bytesPerDim)));
            sb.append(" TO ");
            sb.append(this.toString(i, Arrays.copyOfRange(this.upperPoint, startOffset, startOffset + this.bytesPerDim)));
            sb.append(']');
        }
        return sb.toString();
    }

    protected abstract String toString(int var1, byte[] var2);
}

