/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.builder;

import java.io.File;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugPlugin;

public class IncrementalDotnetBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.acute.builder.IncrementalDotnetBuilder";
    private Process buildProcess;

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        IMarker[] errorMarkers = project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        if (this.buildProcess != null && this.buildProcess.isAlive()) {
            this.buildProcess.destroyForcibly();
        }
        if (errorMarkers.length == 0) {
            try {
                String[] commandList = new String[]{"dotnet", "build"};
                this.buildProcess = DebugPlugin.exec((String[])commandList, (File)project.getLocation().toFile());
                this.buildProcess.waitFor();
                project.refreshLocal(2, null);
            }
            catch (InterruptedException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.acute", e.getMessage(), (Throwable)e));
            }
        }
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        if (this.buildProcess != null && this.buildProcess.isAlive()) {
            this.buildProcess.destroyForcibly();
        }
        String[] commandList = new String[]{"dotnet", "clean"};
        this.buildProcess = DebugPlugin.exec((String[])commandList, (File)this.getProject().getLocation().toFile());
        try {
            this.buildProcess.waitFor();
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.acute", e.getMessage(), (Throwable)e));
        }
        this.getProject().refreshLocal(2, null);
    }

    public ISchedulingRule getRule(int kind, Map<String, String> args) {
        return null;
    }
}

