/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.dotnetnew;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.acute.AcutePlugin;
import org.eclipse.acute.dotnetnew.DotnetNewAccessor;
import org.eclipse.acute.dotnetnew.DotnetNewWizardPage;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class DotnetNewWizard
extends Wizard
implements INewWizard {
    private DotnetNewWizardPage wizardPage;

    public DotnetNewWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.wizardPage = new DotnetNewWizardPage();
        this.setWindowTitle("New .NET Core Project");
        Iterator selectionIterator = selection.iterator();
        HashSet<IWorkingSet> workingSets = new HashSet<IWorkingSet>();
        IResource selectedResource = null;
        while (selectionIterator.hasNext()) {
            Object element = selectionIterator.next();
            IResource asResource = this.toResource(element);
            if (asResource != null && selectedResource == null) {
                selectedResource = asResource;
                continue;
            }
            IWorkingSet asWorkingSet = (IWorkingSet)Adapters.adapt(element, IWorkingSet.class);
            if (asWorkingSet == null) continue;
            workingSets.add(asWorkingSet);
        }
        if (workingSets.isEmpty() && selectedResource != null) {
            workingSets.addAll(this.getWorkingSets(selectedResource));
        }
        this.wizardPage.setWorkingSets(workingSets);
        if (selectedResource != null) {
            this.wizardPage.setDirectory(this.toFile(selectedResource));
        } else {
            this.wizardPage.setDirectory(this.newFolderLocation());
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.wizardPage);
    }

    public boolean performFinish() {
        DotnetNewAccessor.Template template = this.wizardPage.getTemplate();
        File location = this.wizardPage.getDirectory();
        String projectName = this.wizardPage.getProjectName();
        if (!location.exists()) {
            location.mkdirs();
        }
        try {
            this.getContainer().run(true, true, monitor -> {
                monitor.beginTask("Creating .NET Core project", 0);
                ArrayList<String> commandLine = new ArrayList<String>();
                commandLine.add(AcutePlugin.getDotnetCommand());
                commandLine.add("new");
                if (template != null) {
                    commandLine.addAll(template.getCLIOptions());
                }
                ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
                processBuilder.directory(location);
                try {
                    Process process = processBuilder.start();
                    boolean isProcessDone = false;
                    while (!isProcessDone) {
                        if (monitor.isCanceled()) {
                            process.destroyForcibly();
                        }
                        isProcessDone = process.waitFor(100L, TimeUnit.MILLISECONDS);
                    }
                    if (process.exitValue() == 0) {
                        this.createProject(projectName, location, monitor);
                    } else {
                        Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)this.getShell(), (String)"Cannot create .NET Core template", (String)("The 'dotnet new' command exited with :" + process.exitValue())));
                    }
                    monitor.done();
                }
                catch (IOException e) {
                    monitor.done();
                    Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)this.getShell(), (String)"Cannot create .NET Core template", (String)("The 'dotnet new' command failed: " + e)));
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Cannot create .NET Core template", (String)("The 'dotnet new' command failed: " + e));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return true;
    }

    private void createProject(String name, File directory, IProgressMonitor monitor) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(name);
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProjectDescription projectDescription = workspace.newProjectDescription(project.getName());
            String projectLocation = directory.getAbsolutePath();
            Path projectPath = new Path(projectLocation);
            projectDescription.setLocation((IPath)projectPath);
            ICommand[] commands = projectDescription.getBuildSpec();
            ICommand command = projectDescription.newCommand();
            command.setBuilderName("org.eclipse.acute.builder.IncrementalDotnetBuilder");
            ICommand[] nc = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, nc, 1, commands.length);
            nc[0] = command;
            projectDescription.setBuildSpec(nc);
            project.create(projectDescription, monitor);
            project.open(monitor);
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Unable to load project description", (String)e.toString());
        }
        IWorkingSetManager wsm = PlatformUI.getWorkbench().getWorkingSetManager();
        IFile csPrgramFile = project.getFile("Program.cs");
        IFile fsPrgramFile = project.getFile("Program.fs");
        Display.getDefault().asyncExec(() -> {
            wsm.addToWorkingSets((IAdaptable)project, this.wizardPage.getWorkingSets());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page != null) {
                try {
                    if (csPrgramFile.exists()) {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)csPrgramFile);
                    } else if (fsPrgramFile.exists()) {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)fsPrgramFile);
                    }
                }
                catch (CoreException e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Cannot open project", (String)e.toString());
                }
            }
        });
    }

    private File newFolderLocation() {
        IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        int appendedNumber = 0;
        File newFile = workspacePath.append("NewDotnetProject").toFile();
        while (newFile.isDirectory()) {
            newFile = workspacePath.append("NewDotnetProject" + ++appendedNumber).toFile();
        }
        return newFile;
    }

    private Set<IWorkingSet> getWorkingSets(IResource resource) {
        IWorkingSet[] allWorkingSets = PlatformUI.getWorkbench().getWorkingSetManager().getAllWorkingSets();
        HashSet<IWorkingSet> fileWorkingSets = new HashSet<IWorkingSet>();
        IWorkingSet[] iWorkingSetArray = allWorkingSets;
        int n = allWorkingSets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet iWorkingSet = iWorkingSetArray[n2];
            IAdaptable[] elements = iWorkingSet.getElements();
            if (Arrays.asList(elements).contains(resource.getProject())) {
                fileWorkingSets.add(iWorkingSet);
            }
            ++n2;
        }
        return fileWorkingSets;
    }

    private IResource toResource(Object o) {
        if (o instanceof IResource) {
            return (IResource)o;
        }
        if (o instanceof IAdaptable) {
            return (IResource)((IAdaptable)o).getAdapter(IResource.class);
        }
        return null;
    }

    private File toFile(IResource r) {
        IPath location = r.getLocation();
        if (location.toFile().isFile()) {
            return location.toFile().getParentFile().getAbsoluteFile();
        }
        return location == null ? null : location.toFile();
    }
}

