/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.dotnetrun;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.eclipse.acute.AcutePlugin;
import org.eclipse.acute.ProjectFileAccessor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class DotnetRunDelegate
extends LaunchConfigurationDelegate
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)selection) {
                IResource resource = null;
                if (element instanceof IResource) {
                    resource = (IResource)element;
                } else if (element instanceof IAdaptable) {
                    resource = (IResource)((IAdaptable)element).getAdapter(IResource.class);
                }
                if (resource == null) continue;
                try {
                    ILaunchConfiguration launchConfig = this.getLaunchConfiguration(mode, resource);
                    launchConfig.launch(mode, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                return;
            }
        }
        Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Unable to Launch", (String)"Unable to launch .NET Core Project from selection."));
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        IFile file = (IFile)input.getAdapter(IFile.class);
        try {
            ILaunchConfiguration launchConfig = this.getLaunchConfiguration(mode, (IResource)file);
            launchConfig.launch(mode, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        File inputFile;
        String projectLocation = configuration.getAttribute("PROJECT_FOLDER", "");
        boolean buildProject = configuration.getAttribute("PROJECT_BUILD", true);
        String projectArguments = configuration.getAttribute("PROJECT_ARGUMENTS", "");
        String projectFramework = configuration.getAttribute("PROJECT_FRAMEWORK", "");
        String projectConfiguration = configuration.getAttribute("PROJECT_CONFIGURATION", "Debug");
        String inputFileLocation = configuration.getAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_STDIN_FILE", "");
        IContainer projectFolder = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(projectLocation));
        File projectFileLocation = new File(projectLocation);
        if (!inputFileLocation.isEmpty() && (inputFile = this.locationToFile(inputFileLocation)) != null) {
            try {
                projectArguments = String.valueOf(projectArguments) + " " + new String(Files.readAllBytes(inputFile.toPath()));
            }
            catch (IOException e) {
                Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Unable to Launch", (String)"Unable to read input file."));
                return;
            }
        }
        if (projectFramework.isEmpty()) {
            Path projectFilePath = new Path(String.valueOf(projectFileLocation.getParent()) + ProjectFileAccessor.getProjectFile(projectFolder));
            String[] frameworks = ProjectFileAccessor.getTargetFrameworks((IPath)projectFilePath);
            if (frameworks.length > 0) {
                projectFramework = frameworks[0];
            } else {
                Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Unable to Launch", (String)"Unable to retrieve target framework"));
                return;
            }
        }
        String finalProjectArguments = projectArguments;
        String framework = projectFramework;
        CompletableFuture.runAsync(() -> {
            try {
                ArrayList<String> commandList;
                if (buildProject) {
                    CharSequence[] cmdLine = new String[]{AcutePlugin.getDotnetCommand(), "build"};
                    Process restoreProcess = DebugPlugin.exec((String[])cmdLine, (File)projectFileLocation);
                    IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)restoreProcess, (String)"dotnet build");
                    process.setAttribute(IProcess.ATTR_CMDLINE, String.join((CharSequence)" ", cmdLine));
                    try {
                        restoreProcess.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (restoreProcess.exitValue() != 0) {
                        return;
                    }
                    projectFolder.getProject().refreshLocal(2, null);
                }
                IPath projectFile = ProjectFileAccessor.getProjectFile(projectFolder);
                File binaryFile = new File(String.valueOf(projectLocation) + "/bin/" + projectConfiguration + "/" + framework + "/" + projectFile.removeFileExtension().addFileExtension("dll").lastSegment());
                if (binaryFile.exists() && binaryFile.isFile()) {
                    commandList = new ArrayList<String>();
                    commandList.add(AcutePlugin.getDotnetCommand());
                    commandList.add("exec");
                    commandList.add(binaryFile.getAbsolutePath());
                    if (!finalProjectArguments.isEmpty()) {
                        commandList.addAll(Arrays.asList(finalProjectArguments.split("\\s+")));
                    }
                } else {
                    Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Unable to Launch", (String)("Unable to find binary file at " + binaryFile.getAbsolutePath())));
                    return;
                }
                CharSequence[] cmdLine = commandList.toArray(new String[commandList.size()]);
                Process p = DebugPlugin.exec((String[])cmdLine, (File)projectFileLocation);
                IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)"dotnet exec");
                process.setAttribute(IProcess.ATTR_CMDLINE, String.join((CharSequence)" ", cmdLine));
            }
            catch (CoreException e) {
                Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Exception in Launch", (String)e.getLocalizedMessage()));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        });
    }

    private ILaunchConfiguration getLaunchConfiguration(String mode, IResource resource) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = launchManager.getLaunchConfigurationType("org.eclipse.acute.dotnetrun.DotnetRunDelegate");
        try {
            ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations(configType);
            String configName = resource.getLocation().toFile().isFile() ? String.valueOf(resource.getParent().getName()) + "." + resource.getName() + " Configuration" : String.valueOf(resource.getName()) + " Configuration";
            ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations;
            int n = launchConfigurations.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration iLaunchConfiguration = iLaunchConfigurationArray[n2];
                if (iLaunchConfiguration.getName().equals(configName) && iLaunchConfiguration.getModes().contains(mode)) {
                    return iLaunchConfiguration;
                }
                ++n2;
            }
            configName = launchManager.generateLaunchConfigurationName(configName);
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, configName);
            if (resource.getLocation().toFile().isFile()) {
                resource = resource.getParent();
            }
            wc.setAttribute("PROJECT_FOLDER", resource.getLocation().toString());
            return wc;
        }
        catch (CoreException e) {
            AcutePlugin.logError(e);
            return null;
        }
    }

    private File locationToFile(String location) {
        if (location.matches("^.*\\$\\{.*\\}.*$")) {
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                location = manager.performStringSubstitution(location, false);
            }
            catch (CoreException e) {
                return null;
            }
        }
        return new File(location);
    }
}

