/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.CubeContentProvider;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.CubeLabelProvider;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class LevelViewDialog
extends BaseDialog {
    private boolean isEdit = false;
    private Button regularBtn;
    private Button dateBtn;
    private boolean isRegular = false;
    private DimensionHandle dimension;
    private List showLevels;
    private CheckboxTreeViewer levelViewer;

    public LevelViewDialog(boolean isEdit) {
        this(UIUtil.getDefaultShell());
        this.isEdit = isEdit;
    }

    public LevelViewDialog(Shell shell) {
        super(Messages.getString("LevelViewDialog.Title"));
    }

    public void setInput(DimensionHandle dimension, List showLevels) {
        this.dimension = dimension;
        this.showLevels = new LinkedList();
        this.showLevels.addAll(showLevels);
        this.isRegular = !dimension.isTimeType();
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.CrossTabLevelViewDialog_ID");
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Label infoLabel = new Label(dialogArea, 64);
        infoLabel.setText(Messages.getString("LevelViewDialog.Label.Info"));
        GridData gd = new GridData(768);
        gd.widthHint = 400;
        infoLabel.setLayoutData((Object)gd);
        if (!this.isEdit && this.dimension.isTimeType()) {
            this.createButtonArea(dialogArea);
        }
        this.createLevelViewer(dialogArea);
        this.init();
        return dialogArea;
    }

    private void createButtonArea(Composite parent) {
        this.regularBtn = new Button(parent, 16);
        this.regularBtn.setText(Messages.getString("LevelViewDialog.Button.Regular.Text"));
        this.regularBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LevelViewDialog.this.isRegular = true;
                LevelViewDialog.this.levelViewer.getTree().setVisible(false);
                LevelViewDialog.this.checkOKButtonStatus();
            }
        });
        this.dateBtn = new Button(parent, 16);
        this.dateBtn.setText(Messages.getString("LevelViewDialog.Button.Date.Text"));
        this.dateBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LevelViewDialog.this.isRegular = false;
                LevelViewDialog.this.levelViewer.getTree().setVisible(true);
                LevelViewDialog.this.checkOKButtonStatus();
            }
        });
        if (this.dimension.isTimeType()) {
            this.dateBtn.setSelection(true);
        } else {
            this.regularBtn.setSelection(true);
        }
    }

    protected boolean initDialog() {
        this.checkOKButtonStatus();
        return super.initDialog();
    }

    private void init() {
        if (this.dimension != null) {
            this.levelViewer.setInput((Object)this.dimension);
            this.levelViewer.expandToLevel(this.dimension.getDefaultHierarchy().getContentCount("levels"));
        }
        if (this.showLevels == null || this.showLevels.size() == 0) {
            return;
        }
        Object item = this.levelViewer.getTree().getItem(0);
        while (item != null) {
            LevelHandle level = (LevelHandle)item.getData();
            if (this.showLevels.contains(level)) {
                item.setChecked(true);
            }
            item = item.getItemCount() > 0 ? item.getItem(0) : null;
        }
    }

    private void createLevelViewer(Composite parent) {
        this.levelViewer = new CheckboxTreeViewer(parent, 2052);
        GridData gd = new GridData(1808);
        gd.widthHint = 340;
        gd.heightHint = 250;
        this.levelViewer.getTree().setLayoutData((Object)gd);
        this.levelViewer.setContentProvider((IContentProvider)new CubeContentProvider());
        this.levelViewer.setLabelProvider((IBaseLabelProvider)new CubeLabelProvider());
        this.levelViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                LevelHandle item = (LevelHandle)event.getElement();
                if (event.getChecked()) {
                    if (!LevelViewDialog.this.showLevels.contains(item)) {
                        LevelViewDialog.this.showLevels.add(item);
                    }
                } else if (LevelViewDialog.this.showLevels.contains(item)) {
                    LevelViewDialog.this.showLevels.remove(item);
                }
                LevelViewDialog.this.checkOKButtonStatus();
            }
        });
    }

    public Object getResult() {
        if (!this.isEdit && this.isRegular) {
            return new ArrayList();
        }
        return this.showLevels;
    }

    private void checkOKButtonStatus() {
        if (!(!this.isEdit && this.isRegular || this.showLevels != null && this.showLevels.size() != 0)) {
            if (this.getOkButton() != null) {
                this.getOkButton().setEnabled(false);
            }
        } else if (this.getOkButton() != null) {
            this.getOkButton().setEnabled(true);
        }
    }
}

