/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts;

import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.DeferredGraphicalViewer;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.NothingLocator;
import org.eclipse.birt.report.designer.internal.ui.layout.ReportFlowLayout;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.CrosstabCellEditPart;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.figures.FirstCellFigure;
import org.eclipse.birt.report.item.crosstab.internal.ui.util.CrosstabUIHelper;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;

public class CrosstabFirstCellEditPart
extends CrosstabCellEditPart {
    private static int MIN_WIDTH = 18;
    private static int MIN_HEIGHT = 20;
    private MenuManager manager;
    Figure contentPane;
    ControlFigure controlFigure;

    public CrosstabFirstCellEditPart(Object model) {
        super(model);
    }

    @Override
    protected IFigure createFigure() {
        FirstCellFigure figure = new FirstCellFigure();
        this.contentPane = new Figure();
        ReportFlowLayout rflayout = new ReportFlowLayout(){

            public void layout(IFigure parent) {
                super.layout(parent);
            }
        };
        this.contentPane.setLayoutManager((LayoutManager)rflayout);
        this.contentPane.setOpaque(false);
        figure.add((IFigure)this.contentPane);
        this.controlFigure = new ControlFigure((GraphicalEditPart)this, (Locator)new NothingLocator());
        figure.add((IFigure)this.controlFigure);
        return figure;
    }

    @Override
    public void refreshFigure() {
        super.refreshFigure();
        this.setLayoutConstraint((EditPart)this, (IFigure)this.controlFigure, this.controlFigure.getConstraint());
    }

    protected void setTextAliment(StyleHandle style) {
        String hAlign = style.getTextAlign();
        String vAlign = style.getVerticalAlign();
        ReportFlowLayout rflayout = (ReportFlowLayout)this.contentPane.getLayoutManager();
        if ("center".equals(hAlign)) {
            rflayout.setMajorAlignment(0);
        } else if ("right".equals(hAlign) && !this.getFigure().isMirrored()) {
            rflayout.setMajorAlignment(2);
        } else if ("left".equals(hAlign) && this.getFigure().isMirrored()) {
            rflayout.setMajorAlignment(2);
        } else {
            rflayout.setMajorAlignment(1);
        }
        if ("middle".equals(vAlign)) {
            rflayout.setMinorAlignment(0);
        } else if ("bottom".equals(vAlign)) {
            rflayout.setMinorAlignment(2);
        } else {
            rflayout.setMinorAlignment(1);
        }
        rflayout.layout(this.getFigure());
    }

    public IFigure getContentPane() {
        return this.contentPane;
    }

    public void setManager(MenuManager manager) {
        this.manager = manager;
    }

    public boolean contains(Point pt) {
        return this.controlFigure.contains(pt);
    }

    class ControlFigure
    extends AbstractHandle {
        Image image;

        public ControlFigure(GraphicalEditPart owner, Locator loc) {
            super(owner, loc);
            this.image = CrosstabUIHelper.getImage("icons/pal/options.gif");
        }

        protected DragTracker createDragTracker() {
            DragEditPartsTracker track = new DragEditPartsTracker((EditPart)CrosstabFirstCellEditPart.this){

                protected boolean handleButtonDown(int button) {
                    if (this.getCurrentViewer() instanceof DeferredGraphicalViewer) {
                        ((DeferredGraphicalViewer)this.getCurrentViewer()).initStepDat();
                    }
                    boolean bool = super.handleButtonDown(button);
                    return bool;
                }

                protected boolean handleButtonUp(int button) {
                    CrosstabFirstCellEditPart first;
                    boolean bool = super.handleButtonUp(button);
                    if (button == 1 && this.getSourceEditPart() instanceof CrosstabFirstCellEditPart && (first = (CrosstabFirstCellEditPart)this.getSourceEditPart()).contains(this.getLocation())) {
                        CrosstabFirstCellEditPart.this.manager.createContextMenu(CrosstabFirstCellEditPart.this.getViewer().getControl());
                        Menu menu = CrosstabFirstCellEditPart.this.manager.getMenu();
                        menu.setVisible(true);
                        return true;
                    }
                    return bool;
                }
            };
            return track;
        }

        public Insets getInsets() {
            return new Insets(1, 1, 1, 1);
        }

        public Rectangle getConstraint() {
            return new Rectangle(0, 0, MIN_WIDTH, MIN_HEIGHT);
        }

        public Dimension getMinimumSize(int wHint, int hHint) {
            return this.getConstraint().getSize();
        }

        public Dimension getPreferredSize(int wHint, int hHint) {
            Rectangle rect = this.getConstraint();
            int height = Math.max(hHint, rect.height);
            return new Dimension(rect.width, height);
        }

        public void addNotify() {
            super.addNotify();
        }

        protected void paintFigure(Graphics graphics) {
            graphics.setBackgroundColor(ReportColorConstants.greyFillColor);
            graphics.fillRectangle(this.getClientArea());
            graphics.drawImage(this.image, this.getImagePoint());
        }

        private Point getImagePoint() {
            Rectangle rect = this.getClientArea();
            Point center = this.getClientArea().getCenter().getCopy();
            center.x -= this.image.getBounds().width / 2;
            center.y = rect.y;
            return center;
        }

        public boolean contains(Point pt) {
            Point p = this.getImagePoint();
            Rectangle rect = new Rectangle(p.x, p.y, this.image.getBounds().width, this.image.getBounds().height);
            this.translateToAbsolute((Translatable)rect);
            return rect.contains(pt);
        }
    }
}

