/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.corrosion.CorrosionPlugin;

public class CommandJob
extends Job {
    private Process process;
    private String[] command;
    private String progressMessage;
    private String errorTitle;
    private String errorMessage;
    private int expectedWork;

    public CommandJob(String[] command, String progressMessage, String errorTitle, String errorMessage, int expectedWork) {
        super(progressMessage);
        this.command = command;
        this.progressMessage = progressMessage;
        this.errorTitle = errorTitle;
        this.errorMessage = errorMessage;
        this.expectedWork = expectedWork;
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.expectedWork);
        try {
            subMonitor.beginTask(this.progressMessage, this.expectedWork);
            this.process = new ProcessBuilder(this.command).start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
            CompletableFuture.runAsync(() -> reader.lines().forEachOrdered(line -> {
                subMonitor.subTask(line);
                if (this.expectedWork > 0) {
                    subMonitor.worked(1);
                }
            }));
            if (this.process.waitFor() != 0) {
                if (!subMonitor.isCanceled()) {
                    CorrosionPlugin.showError(this.errorTitle, this.errorMessage);
                }
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
        catch (IOException | InterruptedException e) {
            CorrosionPlugin.showError(this.errorTitle, this.errorMessage, e);
            return Status.CANCEL_STATUS;
        }
    }

    protected void canceling() {
        if (this.process != null) {
            this.process.destroyForcibly();
        }
    }
}

