/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.CorrosionPreferencePage;
import org.eclipse.corrosion.Messages;
import org.eclipse.corrosion.RustManager;
import org.eclipse.jface.preference.IPreferenceStore;

public class CorrosionPreferenceInitializer
extends AbstractPreferenceInitializer {
    private static final IPreferenceStore STORE = CorrosionPlugin.getDefault().getPreferenceStore();
    public static String rustSourcePreference = "corrosion.rustSource";
    public static String defaultPathsPreference = "corrosion.rustup_defaultPaths";
    public static String rustupPathPreference = "corrosion.rustup_rustupPath";
    public static String cargoPathPreference = "corrosion.rustup_cargoPath";
    public static String toolchainIdPreference = "corrosion.rustup_toolchain_Id";
    public static String toolchainTypePreference = "corrosion.rustup_toolchain_type";
    public static String rlsPathPreference = "corrosion.rslPath";
    public static String sysrootPathPreference = "corrosion.sysrootPath";

    public void initializeDefaultPreferences() {
        STORE.setDefault(rustSourcePreference, "rustup");
        STORE.setDefault(defaultPathsPreference, true);
        STORE.setDefault(rustupPathPreference, this.getRustupPathBestGuess());
        STORE.setDefault(cargoPathPreference, this.getCargoPathBestGuess());
        this.setToolchainBestGuesses();
        STORE.setDefault(rlsPathPreference, this.getRLSPathBestGuess());
        STORE.setDefault(sysrootPathPreference, this.getSysrootPathBestGuess());
    }

    private String getRustupPathBestGuess() {
        File possibleCommandFile;
        String command = this.findCommandPath("rustup");
        if (command.isEmpty() && (possibleCommandFile = new File(String.valueOf(System.getProperty("user.home")) + "/.cargo/bin/rustup")).exists() && possibleCommandFile.isFile() && possibleCommandFile.canExecute()) {
            return possibleCommandFile.getAbsolutePath();
        }
        return command;
    }

    private String getCargoPathBestGuess() {
        File possibleCommandFile;
        String command = this.findCommandPath("cargo");
        if (command.isEmpty() && (possibleCommandFile = new File(String.valueOf(System.getProperty("user.home")) + "/.cargo/bin/cargo")).exists() && possibleCommandFile.isFile() && possibleCommandFile.canExecute()) {
            return possibleCommandFile.getAbsolutePath();
        }
        return command;
    }

    private String findCommandPath(String command) {
        try {
            ProcessBuilder builder = new ProcessBuilder("which", command);
            Process process = builder.start();
            if (process.waitFor() == 0) {
                Throwable throwable = null;
                Object var5_7 = null;
                try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    return in.readLine();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        return "";
    }

    private void setToolchainBestGuesses() {
        String toolchain = RustManager.getDefaultToolchain();
        if (toolchain == null || toolchain.isEmpty()) {
            STORE.setDefault(toolchainIdPreference, "");
            STORE.setDefault(toolchainTypePreference, "Other");
            return;
        }
        int splitIndex = toolchain.indexOf(45);
        if (splitIndex != -1) {
            String type = toolchain.substring(0, splitIndex);
            if ("nightly".equals(type)) {
                STORE.setDefault(toolchainIdPreference, toolchain);
                STORE.setDefault(toolchainTypePreference, "Nightly");
            } else {
                for (String option : CorrosionPreferencePage.RUSTUP_TOOLCHAIN_OPTIONS) {
                    if (!option.toLowerCase().equals(type)) continue;
                    STORE.setDefault(toolchainIdPreference, type);
                    STORE.setDefault(toolchainTypePreference, option);
                }
            }
            return;
        }
        STORE.setDefault(toolchainIdPreference, toolchain.trim());
        STORE.setDefault(toolchainTypePreference, "Other");
    }

    private String getRLSPathBestGuess() {
        File possibleCommandFile;
        String command = this.findCommandPath("rls");
        if (command.isEmpty() && (possibleCommandFile = new File(String.valueOf(System.getProperty("user.home")) + "/.cargo/bin/rls")).exists() && possibleCommandFile.isFile() && possibleCommandFile.canExecute()) {
            return possibleCommandFile.getAbsolutePath();
        }
        return command;
    }

    private String getSysrootPathBestGuess() {
        File rustc = new File(this.findCommandPath("rustc"));
        if (!(rustc.exists() && rustc.isFile() && rustc.canExecute())) {
            rustc = new File(String.valueOf(System.getProperty("user.home")) + "/.cargo/bin/rustc");
        }
        if (!(rustc.exists() && rustc.isFile() && rustc.canExecute())) {
            return "";
        }
        String[] command = new String[]{rustc.getAbsolutePath(), Messages.CorrosionPreferenceInitializer_29, Messages.CorrosionPreferenceInitializer_30};
        try {
            Process process = Runtime.getRuntime().exec(command);
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                return in.readLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return Messages.CorrosionPreferenceInitializer_31;
        }
    }
}

