/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.corrosion.CommandJob;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.CorrosionPreferenceInitializer;
import org.eclipse.corrosion.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class RustManager {
    private static final IPreferenceStore STORE = CorrosionPlugin.getDefault().getPreferenceStore();
    private static Job settingToolchainJob = null;

    /*
     * Unable to fully structure code
     */
    public static String getDefaultToolchain() {
        block18: {
            rustup = RustManager.STORE.getString(CorrosionPreferenceInitializer.rustupPathPreference);
            if (!rustup.isEmpty()) {
                try {
                    builder = new ProcessBuilder(new String[]{rustup, "show"});
                    process = builder.start();
                    if (process.waitFor() != 0) break block18;
                    var3_4 = null;
                    var4_6 = null;
                    try {
                        in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        try {
                            line = in.readLine();
                            while (true) {
                                if (line.matches("^.*\\(default\\)$")) {
                                    if (line.matches("^nightly-\\d{4}-\\d{2}-\\d{2}.*$")) {
                                        return line.substring(0, 18);
                                    }
                                    splitIndex = line.indexOf(45);
                                    if (splitIndex != -1) {
                                        return line.substring(0, splitIndex);
                                    }
                                    return line;
                                }
                                line = in.readLine();
                                return line;
                            }
                        }
                        finally {
                            if (line != null) ** continue;
                        }
                    }
                    catch (Throwable var4_7) {
                        if (var3_4 == null) {
                            var3_4 = var4_7;
                        } else if (var3_4 != var4_7) {
                            var3_4.addSuppressed(var4_7);
                        }
                        throw var3_4;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    public static void setDefaultToolchain(final String toolchainId) {
        if (settingToolchainJob != null) {
            settingToolchainJob.cancel();
        }
        settingToolchainJob = new Job(Messages.RustManager_settingRLSToolchain){
            CommandJob currentCommandJob;

            protected IStatus run(IProgressMonitor monitor) {
                ArrayList<CommandJob> jobs = new ArrayList<CommandJob>();
                jobs.add(RustManager.createRustupCommandJob(Messages.RustManager_installingToolchain, NLS.bind((String)Messages.RustManager_unableToInstallToolchain, (Object)toolchainId), new String[]{"toolchain", "install", toolchainId}));
                jobs.add(RustManager.createRustupCommandJob(Messages.RustManager_settingDefaultToolchain, NLS.bind((String)Messages.RustManager_unableToSetDefaultToolchain, (Object)toolchainId), new String[]{"default", toolchainId}));
                jobs.add(RustManager.createRustupCommandJob(Messages.RustManager_addingRLSPrevios, NLS.bind((String)Messages.RustManager_toolchainDoesntIncludeRLS, (Object)toolchainId), new String[]{"component", "add", "rls-preview"}));
                jobs.add(RustManager.createRustupCommandJob(Messages.RustManager_addingRustAnalysisRustSrc, Messages.RustManager_unableToAddComponent, new String[]{"component", "add", "rust-analysis"}));
                Iterator iterator = jobs.iterator();
                while (iterator.hasNext()) {
                    CommandJob commandJob;
                    this.currentCommandJob = commandJob = (CommandJob)((Object)iterator.next());
                    if (this.currentCommandJob.run(monitor) == Status.CANCEL_STATUS) {
                        return Status.CANCEL_STATUS;
                    }
                    monitor.worked(1);
                }
                HashMap<String, String> updatedSettings = new HashMap<String, String>();
                updatedSettings.put("target", toolchainId);
                RustManager.sendDidChangeConfigurationsMessage(updatedSettings);
                return Status.OK_STATUS;
            }

            protected void canceling() {
                if (this.currentCommandJob != null) {
                    this.currentCommandJob.cancel();
                }
            }
        };
        settingToolchainJob.schedule();
    }

    private static void sendDidChangeConfigurationsMessage(Map<String, String> updatedSettings) {
        DidChangeConfigurationParams params = new DidChangeConfigurationParams();
        params.setSettings(updatedSettings);
        LanguageServiceAccessor.LSPDocumentInfo info = RustManager.infoFromOpenEditors();
        if (info != null) {
            info.getInitializedLanguageClient().thenAccept(languageServer -> languageServer.getWorkspaceService().didChangeConfiguration(params));
        }
    }

    private static CommandJob createRustupCommandJob(String progressMessage, String errorMessage, String ... arguments) {
        String rustup = STORE.getString(CorrosionPreferenceInitializer.rustupPathPreference);
        if (rustup.isEmpty()) {
            return null;
        }
        String[] command = new String[arguments.length + 1];
        command[0] = rustup;
        System.arraycopy(arguments, 0, command, 1, arguments.length);
        CommandJob commandJob = new CommandJob(command, progressMessage, Messages.RustManager_rootToolchainSelectionFailure, errorMessage, 0);
        return commandJob;
    }

    private static LanguageServiceAccessor.LSPDocumentInfo infoFromOpenEditors() {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    block6: {
                        IDocument document;
                        List infos;
                        IEditorInput input;
                        IEditorReference editor = iEditorReferenceArray[n6];
                        try {
                            input = editor.getEditorInput();
                        }
                        catch (PartInitException e) {
                            break block6;
                        }
                        if (input.getName().endsWith(".rs") && editor.getEditor(false) instanceof ITextEditor && !(infos = LanguageServiceAccessor.getLSPDocumentInfosFor((IDocument)(document = ((ITextEditor)editor.getEditor(false)).getDocumentProvider().getDocument((Object)input)), capabilities -> Boolean.TRUE.equals(capabilities.getReferencesProvider()))).isEmpty()) {
                            return (LanguageServiceAccessor.LSPDocumentInfo)infos.iterator().next();
                        }
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static List<String> getToolchains() {
        ArrayList<String> toolchainsList;
        block17: {
            toolchainsList = new ArrayList<String>();
            String rustup = STORE.getString(CorrosionPreferenceInitializer.rustupPathPreference);
            if (!rustup.isEmpty()) {
                try {
                    ProcessBuilder builder = new ProcessBuilder(rustup, "show");
                    Process process = builder.start();
                    if (process.waitFor() != 0) break block17;
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                        String line = in.readLine();
                        while (line != null && !line.equals("active toolchain")) {
                            int splitIndex;
                            String toolchain = "";
                            if (line.matches("^nightly-\\d{4}-\\d{2}-\\d{2}.*$")) {
                                toolchain = line.substring(0, 18);
                            } else if (line.matches("\\w+\\-.*") && (splitIndex = line.indexOf(45)) != -1) {
                                toolchain = line.substring(0, splitIndex);
                            }
                            if (!toolchain.isEmpty()) {
                                toolchainsList.add(toolchain);
                            }
                            line = in.readLine();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return toolchainsList;
    }
}

