/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.edit;

import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.CorrosionPreferenceInitializer;
import org.eclipse.corrosion.CorrosionPreferencePage;
import org.eclipse.corrosion.Messages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class RLSStreamConnectionProvider
implements StreamConnectionProvider {
    private static boolean hasCancelledSetup = false;
    private boolean DEBUG = Boolean.parseBoolean(System.getProperty("rsl.lsp.debug"));
    private Process process;

    public void start() throws IOException {
        boolean wereSystemPropertiesSet = this.setSystemProperties();
        String rls = this.getRLS();
        if (rls.isEmpty() || !wereSystemPropertiesSet) {
            this.showSetupRustNotification();
            return;
        }
        String[] command = new String[]{"/bin/bash", "-c", rls};
        if (Platform.getOS().equals("win32")) {
            command = new String[]{"cmd", "/c", rls};
        }
        this.process = Runtime.getRuntime().exec(command);
    }

    private boolean setSystemProperties() {
        CorrosionPlugin plugin = CorrosionPlugin.getDefault();
        IPreferenceStore preferenceStore = plugin.getPreferenceStore();
        int rustSourceIndex = CorrosionPreferencePage.RUST_SOURCE_OPTIONS.indexOf(preferenceStore.getString(CorrosionPreferenceInitializer.rustSourcePreference));
        String sysrootPath = "";
        if (rustSourceIndex == 0) {
            String rustup = preferenceStore.getString(CorrosionPreferenceInitializer.rustupPathPreference);
            String toolchain = preferenceStore.getString(CorrosionPreferenceInitializer.toolchainIdPreference);
            if (!rustup.isEmpty() && !toolchain.isEmpty()) {
                String[] command = new String[]{rustup, "run", toolchain, "rustc", "--print", "sysroot"};
                try {
                    Process process = Runtime.getRuntime().exec(command);
                    Throwable throwable = null;
                    Object var10_12 = null;
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                        sysrootPath = in.readLine();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {}
            }
        } else if (rustSourceIndex == 1) {
            sysrootPath = preferenceStore.getString(CorrosionPreferenceInitializer.sysrootPathPreference);
        }
        if (!sysrootPath.isEmpty()) {
            System.setProperty("SYS_ROOT", sysrootPath);
            System.setProperty("LD_LIBRARY_PATH", String.valueOf(sysrootPath) + "/lib");
            String sysRoot = System.getProperty("SYS_ROOT");
            String ldLibraryPath = System.getProperty("LD_LIBRARY_PATH");
            if (sysRoot != null && !sysRoot.isEmpty() && ldLibraryPath != null && !ldLibraryPath.isEmpty()) {
                return true;
            }
        }
        CorrosionPlugin.getDefault().getLog().log((IStatus)new Status(4, CorrosionPlugin.getDefault().getBundle().getSymbolicName(), Messages.RLSStreamConnectionProvider_unableToSet));
        return false;
    }

    private String getRLS() {
        String rls;
        CorrosionPlugin plugin = CorrosionPlugin.getDefault();
        IPreferenceStore preferenceStore = plugin.getPreferenceStore();
        int rustSourceIndex = CorrosionPreferencePage.RUST_SOURCE_OPTIONS.indexOf(preferenceStore.getString(CorrosionPreferenceInitializer.rustSourcePreference));
        if (rustSourceIndex == 0) {
            String rustup = preferenceStore.getString(CorrosionPreferenceInitializer.rustupPathPreference);
            String toolchain = preferenceStore.getString(CorrosionPreferenceInitializer.toolchainIdPreference);
            if (!rustup.isEmpty() && !toolchain.isEmpty()) {
                return String.valueOf(rustup) + " run " + toolchain + " rls";
            }
        } else if (rustSourceIndex == 1 && !(rls = preferenceStore.getString(CorrosionPreferenceInitializer.rlsPathPreference)).isEmpty()) {
            return rls;
        }
        CorrosionPlugin.getDefault().getLog().log((IStatus)new Status(4, CorrosionPlugin.getDefault().getBundle().getSymbolicName(), Messages.RLSStreamConnectionProvider_rlsNotFound));
        return "";
    }

    private void showSetupRustNotification() {
        if (hasCancelledSetup) {
            return;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        int dialogResponse = MessageDialog.open((int)5, (Shell)shell, (String)Messages.RLSStreamConnectionProvider_rustSupportNotFound, (String)Messages.RLSStreamConnectionProvider_requirementsNotFound, (int)0, (String[])new String[]{Messages.RLSStreamConnectionProvider_OpenPreferences, IDialogConstants.CANCEL_LABEL});
        if (dialogResponse == 0) {
            PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.corrosion.preferencePage", (String[])new String[]{"org.eclipse.corrosion.preferencePage"}, null);
            preferenceDialog.setBlockOnOpen(true);
            preferenceDialog.open();
        } else {
            hasCancelledSetup = true;
        }
    }

    public InputStream getInputStream() {
        if (this.DEBUG) {
            return new FilterInputStream(this.process.getInputStream()){

                @Override
                public int read() throws IOException {
                    int res = super.read();
                    System.err.print((char)res);
                    return res;
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    int bytes = super.read(b, off, len);
                    byte[] payload = new byte[bytes];
                    System.arraycopy(b, off, payload, 0, bytes);
                    System.err.print(new String(payload));
                    return bytes;
                }

                @Override
                public int read(byte[] b) throws IOException {
                    int bytes = super.read(b);
                    byte[] payload = new byte[bytes];
                    System.arraycopy(b, 0, payload, 0, bytes);
                    System.err.print(new String(payload));
                    return bytes;
                }
            };
        }
        return this.process.getInputStream();
    }

    public OutputStream getOutputStream() {
        if (this.DEBUG) {
            return new FilterOutputStream(this.process.getOutputStream()){

                @Override
                public void write(int b) throws IOException {
                    System.err.print((char)b);
                    super.write(b);
                }

                @Override
                public void write(byte[] b) throws IOException {
                    System.err.print(new String(b));
                    super.write(b);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    byte[] actual = new byte[len];
                    System.arraycopy(b, off, actual, 0, len);
                    System.err.print(new String(actual));
                    super.write(b, off, len);
                }
            };
        }
        return this.process.getOutputStream();
    }

    public void stop() {
        this.process.destroy();
    }

    public InputStream getErrorStream() {
        if (this.DEBUG) {
            return new FilterInputStream(this.process.getErrorStream()){

                @Override
                public int read() throws IOException {
                    int res = super.read();
                    System.err.print((char)res);
                    return res;
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    int bytes = super.read(b, off, len);
                    byte[] payload = new byte[bytes];
                    System.arraycopy(b, off, payload, 0, bytes);
                    System.err.print(new String(payload));
                    return bytes;
                }

                @Override
                public int read(byte[] b) throws IOException {
                    int bytes = super.read(b);
                    byte[] payload = new byte[bytes];
                    System.arraycopy(b, 0, payload, 0, bytes);
                    System.err.print(new String(payload));
                    return bytes;
                }
            };
        }
        return this.process.getErrorStream();
    }
}

