/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.corrosion.Messages;
import org.eclipse.corrosion.cargo.core.CargoTools;
import org.eclipse.corrosion.launch.RustLaunchDelegateTools;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;

public class CargoTestDelegate
extends LaunchConfigurationDelegate
implements ILaunchShortcut {
    public static final String PROJECT_ATTRIBUTE = "PROJECT";
    public static final String TEST_OPTIONS_ATTRIBUTE = "RUN_OPTIONS";
    public static final String TEST_ARGUMENTS_ATTRIBUTE = "RUN_ARGUMENTS";
    public static final String TEST_NAME_ATTRIBUTE = "TEST_NAME";

    public void launch(ISelection selection, String mode) {
        ILaunchConfiguration launchConfig = this.getLaunchConfiguration(mode, RustLaunchDelegateTools.firstResourceFromSelection(selection));
        RustLaunchDelegateTools.launch(launchConfig, mode);
    }

    public void launch(IEditorPart editor, String mode) {
        ILaunchConfiguration launchConfig = this.getLaunchConfiguration(mode, RustLaunchDelegateTools.resourceFromEditor(editor));
        RustLaunchDelegateTools.launch(launchConfig, mode);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ArrayList<String> cargoTestCommand = new ArrayList<String>();
        cargoTestCommand.add(CargoTools.getCargoCommand());
        cargoTestCommand.add("test");
        String projectName = configuration.getAttribute(PROJECT_ATTRIBUTE, "");
        String options = configuration.getAttribute(TEST_OPTIONS_ATTRIBUTE, "").trim();
        String testName = configuration.getAttribute(TEST_NAME_ATTRIBUTE, "");
        String arguments = configuration.getAttribute(TEST_ARGUMENTS_ATTRIBUTE, "").trim();
        IProject project = null;
        if (!projectName.isEmpty()) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        if (project == null || !project.exists()) {
            RustLaunchDelegateTools.openError(Messages.CargoRunDelegate_unableToLaunch, Messages.CargoRunDelegate_unableToFindProject);
            return;
        }
        IFile cargoManifest = project.getFile("Cargo.toml");
        if (!cargoManifest.exists()) {
            RustLaunchDelegateTools.openError(Messages.CargoRunDelegate_unableToLaunch, Messages.CargoRunDelegate_unableToFindToml);
            return;
        }
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        if (!options.isEmpty()) {
            cargoTestCommand.addAll(Arrays.asList(manager.performStringSubstitution(options).split("\\s+")));
        }
        String cargoPathString = cargoManifest.getLocation().toPortableString();
        cargoTestCommand.add("--manifest-path");
        cargoTestCommand.add(cargoPathString);
        if (testName != null && !testName.isEmpty()) {
            cargoTestCommand.add(testName);
        }
        if (!arguments.isEmpty()) {
            cargoTestCommand.add("--");
            cargoTestCommand.addAll(Arrays.asList(manager.performStringSubstitution(arguments).split("\\s+")));
        }
        ArrayList<String> finalTestCommand = cargoTestCommand;
        CompletableFuture.runAsync(() -> {
            try {
                CharSequence[] cmdLine = finalTestCommand.toArray(new String[finalTestCommand.size()]);
                Process p = DebugPlugin.exec((String[])cmdLine, null);
                IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)"cargo test");
                process.setAttribute(IProcess.ATTR_CMDLINE, String.join((CharSequence)" ", cmdLine));
            }
            catch (CoreException e) {
                RustLaunchDelegateTools.openError(Messages.CargoRunDelegate_unableToLaunch, e.getLocalizedMessage());
            }
        });
    }

    private ILaunchConfiguration getLaunchConfiguration(String mode, IResource resource) {
        ILaunchConfiguration launchConfiguration = RustLaunchDelegateTools.getLaunchConfiguration(mode, resource, "org.eclipse.corrosion.test.CargoTestDelegate");
        if (launchConfiguration instanceof ILaunchConfigurationWorkingCopy) {
            ILaunchConfigurationWorkingCopy wc = (ILaunchConfigurationWorkingCopy)launchConfiguration;
            wc.setAttribute(PROJECT_ATTRIBUTE, resource.getProject().getName());
        }
        return launchConfiguration;
    }
}

