/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.util;

import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.result.ColumnIdentifier;
import org.eclipse.datatools.connectivity.oda.spec.result.SortSpecification;
import org.eclipse.datatools.connectivity.oda.spec.util.QuerySpecificationHelper;

public class SortSpecMigrator {
    public static SortSpecification convertSortSpecification(SortSpec oldSortSpec) {
        if (oldSortSpec == null) {
            return null;
        }
        SortSpecification resultSortSpec = new QuerySpecificationHelper().createSortSpecification(oldSortSpec.getSortMode());
        int i = 1;
        while (i <= oldSortSpec.getSortKeyCount()) {
            resultSortSpec.addSortKey(new ColumnIdentifier(oldSortSpec.getSortColumn(i)), oldSortSpec.getSortOrder(i));
            ++i;
        }
        return resultSortSpec;
    }

    public static SortSpec convertSortSpecification(SortSpecification resultSortSpec) {
        if (resultSortSpec == null) {
            return null;
        }
        SortSpec oldSortSpec = new SortSpec(resultSortSpec.getSortMode());
        int i = 1;
        while (i <= resultSortSpec.getSortKeyCount()) {
            ColumnIdentifier sortColumn = resultSortSpec.getSortColumn(i);
            if (sortColumn == null) {
                throw new IllegalArgumentException(Messages.bind((String)Messages.querySpec_INVALID_ARG, (Object)resultSortSpec));
            }
            oldSortSpec.addSortKey(sortColumn.getNameExpression(), resultSortSpec.getSortDirection(i));
            ++i;
        }
        return oldSortSpec;
    }
}

