/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TablePackage;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.TableWidget;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelChangedListener
extends AdapterImpl {
    private static final boolean DEBUG = TableWidget.DEBUG_RESOURCE_LISTENER;
    private final Runnable runnable;
    private final Set<Resource> listenedResources = new HashSet<Resource>();

    public ModelChangedListener(Table table, Runnable runnable) {
        this.runnable = runnable;
        EList rows = table.getRows();
        this.addChangeListener((List<Row>)rows);
        this.addListenerOnTable(table);
    }

    private final void addChangeListener(List<Row> rows) {
        HashSet<Resource> resources = new HashSet<Resource>();
        for (Row row : rows) {
            Resource resource = row.eResource();
            resources.add(resource);
        }
        for (Resource resource : resources) {
            this.addAdapterToResource(resource);
        }
    }

    private void addAdapterToResource(Resource resource) {
        resource.setTrackingModification(true);
        if (!resource.eAdapters().contains((Object)this)) {
            resource.eAdapters().add((Object)this);
            this.listenedResources.add(resource);
        }
    }

    private final void addListenerOnTable(Table table) {
        AdapterImpl tableListener = new AdapterImpl(){

            public void notifyChanged(Notification notif) {
                Object feature = notif.getFeature();
                if (feature != null && feature.equals(TablePackage.eINSTANCE.getTable_Rows()) && notif.getOldValue() instanceof List && notif.getNewValue() instanceof List) {
                    List oldRows = (List)notif.getOldValue();
                    List newRows = (List)notif.getNewValue();
                    ModelChangedListener.this.onRowChanged(oldRows, newRows);
                }
            }
        };
        table.eAdapters().add((Object)tableListener);
    }

    protected final void onRowChanged(List<Row> oldRows, List<Row> newRows) {
        List<Row> addedRows = ModelChangedListener.computeDiffRows(newRows, oldRows);
        this.addChangeListener(addedRows);
    }

    protected static List<Row> computeDiffRows(List<Row> rows1, List<Row> rows2) {
        ArrayList<Row> diffRows = new ArrayList<Row>(rows1);
        diffRows.removeAll(rows2);
        return diffRows;
    }

    public void notifyChanged(Notification notif) {
        boolean refModelChanged;
        int eventType = notif.getEventType();
        boolean bl = refModelChanged = eventType != 8 && eventType != 9;
        if (DEBUG) {
            DebugUtils.debug((String)("notification=" + notif));
            DebugUtils.debug((String)("referenceModelChanged=" + refModelChanged));
        }
        if (refModelChanged) {
            if (DEBUG) {
                DebugUtils.debug((boolean)DEBUG, (String)"One of the model refered by the table has changed.");
            }
            Display.getDefault().asyncExec(this.runnable);
        }
    }

    public void dispose() {
        for (Resource resource : this.listenedResources) {
            resource.eAdapters().remove((Object)this);
        }
    }
}

