/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.SourceRefElement;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.core.compiler.OTNameUtils;

public abstract class JavaElement
extends PlatformObject
implements IJavaElement {
    private static final byte[] CLOSING_DOUBLE_QUOTE = new byte[]{34};
    private static final byte[] CHARSET = new byte[]{99, 104, 97, 114, 115, 101, 116, 61};
    private static final byte[] CHARSET_HTML5 = new byte[]{99, 104, 97, 114, 115, 101, 116, 61, 34};
    private static final byte[] META_START = new byte[]{60, 109, 101, 116, 97};
    private static final byte[] META_END = new byte[]{34, 62};
    public static final char JEM_ESCAPE = '\\';
    public static final char JEM_JAVAPROJECT = '=';
    public static final char JEM_PACKAGEFRAGMENTROOT = '/';
    public static final char JEM_PACKAGEFRAGMENT = '<';
    public static final char JEM_FIELD = '^';
    public static final char JEM_METHOD = '~';
    public static final char JEM_INITIALIZER = '|';
    public static final char JEM_COMPILATIONUNIT = '{';
    public static final char JEM_CLASSFILE = '(';
    public static final char JEM_MODULAR_CLASSFILE = '\'';
    public static final char JEM_TYPE = '[';
    public static final char JEM_PACKAGEDECLARATION = '%';
    public static final char JEM_IMPORTDECLARATION = '#';
    public static final char JEM_COUNT = '!';
    public static final char JEM_LOCALVARIABLE = '@';
    public static final char JEM_TYPE_PARAMETER = ']';
    public static final char JEM_ANNOTATION = '}';
    public static final char JEM_LAMBDA_EXPRESSION = ')';
    public static final char JEM_LAMBDA_METHOD = '&';
    public static final char JEM_STRING = '\"';
    public static final char JEM_MODULE = '`';
    public static final char JEM_DELIMITER_ESCAPE = '=';
    protected JavaElement parent;
    protected static final String[] NO_STRINGS = new String[0];
    protected static final JavaElement[] NO_ELEMENTS = new JavaElement[0];
    protected static final Object NO_INFO = new Object();
    private static Set<String> invalidURLs = null;
    private static Set<String> validURLs = null;

    protected JavaElement(JavaElement parent) throws IllegalArgumentException {
        this.parent = parent;
    }

    public void close() throws JavaModelException {
        JavaModelManager.getJavaModelManager().removeInfoAndChildren(this);
    }

    protected abstract void closing(Object var1) throws JavaModelException;

    protected abstract Object createElementInfo();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.parent == null) {
            return super.equals(o);
        }
        JavaElement other = (JavaElement)o;
        return this.getElementName().equals(other.getElementName()) && this.parent.equals(other.parent);
    }

    protected void appendEscapedDelimiter(StringBuffer buffer, char delimiter) {
        buffer.append('=');
        buffer.append(delimiter);
    }

    protected void escapeMementoName(StringBuffer buffer, String mementoName) {
        int i = 0;
        int length = mementoName.length();
        while (i < length) {
            char character = mementoName.charAt(i);
            switch (character) {
                case '!': 
                case '#': 
                case '%': 
                case '\'': 
                case '(': 
                case '/': 
                case '<': 
                case '=': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': 
                case '~': 
                case '\u00a7': {
                    buffer.append('\\');
                }
            }
            buffer.append(character);
            ++i;
        }
    }

    @Override
    public boolean exists() {
        try {
            Object info = this.getElementInfo();
            if (info instanceof SourceTypeElementInfo) {
                return this.equals(((SourceTypeElementInfo)info).getHandle());
            }
            return true;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public ASTNode findNode(CompilationUnit ast) {
        return null;
    }

    protected abstract void generateInfos(Object var1, HashMap var2, IProgressMonitor var3) throws JavaModelException;

    @Override
    public IJavaElement getAncestor(int ancestorType) {
        IJavaElement element = this;
        while (element != null) {
            if (element.getElementType() == ancestorType) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    public IJavaElement[] getChildren() throws JavaModelException {
        Object elementInfo = this.getElementInfo();
        if (elementInfo instanceof JavaElementInfo) {
            return ((JavaElementInfo)elementInfo).getChildren();
        }
        return NO_ELEMENTS;
    }

    public ArrayList getChildrenOfType(int type) throws JavaModelException {
        IJavaElement[] children = this.getChildren();
        int size = children.length;
        ArrayList<JavaElement> list = new ArrayList<JavaElement>(size);
        int i = 0;
        while (i < size) {
            JavaElement elt = (JavaElement)children[i];
            if (elt.getElementType() == type) {
                list.add(elt);
            }
            ++i;
        }
        return list;
    }

    public IClassFile getClassFile() {
        return null;
    }

    public ICompilationUnit getCompilationUnit() {
        return null;
    }

    public Object getElementInfo() throws JavaModelException {
        return this.getElementInfo(null);
    }

    public Object getElementInfo(IProgressMonitor monitor) throws JavaModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        Object info = manager.getInfo(this);
        if (info != null) {
            return info;
        }
        try {
            return this.openWhenClosed(this.createElementInfo(), false, monitor);
        }
        catch (JavaModelException jme) {
            JavaElement rofiType = this.getAsRoFi();
            if (rofiType != null && !rofiType.getCompilationUnit().equals(this.getCompilationUnit())) {
                return rofiType.getElementInfo(monitor);
            }
            throw jme;
        }
    }

    private JavaElement getAsRoFi() throws JavaModelException {
        JavaElement element;
        IOTType otParent;
        if (!(this instanceof IType)) {
            return null;
        }
        if (OTNameUtils.isTSuperMarkerInterface(this.getElementName().toCharArray())) {
            return null;
        }
        JavaElement currentParent = this.parent;
        if (!(currentParent instanceof IType)) {
            return null;
        }
        boolean parentChanged = false;
        Object info = currentParent.getElementInfo();
        if (info instanceof SourceTypeElementInfo) {
            JavaElement newHandle = (JavaElement)((Object)((SourceTypeElementInfo)info).getHandle());
            parentChanged = !currentParent.getCompilationUnit().equals(newHandle.getCompilationUnit());
            currentParent = newHandle;
        }
        if ((otParent = OTModelManager.getOTElement((IType)((Object)currentParent))) == null) {
            return null;
        }
        if (parentChanged && (element = (JavaElement)((Object)otParent.getType(this.getElementName()))).exists()) {
            return element;
        }
        IType roleType = otParent.searchRoleType(this.getElementName());
        if (roleType instanceof JavaElement) {
            return (JavaElement)((Object)roleType);
        }
        return null;
    }

    @Override
    public String getElementName() {
        return "";
    }

    public abstract IJavaElement getHandleFromMemento(String var1, MementoTokenizer var2, WorkingCopyOwner var3);

    public IJavaElement getHandleFromMemento(MementoTokenizer memento, WorkingCopyOwner owner) {
        if (!memento.hasMoreTokens()) {
            return this;
        }
        String token = memento.nextToken();
        return this.getHandleFromMemento(token, memento, owner);
    }

    @Override
    public String getHandleIdentifier() {
        return this.getHandleMemento();
    }

    public String getHandleMemento() {
        StringBuffer buff = new StringBuffer();
        this.getHandleMemento(buff);
        return buff.toString();
    }

    protected void getHandleMemento(StringBuffer buff) {
        ((JavaElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        this.escapeMementoName(buff, this.getElementName());
    }

    protected abstract char getHandleMementoDelimiter();

    @Override
    public IJavaModel getJavaModel() {
        IJavaElement current = this;
        do {
            if (!(current instanceof IJavaModel)) continue;
            return (IJavaModel)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    @Override
    public IJavaProject getJavaProject() {
        IJavaElement current = this;
        do {
            if (!(current instanceof IJavaProject)) continue;
            return (IJavaProject)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    @Override
    public IOpenable getOpenable() {
        return this.getOpenableParent();
    }

    public IOpenable getOpenableParent() {
        return (IOpenable)((Object)this.parent);
    }

    @Override
    public IJavaElement getParent() {
        return this.parent;
    }

    @Override
    public IJavaElement getPrimaryElement() {
        return this.getPrimaryElement(true);
    }

    public IJavaElement getPrimaryElement(boolean checkOwner) {
        return this;
    }

    @Override
    public IResource getResource() {
        return this.resource();
    }

    public abstract IResource resource();

    protected IJavaElement getSourceElementAt(int position) throws JavaModelException {
        if (this instanceof ISourceReference) {
            IJavaElement[] children = this.getChildren();
            int i = children.length - 1;
            while (i >= 0) {
                IJavaElement aChild = children[i];
                if (aChild instanceof SourceRefElement) {
                    SourceRefElement child = (SourceRefElement)children[i];
                    ISourceRange range = child.getSourceRange();
                    int start = range.getOffset();
                    int end = start + range.getLength();
                    if (start <= position && position <= end) {
                        if (child instanceof IField) {
                            int declarationStart = start;
                            SourceRefElement candidate = null;
                            do {
                                if (position > (range = ((IField)((Object)child)).getNameRange()).getOffset() + range.getLength()) {
                                    return candidate == null ? child.getSourceElementAt(position) : candidate.getSourceElementAt(position);
                                }
                                candidate = child;
                                SourceRefElement sourceRefElement = child = --i >= 0 ? (SourceRefElement)children[i] : null;
                            } while (child != null && child.getSourceRange().getOffset() == declarationStart);
                            return candidate.getSourceElementAt(position);
                        }
                        if (child instanceof IParent) {
                            return child.getSourceElementAt(position);
                        }
                        return child;
                    }
                }
                --i;
            }
        } else {
            Assert.isTrue((boolean)false);
        }
        return this;
    }

    public SourceMapper getSourceMapper() {
        return ((JavaElement)this.getParent()).getSourceMapper();
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        IResource resource = this.resource();
        if (resource == null) {
            class NoResourceSchedulingRule
            implements ISchedulingRule {
                public IPath path;

                public NoResourceSchedulingRule(IPath path) {
                    this.path = path;
                }

                public boolean contains(ISchedulingRule rule) {
                    if (rule instanceof NoResourceSchedulingRule) {
                        return this.path.isPrefixOf(((NoResourceSchedulingRule)rule).path);
                    }
                    return false;
                }

                public boolean isConflicting(ISchedulingRule rule) {
                    if (rule instanceof NoResourceSchedulingRule) {
                        IPath otherPath = ((NoResourceSchedulingRule)rule).path;
                        return this.path.isPrefixOf(otherPath) || otherPath.isPrefixOf(this.path);
                    }
                    return false;
                }
            }
            return new NoResourceSchedulingRule(this.getPath());
        }
        return resource;
    }

    public boolean hasChildren() throws JavaModelException {
        Object elementInfo = JavaModelManager.getJavaModelManager().getInfo(this);
        if (elementInfo instanceof JavaElementInfo) {
            return ((JavaElementInfo)elementInfo).getChildren().length > 0;
        }
        return true;
    }

    public int hashCode() {
        if (this.parent == null) {
            return super.hashCode();
        }
        return Util.combineHashCodes(this.getElementName().hashCode(), this.parent.hashCode());
    }

    public boolean isAncestorOf(IJavaElement e) {
        IJavaElement parentElement = e.getParent();
        while (parentElement != null && !parentElement.equals(this)) {
            parentElement = parentElement.getParent();
        }
        return parentElement != null;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public JavaModelException newNotPresentException() {
        return new JavaModelException(this.newDoesNotExistStatus());
    }

    protected JavaModelStatus newDoesNotExistStatus() {
        return new JavaModelStatus(969, this);
    }

    public JavaModelException newJavaModelException(IStatus status) {
        if (status instanceof IJavaModelStatus) {
            return new JavaModelException((IJavaModelStatus)status);
        }
        return new JavaModelException(new JavaModelStatus(status.getSeverity(), status.getCode(), status.getMessage()));
    }

    protected Object openWhenClosed(Object info, boolean forceAdd, IProgressMonitor monitor) throws JavaModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        boolean hadTemporaryCache = manager.hasTemporaryCache();
        try {
            HashMap<IJavaElement, Object> newElements = manager.getTemporaryCache();
            this.generateInfos(info, newElements, monitor);
            if (info == null) {
                info = newElements.get(this);
            }
            if (info == null) {
                Openable openable = (Openable)this.getOpenable();
                if (newElements.containsKey(openable)) {
                    openable.closeBuffer();
                }
                throw this.newNotPresentException();
            }
            if (!hadTemporaryCache) {
                info = manager.putInfos(this, info, forceAdd, newElements);
            }
        }
        finally {
            if (!hadTemporaryCache) {
                manager.resetTemporaryCache();
            }
        }
        return info;
    }

    public String readableName() {
        return this.getElementName();
    }

    public JavaElement resolved(Binding binding) {
        return this;
    }

    public JavaElement unresolved() {
        return this;
    }

    protected String tabString(int tab) {
        StringBuffer buffer = new StringBuffer();
        int i = tab;
        while (i > 0) {
            buffer.append("  ");
            --i;
        }
        return buffer.toString();
    }

    public String toDebugString() {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO, true);
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(0, buffer);
        return buffer.toString();
    }

    protected void toString(int tab, StringBuffer buffer) {
        Object info = this.toStringInfo(tab, buffer);
        if (tab == 0) {
            this.toStringAncestors(buffer);
        }
        this.toStringChildren(tab, buffer, info);
    }

    public String toStringWithAncestors() {
        return this.toStringWithAncestors(true);
    }

    public String toStringWithAncestors(boolean showResolvedInfo) {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO, showResolvedInfo);
        this.toStringAncestors(buffer);
        return buffer.toString();
    }

    protected void toStringAncestors(StringBuffer buffer) {
        JavaElement parentElement = (JavaElement)this.getParent();
        if (parentElement != null && parentElement.getParent() != null) {
            buffer.append(" [in ");
            parentElement.toStringInfo(0, buffer, NO_INFO, false);
            parentElement.toStringAncestors(buffer);
            buffer.append("]");
        }
    }

    protected void toStringChildren(int tab, StringBuffer buffer, Object info) {
        if (info == null || !(info instanceof JavaElementInfo)) {
            return;
        }
        IJavaElement[] children = ((JavaElementInfo)info).getChildren();
        int i = 0;
        while (i < children.length) {
            buffer.append("\n");
            ((JavaElement)children[i]).toString(tab + 1, buffer);
            ++i;
        }
    }

    public Object toStringInfo(int tab, StringBuffer buffer) {
        Object info = JavaModelManager.getJavaModelManager().peekAtInfo(this);
        this.toStringInfo(tab, buffer, info, true);
        return info;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        this.toStringName(buffer);
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    protected void toStringName(StringBuffer buffer) {
        buffer.append(this.getElementName());
    }

    protected URL getJavadocBaseLocation() throws JavaModelException {
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getAncestor(3);
        if (root == null) {
            return null;
        }
        if (root.getKind() == 2) {
            IClasspathEntry entry = null;
            try {
                entry = root.getResolvedClasspathEntry();
                URL url = JavaElement.getLibraryJavadocLocation(entry);
                if (url != null) {
                    return url;
                }
            }
            catch (JavaModelException javaModelException) {}
            entry = root.getRawClasspathEntry();
            switch (entry.getEntryKind()) {
                case 1: 
                case 4: {
                    return JavaElement.getLibraryJavadocLocation(entry);
                }
            }
            return null;
        }
        return null;
    }

    protected static URL getLibraryJavadocLocation(IClasspathEntry entry) throws JavaModelException {
        switch (entry.getEntryKind()) {
            case 1: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Entry must be of kind CPE_LIBRARY or CPE_VARIABLE");
            }
        }
        IClasspathAttribute[] extraAttributes = entry.getExtraAttributes();
        int i = 0;
        while (i < extraAttributes.length) {
            IClasspathAttribute attrib = extraAttributes[i];
            if ("javadoc_location".equals(attrib.getName())) {
                String value = attrib.getValue();
                try {
                    return new URL(value);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new JavaModelException(new JavaModelStatus(1008, value));
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getAttachedJavadoc(IProgressMonitor monitor) throws JavaModelException {
        return null;
    }

    int getIndexOf(byte[] array, byte[] toBeFound, int start, int end) {
        int arrayLength;
        if (array == null || toBeFound == null) {
            return -1;
        }
        int toBeFoundLength = toBeFound.length;
        int n = arrayLength = end != -1 && end < array.length ? end : array.length;
        if (arrayLength < toBeFoundLength) {
            return -1;
        }
        int i = start;
        int max = arrayLength - toBeFoundLength + 1;
        while (i < max) {
            block6: {
                if (this.isSameCharacter(array[i], toBeFound[0])) {
                    int j = 1;
                    while (j < toBeFoundLength) {
                        if (this.isSameCharacter(array[i + j], toBeFound[j])) {
                            ++j;
                            continue;
                        }
                        break block6;
                    }
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    boolean isSameCharacter(byte b1, byte b2) {
        return b1 == b2 || Character.toUpperCase((char)b1) == Character.toUpperCase((char)b2);
    }

    protected void validateAndCache(URL baseLoc, FileNotFoundException e) throws JavaModelException {
        String url = baseLoc.toString();
        if (validURLs != null && validURLs.contains(url)) {
            return;
        }
        if (invalidURLs != null && invalidURLs.contains(url)) {
            throw new JavaModelException(e, 1008);
        }
        InputStream input = null;
        try {
            try {
                URLConnection connection = baseLoc.openConnection();
                input = connection.getInputStream();
                if (validURLs == null) {
                    validURLs = new HashSet<String>(1);
                }
                validURLs.add(url);
            }
            catch (Exception exception) {
                if (invalidURLs == null) {
                    invalidURLs = new HashSet<String>(1);
                }
                invalidURLs.add(url);
                throw new JavaModelException(e, 1008);
            }
        }
        catch (Throwable throwable) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Exception decompiling
     */
    protected String getURLContents(URL baseLoc, String docUrlValue) throws JavaModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [39[CATCHBLOCK]], but top level block is 13[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

