/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_CreateAnEmptyGitRepository")
class Init
extends TextBuiltin {
    @Option(name="--bare", usage="usage_CreateABareRepository")
    private boolean bare;
    @Argument(index=0, metaVar="metaVar_directory")
    private String directory;

    Init() {
    }

    @Override
    protected final boolean requiresRepository() {
        return false;
    }

    @Override
    protected void run() throws Exception {
        InitCommand command = Git.init();
        command.setBare(this.bare);
        if (this.gitdir != null) {
            command.setDirectory(new File(this.gitdir));
        }
        if (this.directory != null) {
            command.setDirectory(new File(this.directory));
        }
        Repository repository = command.call().getRepository();
        this.outw.println(MessageFormat.format(CLIText.get().initializedEmptyGitRepositoryIn, repository.getDirectory().getAbsolutePath()));
    }
}

