/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester.util.compatibility;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComboBoxUtils {
    private static final String JAVA8_COMBO_BASESKIN = "com.sun.javafx.scene.control.skin.ComboBoxBaseSkin";
    private static final String JAVA9_COMBO_BASESKIN = "javafx.scene.control.skin.ComboBoxBaseSkin";
    private static final String JAVA8_COMBO_LISTVIEWSKIN = "com.sun.javafx.scene.control.skin.ComboBoxListViewSkin";
    private static final String JAVA9_COMBO_LISTVIEWSKIN = "javafx.scene.control.skin.ComboBoxListViewSkin";
    private static final String ARROW_BUTTON_FIELD_NAME = "arrowButton";
    private static final String GET_POPUP_CONTENT = "getPopupContent";
    private static Logger log = LoggerFactory.getLogger(ComboBoxUtils.class);

    private ComboBoxUtils() {
    }

    public static ListView<?> getPopUpContent(ComboBox<?> combobox) {
        Class<?> clazz = null;
        Skin skin = combobox.getSkin();
        try {
            clazz = Class.forName(JAVA8_COMBO_LISTVIEWSKIN);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName(JAVA9_COMBO_LISTVIEWSKIN);
            }
            catch (ClassNotFoundException e2) {
                throw new RuntimeException(e2);
            }
        }
        try {
            Method method = clazz.getMethod(GET_POPUP_CONTENT, new Class[0]);
            Object o = method.invoke((Object)skin, new Object[0]);
            if (o instanceof ListView) {
                return (ListView)o;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static Node getArrowButton(ComboBox<?> combobox) {
        Skin skin = combobox.getSkin();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(JAVA8_COMBO_BASESKIN);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName(JAVA9_COMBO_BASESKIN);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                log.warn("ComboBox base skins not found");
                return combobox;
            }
        }
        try {
            Field declaredField = clazz.getDeclaredField(ARROW_BUTTON_FIELD_NAME);
            declaredField.setAccessible(true);
            return (Node)declaredField.get(skin);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            return combobox;
        }
    }
}

