/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.io.File;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class LoggingStreamConnectionProviderProxy
implements StreamConnectionProvider {
    public static final String LOG_DIRECTORY = "languageServers-log";
    private static final String FILE_KEY = "file.logging.disabled";
    private static final String STDERR_KEY = "stderr.logging.enabled";
    private StreamConnectionProvider provider;
    private InputStream inputStream;
    private OutputStream outputStream;
    private InputStream errorStream;
    private String id;
    private File currentFile;
    private File folder;
    private boolean logToFile;
    private boolean logToConsole;
    private MessageConsoleStream consoleStream;

    public static String lsToFileLoggingId(String serverId) {
        return String.valueOf(serverId) + "." + FILE_KEY;
    }

    public static String lsToConsoleLoggingId(String serverId) {
        return String.valueOf(serverId) + "." + STDERR_KEY;
    }

    public static boolean shouldLog(String serverId) {
        IPreferenceStore store = LanguageServerPlugin.getDefault().getPreferenceStore();
        return !store.getBoolean(LoggingStreamConnectionProviderProxy.lsToFileLoggingId(serverId)) || store.getBoolean(LoggingStreamConnectionProviderProxy.lsToConsoleLoggingId(serverId));
    }

    public LoggingStreamConnectionProviderProxy(StreamConnectionProvider provider, String serverId) {
        this.id = serverId;
        this.provider = provider;
        IPreferenceStore store = LanguageServerPlugin.getDefault().getPreferenceStore();
        this.logToFile = !store.getBoolean(LoggingStreamConnectionProviderProxy.lsToFileLoggingId(serverId));
        this.logToConsole = store.getBoolean(LoggingStreamConnectionProviderProxy.lsToConsoleLoggingId(serverId));
        store.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals(LoggingStreamConnectionProviderProxy.FILE_KEY)) {
                    LoggingStreamConnectionProviderProxy.this.logToFile = (Boolean)event.getNewValue();
                } else if (event.getProperty().equals(LoggingStreamConnectionProviderProxy.STDERR_KEY)) {
                    LoggingStreamConnectionProviderProxy.this.logToConsole = (Boolean)event.getNewValue();
                }
            }
        });
    }

    @Override
    public InputStream getInputStream() {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (this.provider.getInputStream() != null) {
            this.inputStream = new FilterInputStream(this.provider.getInputStream()){

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    int bytes = super.read(b, off, len);
                    byte[] payload = new byte[bytes];
                    System.arraycopy(b, off, payload, 0, bytes);
                    if (LoggingStreamConnectionProviderProxy.this.logToConsole) {
                        LoggingStreamConnectionProviderProxy.this.logToConsole(String.valueOf(LoggingStreamConnectionProviderProxy.this.id) + " to LSP4E:" + new String(payload));
                    }
                    if (LoggingStreamConnectionProviderProxy.this.logToFile) {
                        LoggingStreamConnectionProviderProxy.this.logToFile("\n" + LoggingStreamConnectionProviderProxy.this.id + " to LSP4E:" + new String(payload));
                    }
                    return bytes;
                }
            };
        }
        return this.inputStream;
    }

    @Override
    public InputStream getErrorStream() {
        if (this.errorStream != null) {
            return this.errorStream;
        }
        if (this.provider.getErrorStream() != null) {
            this.errorStream = new FilterInputStream(this.provider.getErrorStream()){

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    int bytes = super.read(b, off, len);
                    byte[] payload = new byte[bytes];
                    System.arraycopy(b, off, payload, 0, bytes);
                    if (LoggingStreamConnectionProviderProxy.this.logToConsole) {
                        LoggingStreamConnectionProviderProxy.this.logToConsole("Error from " + LoggingStreamConnectionProviderProxy.this.id + ":" + new String(payload));
                    }
                    if (LoggingStreamConnectionProviderProxy.this.logToFile) {
                        LoggingStreamConnectionProviderProxy.this.logToFile(new String("\nError from:" + LoggingStreamConnectionProviderProxy.this.id + ":" + payload));
                    }
                    return bytes;
                }
            };
        }
        return this.errorStream;
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.outputStream != null) {
            return this.outputStream;
        }
        if (this.provider.getOutputStream() != null) {
            this.outputStream = new FilterOutputStream(this.provider.getOutputStream()){

                @Override
                public void write(byte[] b) throws IOException {
                    if (LoggingStreamConnectionProviderProxy.this.logToConsole) {
                        LoggingStreamConnectionProviderProxy.this.logToConsole("LSP4E to " + LoggingStreamConnectionProviderProxy.this.id + ":" + new String(b));
                    }
                    if (LoggingStreamConnectionProviderProxy.this.logToFile) {
                        LoggingStreamConnectionProviderProxy.this.logToFile("\nLSP4E to " + LoggingStreamConnectionProviderProxy.this.id + ":" + new String(b));
                    }
                    super.write(b);
                }
            };
        }
        return this.outputStream;
    }

    @Override
    public void start() throws IOException {
        this.provider.start();
    }

    @Override
    public InputStream forwardCopyTo(InputStream input, OutputStream output) {
        return this.provider.forwardCopyTo(input, output);
    }

    @Override
    public Object getInitializationOptions(URI rootUri) {
        return this.provider.getInitializationOptions(rootUri);
    }

    @Override
    public String getTrace(URI rootUri) {
        return this.provider.getTrace(rootUri);
    }

    @Override
    public void handleMessage(Message message, LanguageServer languageServer, URI rootURI) {
        this.provider.handleMessage(message, languageServer, rootURI);
    }

    @Override
    public void stop() {
        this.provider.stop();
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
            if (this.errorStream != null) {
                this.errorStream.close();
                this.errorStream = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void logToConsole(String string) {
        if (this.consoleStream == null || this.consoleStream.isClosed()) {
            this.consoleStream = this.findConsole().newMessageStream();
        }
        this.consoleStream.println(string);
    }

    private MessageConsole findConsole() {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if ("org.eclipse.lsp4e".equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole("org.eclipse.lsp4e", null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    private void logToFile(String string) {
        if (!(this.currentFile != null && this.currentFile.exists() && this.currentFile.isFile() && this.currentFile.canWrite())) {
            this.generateNewLogFile();
            if (this.currentFile == null) {
                return;
            }
        }
        try {
            Files.write(this.currentFile.toPath(), string.getBytes(), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void generateNewLogFile() {
        File folder = this.getFolder();
        if (folder == null) {
            return;
        }
        this.currentFile = new File(folder, String.valueOf(this.id) + ".log");
        try {
            this.currentFile.createNewFile();
        }
        catch (IOException e) {
            this.currentFile = null;
            e.printStackTrace();
        }
    }

    private File getFolder() {
        if (this.folder != null && this.folder.exists() && this.folder.isDirectory() && this.folder.canWrite()) {
            return this.folder;
        }
        IPath root = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (root == null) {
            return null;
        }
        File folder = new File(String.valueOf(root.addTrailingSeparator().toPortableString()) + LOG_DIRECTORY);
        if (folder != null && (folder.exists() || folder.mkdirs()) && folder.isDirectory() && folder.canWrite()) {
            return folder;
        }
        return null;
    }
}

