/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codeactions;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPCodeActionsMenu
extends ContributionItem
implements IWorkbenchContribution {
    private List<LanguageServiceAccessor.LSPDocumentInfo> infos;
    private Range range;

    public void initialize(IServiceLocator serviceLocator) {
        ITextEditor editor = LSPEclipseUtils.getActiveTextEditor();
        if (editor != null) {
            ITextEditor textEditor = editor;
            IDocument document = LSPEclipseUtils.getDocument(textEditor);
            if (document == null) {
                return;
            }
            this.infos = LanguageServiceAccessor.getLSPDocumentInfosFor(document, capabilities -> Boolean.TRUE.equals(capabilities.getCodeActionProvider()));
            ITextSelection selection = (ITextSelection)textEditor.getSelectionProvider().getSelection();
            try {
                this.range = new Range(LSPEclipseUtils.toPosition(selection.getOffset(), document), LSPEclipseUtils.toPosition(selection.getOffset() + selection.getLength(), document));
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
    }

    public void fill(Menu menu, int index) {
        MenuItem item = new MenuItem(menu, 0, index);
        item.setEnabled(false);
        if (this.infos.isEmpty()) {
            item.setText(Messages.notImplemented);
            return;
        }
        item.setText(Messages.computing);
        CodeActionContext context = new CodeActionContext(Collections.emptyList());
        CodeActionParams params = new CodeActionParams();
        params.setTextDocument(new TextDocumentIdentifier(this.infos.get(0).getFileUri().toString()));
        params.setRange(this.range);
        params.setContext(context);
        final HashSet<CompletionStage> runningFutures = new HashSet<CompletionStage>();
        for (LanguageServiceAccessor.LSPDocumentInfo info : this.infos) {
            CompletionStage codeActions = info.getInitializedLanguageClient().thenCompose(languageServer -> languageServer.getTextDocumentService().codeAction(params));
            runningFutures.add(codeActions);
            ((CompletableFuture)codeActions).whenComplete(new BiConsumer<List<? extends Command>, Throwable>((CompletableFuture)codeActions, menu, index, item){
                private final /* synthetic */ CompletableFuture val$codeActions;
                private final /* synthetic */ Menu val$menu;
                private final /* synthetic */ int val$index;
                private final /* synthetic */ MenuItem val$item;
                {
                    this.val$codeActions = completableFuture;
                    this.val$menu = menu;
                    this.val$index = n;
                    this.val$item = menuItem;
                }

                @Override
                public void accept(final List<? extends Command> t, final Throwable u) {
                    runningFutures.remove(this.val$codeActions);
                    UIJob job = new UIJob(this.val$menu.getDisplay(), Messages.updateCodeActions_menu){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (u != null) {
                                MenuItem item = new MenuItem(val$menu, 0, val$index);
                                item.setText(u.getMessage());
                                item.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR"));
                                item.setEnabled(false);
                            } else if (t != null) {
                                for (Command command : t) {
                                    if (command == null) continue;
                                    MenuItem item = new MenuItem(val$menu, 0, val$index);
                                    item.setText(command.getTitle());
                                    item.setEnabled(false);
                                }
                            }
                            if (val$menu.getItemCount() == 1) {
                                val$item.setText(Messages.codeActions_emptyMenu);
                            } else {
                                val$item.dispose();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            });
        }
        super.fill(menu, index);
    }
}

