/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.ui.model;

import com.google.inject.Inject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ocl.xtext.base.ui.commands.ToggleNatureCommand;
import org.eclipse.xtext.ui.editor.IXtextEditorCallback;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.util.DontAskAgainDialogs;

public class BaseEditorCallback
extends IXtextEditorCallback.NullImpl {
    @Inject
    private ToggleNatureCommand toggleNature;
    @Inject
    private DontAskAgainDialogs dialogs;
    @Inject
    private IDialogSettings dialogSettings;

    public void afterCreatePartControl(XtextEditor editor) {
        IProject project;
        super.afterCreatePartControl(editor);
        IResource resource = editor.getResource();
        if (resource != null && (project = resource.getProject()) != null && !this.toggleNature.hasNature(project) && project.isAccessible() && !project.isHidden()) {
            boolean addNature = false;
            String addNatureKey = this.toggleNature.getAddNatureKey();
            if ("prompt".equals(this.dialogs.getUserDecision(addNatureKey))) {
                String testNameSuffix = System.getProperty("testNameSuffix", null);
                if (testNameSuffix != null) {
                    throw new UnsupportedOperationException("Asking for a nature is not supported by testing");
                }
                String title = this.toggleNature.getAddNatureDialogTitle();
                String message = this.toggleNature.getAddNatureDialogText(project.getName());
                int userAnswer = this.dialogs.askUser(message, title, addNatureKey, editor.getEditorSite().getShell());
                if (userAnswer == 2) {
                    addNature = true;
                } else if (userAnswer == 1) {
                    return;
                }
            } else if ("always".equals(this.dialogs.getUserDecision(addNatureKey))) {
                addNature = true;
            }
            if (addNature) {
                this.toggleNature.toggleNature(project);
            }
        }
    }

    public void setDontAskForNatureAgain() {
        IDialogSettings section = this.dialogSettings.getSection("dont_ask_again_dialog");
        if (section == null) {
            section = this.dialogSettings.addNewSection("dont_ask_again_dialog");
        }
        section.put(this.toggleNature.getAddNatureKey(), "never");
    }
}

