/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.internal.modelelements;

import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.papyrus.infra.core.language.ILanguage;
import org.eclipse.papyrus.infra.core.language.ILanguageChangeListener;
import org.eclipse.papyrus.infra.core.language.ILanguageService;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.editor.welcome.internal.Activator;
import org.eclipse.papyrus.infra.editor.welcome.internal.modelelements.LanguageObservable;
import org.eclipse.papyrus.infra.editor.welcome.internal.modelelements.WelcomeModelElement;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.tools.databinding.WritableListWithIterator;

public class LanguagesObservableProperty
implements Supplier<IObservableList<LanguageObservable>> {
    private ILanguageService languageService;
    private ILanguageChangeListener languagesListener;
    private IObservableList<LanguageObservable> list = new WritableListWithIterator.Containment(LanguageObservable.class);

    public LanguagesObservableProperty(WelcomeModelElement owner) {
        try {
            this.languageService = (ILanguageService)ServiceUtilsForResourceSet.getInstance().getService(ILanguageService.class, (Object)owner.getDomain().getResourceSet());
            this.hookLanguagesListener();
            this.list.addDisposeListener(event -> {
                this.languageService.removeLanguageChangeListener(this.languagesListener);
                this.languagesListener = null;
                this.languageService = null;
            });
        }
        catch (ServiceException e) {
            Activator.log.error("Cannot obtain language service. Languages will not be shown.", (Throwable)e);
        }
    }

    @Override
    public IObservableList<LanguageObservable> get() {
        return this.list;
    }

    void hookLanguagesListener() {
        this.languagesListener = event -> {
            switch (event.getType()) {
                case 1: {
                    this.list.addAll((Collection)event.getLanguages().stream().map(LanguageObservable::new).collect(Collectors.toList()));
                    break;
                }
                case 2: {
                    this.list.removeAll(this.getObservables(event.getLanguages()));
                }
            }
        };
        ModelSet modelSet = (ModelSet)this.languageService.getAdapter(ModelSet.class);
        this.list.addAll((Collection)this.languageService.getLanguages(modelSet.getURIWithoutExtension(), false).stream().map(LanguageObservable::new).collect(Collectors.toList()));
        this.languageService.addLanguageChangeListener(this.languagesListener);
    }

    Collection<LanguageObservable> getObservables(Collection<? extends ILanguage> languages) {
        return this.list.stream().filter(o -> languages.contains(o.getLanguage())).collect(Collectors.toList());
    }
}

