/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors.richtext;

import java.util.Iterator;
import java.util.List;

public class RichTextUtils {
    public static final String ITEM_SOURCE = "Source";
    public static final String ITEM_SAVE = "Save";
    public static final String ITEM_NEWPAGE = "NewPage";
    public static final String ITEM_DOCPROPS = "DocProps";
    public static final String ITEM_PREVIEW = "Preview";
    public static final String ITEM_PRINT = "Print";
    public static final String ITEM_TEMPLATES = "Templates";
    public static final String ITEM_DOCUMENT = "document";
    public static final String ITEM_CUT = "Cut";
    public static final String ITEM_COPY = "Copy";
    public static final String ITEM_PASTE = "Paste";
    public static final String ITEM_PASTETEXT = "PasteText";
    public static final String ITEM_PASTEFROMWORD = "PasteFromWord";
    public static final String ITEM_UNDO = "Undo";
    public static final String ITEM_REDO = "Redo";
    public static final String ITEM_FIND = "Find";
    public static final String ITEM_REPLACE = "Replace";
    public static final String ITEM_SELECTALL = "SelectAll";
    public static final String ITEM_SCAYT = "Scayt";
    public static final String ITEM_FORM = "Form";
    public static final String ITEM_CHECKBOX = "Checkbox";
    public static final String ITEM_RADIO = "Radio";
    public static final String ITEM_TEXTFIELD = "TextField";
    public static final String ITEM_TEXTAREA = "Textarea";
    public static final String ITEM_SELECT = "Select";
    public static final String ITEM_BUTTON = "Button";
    public static final String ITEM_IMAGEBUTTON = "ImageButton";
    public static final String ITEM_HIDDENFIELD = "HiddenField";
    public static final String ITEM_BOLD = "Bold";
    public static final String ITEM_ITALIC = "Italic";
    public static final String ITEM_UNDERLINE = "Underline";
    public static final String ITEM_STRIKE = "Strike";
    public static final String ITEM_SUBSCRIPT = "Subscript";
    public static final String ITEM_SUPERSCRIPT = "Superscript";
    public static final String ITEM_REMOVEFORMAT = "RemoveFormat";
    public static final String ITEM_NUMBEREDLIST = "NumberedList";
    public static final String ITEM_BULLETEDLIST = "BulletedList";
    public static final String ITEM_OUTDENT = "Outdent";
    public static final String ITEM_INDENT = "Indent";
    public static final String ITEM_BLOCKQUOTE = "Blockquote";
    public static final String ITEM_CREATEDIV = "CreateDiv";
    public static final String ITEM_JUSTIFYLEFT = "JustifyLeft";
    public static final String ITEM_JUSTIFYCENTER = "JustifyCenter";
    public static final String ITEM_JUSTIFYRIGHT = "JustifyRight";
    public static final String ITEM_JUSTIFYBLOCK = "JustifyBlock";
    public static final String ITEM_BIDILTR = "BidiLtr";
    public static final String ITEM_BIDIRTL = "BidiRtl";
    public static final String ITEM_LINK = "Link";
    public static final String ITEM_UNLINK = "Unlink";
    public static final String ITEM_ANCHOR = "Anchor";
    public static final String ITEM_CREATEPLACEHOLDER = "CreatePlaceholder";
    public static final String ITEM_IMAGE = "Image";
    public static final String ITEM_FLASH = "Flash";
    public static final String ITEM_TABLE = "Table";
    public static final String ITEM_HORIZONTALRULE = "HorizontalRule";
    public static final String ITEM_SMILEY = "Smiley";
    public static final String ITEM_SPECIALCHAR = "SpecialChar";
    public static final String ITEM_PAGEBREAK = "PageBreak";
    public static final String ITEM_IFRAME = "Iframe";
    public static final String ITEM_INSERTPRE = "InsertPre";
    public static final String ITEM_STYLES = "Styles";
    public static final String ITEM_FORMAT = "Format";
    public static final String ITEM_FONT = "Font";
    public static final String ITEM_FONTSIZE = "FontSize";
    public static final String ITEM_TEXTCOLOR = "TextColor";
    public static final String ITEM_BGCOLOR = "BGColor";
    public static final String ITEM_UICOLOR = "UIColor";
    public static final String ITEM_MAXIMIZE = "Maximize";
    public static final String ITEM_SHOWBLOCKS = "ShowBlocks";
    public static final String ITEM_BUTTON1 = "button1";
    public static final String ITEM_BUTTON2 = "button2";
    public static final String ITEM_BUTTON3 = "button3";
    public static final String ITEM_OEMBED = "oembed";
    public static final String ITEM_MEDIAEMBED = "MediaEmbed";
    public static final String ITEM_ABOUT = "About";
    public static final String TOOLBAR_GROUP_FIND = "find";
    public static final String TOOLBAR_GROUP_SOURCE = "source";
    public static final String TOOLBAR_GROUP_CLIPBOARD = "clipboard";
    public static final String TOOLBAR_GROUP_OTHER = "other";
    public static final String TOOLBAR_GROUP_PARAGRAPH = "paragraph";
    public static final String TOOLBAR_GROUP_COLORS = "colors";
    public static final String TOOLBAR_GROUP_LINKS = "links";
    public static final String TOOLBAR_GROUP_INSERT = "insert";
    public static final String TOOLBAR_GROUP_STYLES = "styles";
    public static final String TOOLBAR_GROUP_BASICSTYLES = "basicstyles";
    public static final String ITEM_MODE = "mode";
    public static final String ITEM_BASICSTYLES = "basicstyles";
    public static final String ITEM_CLEANUP = "cleanup";
    public static final String ITEM_LIST = "list";
    public static final String ITEM_ALIGN = "align";
    public static final String ITEM_CLIPBOARD = "clipboard";
    public static final String GROUPS = "groups";
    public static final String SPACE = " ";
    public static final String COLON = ":";
    public static final String SINGLE_QUOTE = "'";
    public static final String COMMA = ",";
    public static final String OPENING_BRACKET = "[";
    public static final String CLOSING_BRACKET = "]";
    public static final String OPENING_BRACE = "{";
    public static final String CLOSING__BRACE = "}";
    public static final String NAME = "name";
    public static final String SEPARATOR = "-";
    public static final String NEW_LINE = "'/'";
    public static final String SEMICOLON = ";";

    private RichTextUtils() {
    }

    public static final String createGroups(String groupName, List<String> items) {
        StringBuilder builder = new StringBuilder();
        if (groupName != null && !groupName.isEmpty()) {
            builder.append(OPENING_BRACE);
            builder.append(SPACE);
            builder.append(NAME);
            builder.append(COLON);
            builder.append(SPACE);
            builder.append(SINGLE_QUOTE);
            builder.append(groupName);
            builder.append(SINGLE_QUOTE);
        }
        if (items != null && items.size() > 0) {
            builder.append(COMMA);
            builder.append(SPACE);
            builder.append(GROUPS);
            builder.append(COLON);
            builder.append(SPACE);
            builder.append(OPENING_BRACKET);
            Iterator<String> iter = items.iterator();
            while (iter.hasNext()) {
                String current = iter.next();
                builder.append(SPACE);
                builder.append(SINGLE_QUOTE);
                builder.append(current);
                builder.append(SINGLE_QUOTE);
                if (!iter.hasNext()) continue;
                builder.append(COMMA);
            }
            builder.append(SPACE);
            builder.append(CLOSING_BRACKET);
        }
        builder.append(SPACE);
        builder.append(CLOSING__BRACE);
        return builder.toString();
    }
}

