/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.uml.service.types.helper.advice.InteractionContainerDeletionContext;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.InteractionFragment;

public class InteractionFragmentContainerEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeDestroyElementCommand(DestroyElementRequest req) {
        ICommand superResult = super.getBeforeDestroyElementCommand(req);
        InteractionContainerDeletionContext.deleting(req);
        EObject elementToDestroy = req.getElementToDestroy();
        Optional<ICommand> result = Optional.empty();
        if (elementToDestroy instanceof InteractionFragment) {
            InteractionFragment fragment = (InteractionFragment)elementToDestroy;
            Optional<InteractionContainerDeletionContext> context = InteractionContainerDeletionContext.get(req);
            result = context.map(ctx -> ctx.getDestroyCommand(fragment));
        } else if (elementToDestroy instanceof GeneralOrdering) {
            GeneralOrdering generalOrdering = (GeneralOrdering)elementToDestroy;
            Optional<InteractionContainerDeletionContext> context = InteractionContainerDeletionContext.get(req);
            result = context.map(ctx -> ctx.getDestroyCommand(generalOrdering));
        }
        result.ifPresent(advice -> {
            ICommand iCommand = this.instead((IEditCommandRequest)req, (ICommand)advice);
        });
        return result.map(advice -> CompositeCommand.compose((ICommand)superResult, (ICommand)advice)).orElse(superResult);
    }

    ICommand instead(IEditCommandRequest request, ICommand instead) {
        request.setParameter("IEditCommandRequest.replaceDefaultCommand", (Object)Boolean.TRUE);
        return instead;
    }

    protected ICommand getAfterDestroyElementCommand(DestroyElementRequest request) {
        request.getParameters().remove("IEditCommandRequest.replaceDefaultCommand");
        return super.getAfterDestroyElementCommand(request);
    }
}

