/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.merger;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.EdgeMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.NodeMerger;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

abstract class RegionMerger {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull MappingRegion primaryRegion;
    protected final @NonNull List<@NonNull MappingRegion> secondaryRegions = new ArrayList<MappingRegion>();
    protected final @NonNull Map<@NonNull Node, @NonNull Node> secondaryNode2primaryNode = new HashMap<Node, Node>();
    protected final @NonNull Map<@NonNull Node, @NonNull NodeMerger> oldNode2nodeMerger = new HashMap<Node, NodeMerger>();
    private final @NonNull Map<@NonNull Edge, @NonNull EdgeMerger> oldEdge2edgeMerger = new HashMap<Edge, EdgeMerger>();
    private Set<@NonNull Edge> debugPrunedEdges = null;

    protected RegionMerger(@NonNull ScheduleManager scheduleManager, @NonNull MappingRegion primaryRegion) {
        this.scheduleManager = scheduleManager;
        this.primaryRegion = primaryRegion;
        for (Node primaryNode : QVTscheduleUtil.getOwnedNodes((Region)primaryRegion)) {
            new NodeMerger(this, primaryNode);
        }
        for (Edge primaryEdge : QVTscheduleUtil.getOwnedEdges((Region)primaryRegion)) {
            if (primaryEdge.isSecondary()) continue;
            new EdgeMerger(this, primaryEdge);
        }
    }

    private void addPrunedEdge(@NonNull Edge prunedEdge) {
        Set<@NonNull Edge> debugPrunedEdges2 = this.debugPrunedEdges;
        if (debugPrunedEdges2 == null) {
            debugPrunedEdges2 = this.debugPrunedEdges = new HashSet<Edge>();
        }
        boolean wasAdded = debugPrunedEdges2.add(prunedEdge);
        assert (wasAdded);
    }

    protected void addSecondaryEdge(@NonNull Edge secondaryEdge) {
        NodeMerger targetNodeMerger;
        NodeMerger sourceNodeMerger = this.getNodeMerger(secondaryEdge.getEdgeSource());
        if (sourceNodeMerger != (targetNodeMerger = this.getNodeMerger(secondaryEdge.getEdgeTarget()))) {
            boolean isMerged = false;
            for (EdgeMerger edgeMerger : sourceNodeMerger.getOutgoingEdgeMergers(targetNodeMerger)) {
                if (edgeMerger.sameEdge(secondaryEdge) == null) continue;
                edgeMerger.addOldEdge(secondaryEdge);
                isMerged = true;
                break;
            }
            if (!isMerged) {
                new EdgeMerger(this, secondaryEdge);
            }
        } else {
            this.addPrunedEdge(secondaryEdge);
        }
    }

    public void addSecondaryRegion(@NonNull MappingRegion secondaryRegion, @NonNull Map<@NonNull Node, @NonNull Node> secondaryNode2primaryNode) {
        assert (!this.secondaryRegions.contains(secondaryRegion));
        this.secondaryRegions.add(secondaryRegion);
        this.secondaryNode2primaryNode.putAll(secondaryNode2primaryNode);
        for (Node secondaryNode : QVTscheduleUtil.getOwnedNodes((Region)secondaryRegion)) {
            Node primaryNode = secondaryNode2primaryNode.get(secondaryNode);
            if (primaryNode != null) {
                NodeMerger nodeMerger = this.oldNode2nodeMerger.get(primaryNode);
                assert (nodeMerger != null);
                nodeMerger.addOldNode(secondaryNode);
                continue;
            }
            new NodeMerger(this, secondaryNode);
        }
        for (Edge secondaryEdge : QVTscheduleUtil.getOwnedEdges((Region)secondaryRegion)) {
            if (secondaryEdge.isSecondary()) continue;
            this.addSecondaryEdge(secondaryEdge);
        }
    }

    public void check(@NonNull MappingRegion newRegion) {
        this.checkNodes(newRegion, (Region)this.primaryRegion);
        for (Region region : this.secondaryRegions) {
            this.checkNodes(newRegion, region);
        }
        this.checkEdges(newRegion, (Region)this.primaryRegion);
        for (Region region : this.secondaryRegions) {
            this.checkEdges(newRegion, region);
        }
    }

    protected void checkEdges(@NonNull MappingRegion newRegion, @NonNull Region oldRegion) {
        for (Edge oldEdge : QVTscheduleUtil.getOwnedEdges((Region)oldRegion)) {
            assert (oldEdge.getOwningRegion() == oldRegion);
            if (oldEdge.isRecursion() || oldEdge.isSecondary()) continue;
            EdgeMerger edgeMerger = this.oldEdge2edgeMerger.get(oldEdge);
            if (edgeMerger != null) {
                assert (Iterables.contains(edgeMerger.getOldEdges(), (Object)oldEdge));
                assert (edgeMerger.getNewEdge().getOwningRegion() == newRegion);
                continue;
            }
            assert (this.debugPrunedEdges.contains(oldEdge));
        }
    }

    protected void checkNodes(@NonNull MappingRegion newRegion, @NonNull Region oldRegion) {
        for (Node oldNode : QVTscheduleUtil.getOwnedNodes((Region)oldRegion)) {
            assert (oldNode.getOwningRegion() == oldRegion);
            Node nodeMerger = this.getNodeMerger(oldNode).getNewNode();
            assert (nodeMerger.getOwningRegion() == newRegion);
        }
    }

    public @NonNull MappingRegion create() {
        @NonNull String newName = this.createNewName();
        MappingRegion newRegion = this.createNewRegion(newName);
        this.createNewNodes(newRegion);
        this.createNewEdges();
        return newRegion;
    }

    protected @NonNull String createNewName() {
        ArrayList<@NonNull String> names = new ArrayList<String>();
        names.add(this.primaryRegion.getName().replace("\u00bb\\n", "\u00bb "));
        for (MappingRegion secondaryRegion : this.secondaryRegions) {
            names.add(secondaryRegion.getName().replace("\u00bb\\n", "\u00bb "));
        }
        Collections.sort(names);
        StringBuilder s = new StringBuilder();
        for (String name : names) {
            if (s.length() > 0) {
                s.append("\\n");
            }
            s.append(name);
        }
        return s.toString();
    }

    protected void createNewEdges() {
        for (EdgeMerger edgeMerger : new HashSet<EdgeMerger>(this.oldEdge2edgeMerger.values())) {
            Node sourceNodeMerger = this.getNodeMerger(edgeMerger.getOldSource()).getNewNode();
            Node targetNodeMerger = this.getNodeMerger(edgeMerger.getOldTarget()).getNewNode();
            edgeMerger.createNewEdge(sourceNodeMerger, targetNodeMerger);
        }
    }

    protected void createNewNodes(@NonNull MappingRegion newRegion) {
        for (NodeMerger nodeMerger : new HashSet<NodeMerger>(this.oldNode2nodeMerger.values())) {
            nodeMerger.createNewNode(newRegion);
        }
    }

    protected abstract @NonNull MappingRegion createNewRegion(@NonNull String var1);

    protected @NonNull EdgeMerger getEdgeMerger(@NonNull Edge oldEdge) {
        return (EdgeMerger)ClassUtil.nonNullState((Object)this.oldEdge2edgeMerger.get(oldEdge));
    }

    protected @NonNull NodeMerger getNodeMerger(@NonNull Node oldNode) {
        return (NodeMerger)ClassUtil.nonNullState((Object)this.oldNode2nodeMerger.get(oldNode));
    }

    protected @NonNull List<@NonNull MappingRegion> getSecondaryRegions() {
        return this.secondaryRegions;
    }

    protected void mapOldEdge(@NonNull Edge oldEdge, @NonNull EdgeMerger edgeMerger) {
        EdgeMerger oldMergedEdge = this.oldEdge2edgeMerger.put(oldEdge, edgeMerger);
        assert (oldMergedEdge == null);
    }

    protected void mapOldNode(@NonNull Node oldNode, @NonNull NodeMerger nodeMerger) {
        NodeMerger oldMergedNode = this.oldNode2nodeMerger.put(oldNode, nodeMerger);
        assert (oldMergedNode == null);
    }

    public void prune() {
        ArrayList<@NonNull EdgeMerger> foldableEdgeMergers = new ArrayList<EdgeMerger>();
        for (NodeMerger nodeMerger : new HashSet<NodeMerger>(this.oldNode2nodeMerger.values())) {
            nodeMerger.gatherFoldableEdges(foldableEdgeMergers);
        }
        for (EdgeMerger foldableEdgeMerger : foldableEdgeMergers) {
            NodeMerger sourceNodeMerger = foldableEdgeMerger.getSource();
            NodeMerger targetNodeMerger = foldableEdgeMerger.getTarget();
            sourceNodeMerger.destroy();
            for (Node oldNode : sourceNodeMerger.getOldNodes()) {
                targetNodeMerger.addOldNode(oldNode);
                for (Edge oldEdge : QVTscheduleUtil.getIncomingEdges((Node)oldNode)) {
                    this.addSecondaryEdge(oldEdge);
                }
                for (Edge oldEdge : QVTscheduleUtil.getOutgoingEdges((Node)oldNode)) {
                    this.addSecondaryEdge(oldEdge);
                }
            }
        }
    }

    public String toString() {
        return this.createNewName();
    }

    protected void unmapOldEdge(@NonNull Edge oldEdge, @NonNull EdgeMerger edgeMerger) {
        EdgeMerger oldEdgeMerger = this.oldEdge2edgeMerger.remove(oldEdge);
        assert (oldEdgeMerger == edgeMerger);
    }

    protected void unmapOldNode(@NonNull Node oldNode, @NonNull NodeMerger nodeMerger) {
        NodeMerger oldNodeMerger = this.oldNode2nodeMerger.remove(oldNode);
        assert (oldNodeMerger == nodeMerger);
    }
}

