/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.acceleo.mtl.business.internal.interpreter;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.acceleo.common.internal.utils.AcceleoPackageRegistry;
import org.eclipse.acceleo.common.interpreter.CompilationResult;
import org.eclipse.acceleo.common.interpreter.EvaluationResult;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.service.AcceleoEvaluationTask;
import org.eclipse.acceleo.engine.service.EvaluationContext;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.parser.interpreter.AcceleoCompilationTask;
import org.eclipse.acceleo.parser.interpreter.CompilationContext;
import org.eclipse.acceleo.parser.interpreter.ModuleDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ocl.ecore.BooleanLiteralExp;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.PropertyCallExp;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.Bag;
import org.eclipse.sirius.common.acceleo.mtl.AcceleoMTLInterpreterPlugin;
import org.eclipse.sirius.common.acceleo.mtl.Messages;
import org.eclipse.sirius.common.acceleo.mtl.business.internal.interpreter.AcceleoParserTrimUtil;
import org.eclipse.sirius.ext.base.cache.LRUCache;

public class DynamicAcceleoModule {
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static int currentQueryCount;
    private static final String IMPORT_PREFIX = "[import ";
    private static final String IMPORT_SUFFIX;
    private static final String MODULE_PREFIX = "[module temporaryInterpreterModule";
    private static final String MODULE_SUFFIX;
    private static final String THIS_EOBJECT = "thisEObject";
    private static final String SELF = "self";
    private static final String DUMMY_QUERY;
    private static final String MAX_CACHE_SIZE_PROPERTY_KEY = "org.eclipse.sirius.common.acceleo.mtl.maxCacheSize";
    private static final int INITIAL_CACHE_SIZE = 16;
    private static final int DEFAULT_MAX_CACHE_SIZE = 2000;
    private Set<EPackage> additionalEPackages = new LinkedHashSet<EPackage>();
    private CompilationResult compilationResult;
    private final Map<ModuleDescriptor, CompilationResult> compiledModules;
    private final Map<QueryIdentifier, String> queries;
    private ResourceSet resourceSet;

    static {
        IMPORT_SUFFIX = String.valueOf(']') + LINE_SEPARATOR;
        MODULE_SUFFIX = ")]" + LINE_SEPARATOR;
        DUMMY_QUERY = "[query public {0}(thisEObject : {1}{2}) : OclAny = {3}/]" + LINE_SEPARATOR;
    }

    public DynamicAcceleoModule() {
        this.initializeResourceSet();
        int maxCacheSize = 2000;
        try {
            String propertyCacheSize = System.getProperty(MAX_CACHE_SIZE_PROPERTY_KEY);
            try {
                maxCacheSize = Integer.valueOf(propertyCacheSize);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        catch (SecurityException securityException) {}
        this.queries = new LRUCache(16, maxCacheSize);
        this.compiledModules = new LRUCache<ModuleDescriptor, CompilationResult>(16, maxCacheSize){
            private static final long serialVersionUID = 1L;

            protected boolean removeEldestEntry(Map.Entry<ModuleDescriptor, CompilationResult> eldest) {
                EObject compiledExpressionEObject;
                Resource resource;
                Object compiledExpression;
                boolean shouldEvict = super.removeEldestEntry(eldest);
                if (shouldEvict && (compiledExpression = eldest.getValue().getCompiledExpression()) instanceof EObject && (resource = (compiledExpressionEObject = (EObject)compiledExpression).eResource()) != null) {
                    DynamicAcceleoModule.this.resourceSet.getResources().remove((Object)resource);
                }
                return shouldEvict;
            }
        };
    }

    private static String buildImportDeclarations(Iterable<String> imports) {
        StringBuilder importsBuffer = new StringBuilder();
        for (String dependency : imports) {
            importsBuffer.append(IMPORT_PREFIX);
            importsBuffer.append(dependency);
            importsBuffer.append(IMPORT_SUFFIX);
        }
        return importsBuffer.toString();
    }

    private String buildModuleSignature(CompilationContext context, String queryName) {
        return MODULE_PREFIX + queryName + '(' + this.buildNsURIString(context) + MODULE_SUFFIX;
    }

    private String buildNsURIString(CompilationContext context) {
        LinkedHashSet metamodelURIs = Sets.newLinkedHashSet((Iterable)context.getNsURIs());
        for (EPackage additionalEPackage : this.additionalEPackages) {
            metamodelURIs.add(additionalEPackage.getNsURI());
        }
        if (metamodelURIs.isEmpty()) {
            metamodelURIs.add("http://www.eclipse.org/emf/2002/Ecore");
        }
        StringBuilder nsURIs = new StringBuilder();
        Iterator uriIterator = metamodelURIs.iterator();
        while (uriIterator.hasNext()) {
            nsURIs.append("'" + (String)uriIterator.next() + "'");
            if (!uriIterator.hasNext()) continue;
            nsURIs.append(",");
        }
        return nsURIs.toString();
    }

    private static CharSequence computeVariableSignature(Map<String, String> additionalVariables) {
        if (additionalVariables == null || additionalVariables.isEmpty()) {
            return "";
        }
        StringBuilder signature = new StringBuilder();
        for (Map.Entry<String, String> var : additionalVariables.entrySet()) {
            String varName = var.getKey();
            String varType = var.getValue();
            if (varName == null || varName.length() <= 0 || varType == null || varType.length() <= 0) continue;
            signature.append(',');
            signature.append(varName);
            signature.append(':');
            signature.append(varType);
        }
        return signature;
    }

    private static String extractBody(String expression) {
        String body = expression;
        if (body.startsWith("[")) {
            body = body.substring("[".length());
        }
        if (body.charAt(body.length() - 1) == ']') {
            body = body.substring(0, body.length() - "/]".length());
        }
        return body;
    }

    private static String extractModuleName(String moduleString) {
        int spaceIndex = moduleString.indexOf(32);
        int parenIndex = moduleString.indexOf(40, spaceIndex);
        return moduleString.substring(spaceIndex + 1, parenIndex);
    }

    public String buildMTL(CompilationContext context, QueryIdentifier identifier) {
        StringBuilder expressionBuffer = new StringBuilder();
        String queryName = identifier.getQueryName();
        expressionBuffer.append(this.buildModuleSignature(context, queryName));
        if (context.getDependencies() != null) {
            expressionBuffer.append(DynamicAcceleoModule.buildImportDeclarations(context.getDependencies().keySet()));
        }
        if (context.getExtendedDependencies() != null) {
            LinkedHashSet<String> oclNamespaceImport = new LinkedHashSet<String>();
            for (ModuleDescriptor descriptor : context.getExtendedDependencies()) {
                oclNamespaceImport.add(descriptor.getQualifiedName());
            }
            expressionBuffer.append(DynamicAcceleoModule.buildImportDeclarations(oclNamespaceImport));
        }
        expressionBuffer.append(this.queries.get(identifier));
        return expressionBuffer.toString();
    }

    public CompilationResult compile(CompilationContext context, QueryIdentifier queryId) {
        Query query;
        boolean forceRecompilation = this.compilationResult == null || this.compilationResult.getStatus() != null && this.compilationResult.getStatus().getSeverity() != 0;
        String queryName = queryId.getQueryName();
        if ((!forceRecompilation || this.compilationResult != null && this.compilationResult.getCompiledExpression() instanceof Query) && !queryName.equals((query = (Query)this.compilationResult.getCompiledExpression()).getName())) {
            boolean foundMatch = false;
            Iterator siblings = query.eContainer().eContents().iterator();
            while (!foundMatch && siblings.hasNext()) {
                EObject sibling = (EObject)siblings.next();
                if (!(sibling instanceof Query) || !queryName.equals(((Query)sibling).getName())) continue;
                this.compilationResult.setCompiledExpression((Object)sibling);
                foundMatch = true;
            }
            if (!foundMatch) {
                this.compilationResult = null;
            }
        }
        if (this.compilationResult == null) {
            String moduleString = this.buildMTL(context, queryId);
            String moduleName = DynamicAcceleoModule.extractModuleName(moduleString);
            URI moduleURI = URI.createURI((String)("http://acceleo.eclipse.org/" + moduleName + '.' + "emtl"));
            ModuleDescriptor descriptor = new ModuleDescriptor(moduleURI, moduleName, moduleString);
            CompilationResult cachedResult = this.compiledModules.get(descriptor);
            if (cachedResult == null) {
                Set<URI> extendedImports = this.compileExtendedDependencies(context, this.resourceSet);
                LinkedHashSet importsCopy = Sets.newLinkedHashSet((Iterable)context.getDependencies().values());
                AcceleoCompilationTask compilationTask = new AcceleoCompilationTask(descriptor, (Set)Sets.union((Set)importsCopy, extendedImports), queryName, this.resourceSet);
                try {
                    this.compilationResult = compilationTask.call();
                }
                catch (ExecutionException e) {
                    this.compilationResult = new CompilationResult((IStatus)new Status(4, "org.eclipse.sirius.common.acceleo.mtl", e.getMessage(), (Throwable)e));
                }
                catch (InterruptedException e) {
                    this.compilationResult = new CompilationResult((IStatus)new Status(4, "org.eclipse.sirius.common.acceleo.mtl", e.getMessage(), (Throwable)e));
                }
                catch (Exception e) {
                    this.compilationResult = new CompilationResult((IStatus)new Status(4, "org.eclipse.sirius.common.acceleo.mtl", e.getMessage(), (Throwable)e));
                }
                if (this.compilationResult != null) {
                    new AcceleoParserTrimUtil().trimEnvironment(this.compilationResult);
                    this.compiledModules.put(descriptor, this.compilationResult);
                }
            } else {
                this.compilationResult = cachedResult;
            }
        }
        if (this.compilationResult != null && this.compilationResult.getStatus() != null && this.compilationResult.getStatus().getSeverity() == 4) {
            this.removeQuery(context);
            DynamicAcceleoModule.log(this.compilationResult, context.getExpression());
        }
        return this.compilationResult;
    }

    public QueryIdentifier ensureQueryExists(CompilationContext compilationContext) {
        String queryBody = DynamicAcceleoModule.extractBody(compilationContext.getExpression());
        Map additionalVariables = compilationContext.getVariables();
        QueryIdentifier identifier = new QueryIdentifier(compilationContext.getTargetType(), Maps.newLinkedHashMap((Map)additionalVariables), queryBody);
        String queryName = null;
        Set<QueryIdentifier> existingIds = this.queries.keySet();
        if (existingIds.contains(identifier)) {
            for (QueryIdentifier existingIdentifier : existingIds) {
                if (!existingIdentifier.equals(identifier)) continue;
                identifier = existingIdentifier;
                queryName = identifier.getQueryName();
            }
        }
        if (queryName == null) {
            queryName = identifier.getQueryName();
            String targetType = compilationContext.getTargetType();
            CharSequence additionalVarSignature = DynamicAcceleoModule.computeVariableSignature(additionalVariables);
            String query = MessageFormat.format(DUMMY_QUERY, queryName, targetType, additionalVarSignature, queryBody);
            this.queries.put(identifier, query);
            this.compilationResult = null;
        }
        return identifier;
    }

    public EvaluationResult evaluate(EvaluationContext context) {
        EvaluationResult result = null;
        result = this.evaluationShortcut(context);
        if (result == null) {
            AcceleoEvaluationTask evaluationTask = new AcceleoEvaluationTask(context);
            try {
                result = evaluationTask.call();
            }
            catch (ExecutionException e) {
                result = new EvaluationResult((IStatus)new Status(4, "org.eclipse.sirius.common.acceleo.mtl", e.getMessage(), (Throwable)e));
            }
            catch (InterruptedException e) {
                result = new EvaluationResult((IStatus)new Status(4, "org.eclipse.sirius.common.acceleo.mtl", e.getMessage(), (Throwable)e));
            }
            catch (Exception e) {
                result = new EvaluationResult((IStatus)new Status(4, "org.eclipse.sirius.common.acceleo.mtl", e.getMessage(), (Throwable)e));
            }
        }
        if (result.getStatus().getSeverity() == 4) {
            AcceleoMTLInterpreterPlugin.getDefault().getLog().log(result.getStatus());
        }
        return result;
    }

    private EvaluationResult evaluationShortcut(EvaluationContext context) {
        EvaluationResult shortcut = null;
        Object compiled = context.getCompilationResult().getCompiledExpression();
        if (compiled instanceof Query) {
            OCLExpression exp = ((Query)compiled).getExpression();
            if (exp instanceof VariableExp) {
                Object value = this.getVariableValue(context, exp.getName());
                IStatus status = this.createResultStatus(value);
                shortcut = new EvaluationResult(value, status);
            } else if (exp instanceof PropertyCallExp && ((PropertyCallExp)exp).getSource() instanceof VariableExp) {
                Object source = this.getVariableValue(context, ((PropertyCallExp)exp).getSource().getName());
                if (source instanceof EObject) {
                    Object value = ((EObject)source).eGet((EStructuralFeature)((PropertyCallExp)exp).getReferredProperty());
                    IStatus status = this.createResultStatus(value);
                    shortcut = new EvaluationResult(value, status);
                }
            } else if (exp instanceof BooleanLiteralExp) {
                Boolean value = ((BooleanLiteralExp)exp).getBooleanSymbol();
                IStatus status = this.createResultStatus(value);
                shortcut = new EvaluationResult((Object)value, status);
            }
        }
        return shortcut;
    }

    private Object getVariableValue(EvaluationContext context, String name) {
        if (SELF.equals(name) || THIS_EOBJECT.equals(name)) {
            return context.getTargetEObject();
        }
        List values = context.getVariables().get((Object)name);
        Object value = values.isEmpty() ? null : values.listIterator(values.size()).previous();
        return value;
    }

    public Set<String> getGeneratedQueryNames() {
        Set<QueryIdentifier> identifiers = this.queries.keySet();
        HashSet<String> result = new HashSet<String>(identifiers.size());
        for (QueryIdentifier identifier : identifiers) {
            result.add(identifier.getQueryName());
        }
        return result;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void invalidate() {
        this.queries.clear();
        this.compiledModules.clear();
        this.resourceSet.getResources().clear();
        this.initializeResourceSet();
        this.compilationResult = null;
    }

    public void registerAdditionalEPackages(Set<EPackage> newPackages) {
        this.additionalEPackages = Sets.newLinkedHashSet(newPackages);
        this.invalidate();
    }

    private QueryIdentifier getQueryIdentifier(CompilationContext context) {
        String queryBody = DynamicAcceleoModule.extractBody(context.getExpression());
        Map additionalVariables = context.getVariables();
        QueryIdentifier identifier = new QueryIdentifier(context.getTargetType(), Maps.newLinkedHashMap((Map)additionalVariables), queryBody);
        Set<QueryIdentifier> existingIds = this.queries.keySet();
        if (existingIds.contains(identifier)) {
            for (QueryIdentifier existingIdentifier : existingIds) {
                if (!existingIdentifier.equals(identifier)) continue;
                return existingIdentifier;
            }
        }
        return identifier;
    }

    public Set<URI> compileExtendedDependencies(CompilationContext context, ResourceSet targetResourceSet) {
        LinkedHashSet<URI> extendedDependenciesURIs = new LinkedHashSet<URI>();
        Iterator iterator = context.getExtendedDependencies().iterator();
        while (iterator.hasNext()) {
            boolean resultOK;
            CompilationResult result;
            ModuleDescriptor extended;
            ModuleDescriptor actualModule = extended = (ModuleDescriptor)iterator.next();
            String moduleContent = extended.getModuleContent();
            Matcher moduleSignatureMatcher = Pattern.compile("\\[module ([^(]+)\\(([^)]*)\\{0\\}([^)]*)\\)").matcher(moduleContent);
            String nsURIString = this.buildNsURIString(context);
            if (moduleSignatureMatcher.find()) {
                if (moduleSignatureMatcher.group(2).length() > 0) {
                    nsURIString = String.valueOf(',') + nsURIString;
                }
                if (moduleSignatureMatcher.group(3).length() > 0) {
                    nsURIString = String.valueOf(nsURIString) + ',';
                }
                String replacement = "[module $1($2" + nsURIString + "$3)";
                String actualModuleContent = moduleSignatureMatcher.replaceFirst(replacement);
                actualModule = new ModuleDescriptor(extended.getModuleURI(), extended.getQualifiedName(), actualModuleContent);
            }
            if ((result = this.compiledModules.get(actualModule)) == null || result.getCompiledExpression() instanceof EObject && ((EObject)result.getCompiledExpression()).eResource() == null) {
                AcceleoCompilationTask compilationTask = new AcceleoCompilationTask(actualModule, null, null, targetResourceSet);
                try {
                    result = compilationTask.call();
                }
                catch (ExecutionException executionException) {
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {}
                if (result != null) {
                    new AcceleoParserTrimUtil().trimEnvironment(result);
                }
                this.compiledModules.put(actualModule, result);
            }
            boolean bl = resultOK = result != null && result.getCompiledExpression() instanceof EObject && (result.getStatus() == null || result.getStatus().getSeverity() < 4);
            if (!resultOK) continue;
            assert (result != null);
            EObject compiledExpression = (EObject)result.getCompiledExpression();
            extendedDependenciesURIs.add(compiledExpression.eResource().getURI());
        }
        return extendedDependenciesURIs;
    }

    private void initializeResourceSet() {
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.setPackageRegistry((EPackage.Registry)AcceleoPackageRegistry.INSTANCE);
        for (EPackage pack : this.additionalEPackages) {
            AcceleoPackageRegistry.INSTANCE.registerEcorePackage(pack);
        }
    }

    private void removeQuery(CompilationContext context) {
        QueryIdentifier queryForContext = this.getQueryIdentifier(context);
        this.queries.remove(queryForContext);
    }

    private static void log(CompilationResult result, String expression) {
        Throwable cause;
        String errorMessage;
        if (result.getStatus() instanceof MultiStatus && ((MultiStatus)result.getStatus()).getChildren().length > 0) {
            IStatus child = ((MultiStatus)result.getStatus()).getChildren()[0];
            errorMessage = child.getMessage();
            cause = child.getException();
        } else {
            errorMessage = result.getStatus().getMessage();
            cause = result.getStatus().getException();
        }
        String formattedMessage = MessageFormat.format(Messages.DynamicAcceleoModule_compilationError, expression, errorMessage);
        Status logStatus = new Status(result.getStatus().getSeverity(), result.getStatus().getPlugin(), formattedMessage, cause);
        AcceleoMTLInterpreterPlugin.getDefault().getLog().log((IStatus)logStatus);
    }

    public static String getDynamicModuleQueryPrefix() {
        return "dynamicModuleQuery";
    }

    private IStatus createResultStatus(Object result) {
        String oclType = result == null ? "OCLVoid" : DynamicAcceleoModule.inferOCLType(result);
        String size = null;
        if (result instanceof String) {
            size = String.valueOf(((String)result).length());
        } else if (result instanceof Collection) {
            size = String.valueOf(((Collection)result).size());
        }
        String message = AcceleoEngineMessages.getString((String)"AcceleoEvaluationTask.ResultType", (Object[])new Object[]{oclType});
        if (size != null) {
            message = String.valueOf(message) + ' ' + AcceleoEngineMessages.getString((String)"AcceleoEvaluationTask.ResultSize", (Object[])new Object[]{size});
        }
        return new Status(0, "org.eclipse.acceleo.engine", message);
    }

    private static String inferOCLType(Object obj) {
        String oclType = "OCLAny";
        EcoreEnvironment env = (EcoreEnvironment)new EcoreEnvironmentFactory().createEnvironment();
        if (obj instanceof Collection) {
            EClassifier elementType = DynamicAcceleoModule.inferCollectionContentOCLType(env, (Collection)obj);
            CollectionKind kind = CollectionKind.SEQUENCE_LITERAL;
            if (obj instanceof LinkedHashSet) {
                kind = CollectionKind.ORDERED_SET_LITERAL;
            } else if (obj instanceof Set) {
                kind = CollectionKind.SET_LITERAL;
            } else if (obj instanceof Bag) {
                kind = CollectionKind.BAG_LITERAL;
            }
            oclType = env.getTypeResolver().resolveCollectionType(kind, (Object)elementType).getName();
        } else {
            oclType = DynamicAcceleoModule.getOCLType(env, obj).getName();
        }
        return oclType;
    }

    protected static EClassifier inferCollectionContentOCLType(EcoreEnvironment env, Collection<?> coll) {
        if (coll.isEmpty()) {
            return (EClassifier)env.getOCLStandardLibrary().getOclAny();
        }
        HashSet<EClassifier> types = new HashSet<EClassifier>();
        for (Object child : coll) {
            types.add(DynamicAcceleoModule.getOCLType(env, child));
        }
        Iterator iterator = types.iterator();
        EClassifier elementType = (EClassifier)iterator.next();
        while (iterator.hasNext()) {
            elementType = (EClassifier)env.getUMLReflection().getCommonSuperType((Object)elementType, (Object)((EClassifier)iterator.next()));
        }
        if (elementType == null) {
            elementType = (EClassifier)env.getOCLStandardLibrary().getOclAny();
        }
        return elementType;
    }

    protected static EClassifier getOCLType(EcoreEnvironment env, Object obj) {
        OCLStandardLibrary library = env.getOCLStandardLibrary();
        EClassifier oclType = (EClassifier)library.getOclAny();
        if (obj instanceof Number) {
            oclType = obj instanceof BigDecimal || obj instanceof Double || obj instanceof Float ? (EClassifier)library.getReal() : (EClassifier)library.getInteger();
        } else if (obj instanceof String) {
            oclType = (EClassifier)library.getString();
        } else if (obj instanceof Boolean) {
            oclType = (EClassifier)library.getBoolean();
        } else if (obj instanceof EObject) {
            oclType = (EClassifier)env.getUMLReflection().asOCLType((Object)((EObject)obj).eClass());
        } else if (obj instanceof Collection) {
            oclType = obj instanceof LinkedHashSet ? (EClassifier)library.getOrderedSet() : (obj instanceof Set ? (EClassifier)library.getSet() : (obj instanceof Bag ? (EClassifier)library.getBag() : (EClassifier)library.getSequence()));
        }
        return oclType;
    }

    public final class QueryIdentifier {
        private static final String QUERY_NAME_PREFIX = "dynamicModuleQuery";
        private static final String DEFAULT_TARGET_TYPE = "ecore::EObject";
        private final String body;
        private String queryName;
        private final Map<String, String> queryVariables;
        private final String targetType;

        public QueryIdentifier(String target, Map<String, String> queryVariables, String expression) {
            this.targetType = Optional.ofNullable(target).orElse(DEFAULT_TARGET_TYPE);
            this.queryVariables = queryVariables;
            this.body = expression;
        }

        public boolean equals(Object obj) {
            boolean equals;
            if (!(obj instanceof QueryIdentifier)) {
                return false;
            }
            QueryIdentifier other = (QueryIdentifier)obj;
            boolean bl = equals = this.targetType.equals(other.targetType) && this.body.equals(other.body);
            if (equals) {
                equals = this.queryVariables == other.queryVariables || this.queryVariables != null && this.queryVariables.equals(other.queryVariables);
            }
            return equals;
        }

        public String getQueryName() {
            if (this.queryName == null) {
                StringBuilder stringBuilder = new StringBuilder(QUERY_NAME_PREFIX);
                int n = currentQueryCount;
                currentQueryCount = n + 1;
                this.queryName = stringBuilder.append(n).toString();
            }
            return this.queryName;
        }

        public int hashCode() {
            int hashCode = this.targetType.hashCode() + this.body.hashCode();
            if (this.queryVariables != null) {
                hashCode += this.queryVariables.hashCode();
            }
            return hashCode;
        }
    }
}

