/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.Arrays;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;

public class BusyIndicator {
    static int nextBusyId = 1;
    static final String BUSYID_NAME = "SWT BusyIndicator";
    static final String BUSY_CURSOR = "SWT BusyIndicator Cursor";

    public static void showWhile(Display display, Runnable runnable) {
        if (runnable == null) {
            SWT.error(4);
        }
        if (display == null && (display = Display.getCurrent()) == null) {
            runnable.run();
            return;
        }
        Integer busyId = nextBusyId;
        ++nextBusyId;
        Cursor cursor = display.getSystemCursor(1);
        Arrays.stream(display.getShells()).filter(shell -> !shell.isDisposed() && shell.getData(BUSYID_NAME) == null).forEach(shell -> {
            shell.setCursor(cursor);
            shell.setData(BUSYID_NAME, busyId);
        });
        try {
            runnable.run();
        }
        finally {
            Arrays.stream(display.getShells()).filter(shell -> !shell.isDisposed() && shell.getData(BUSYID_NAME) == busyId).forEach(shell -> {
                shell.setCursor(null);
                shell.setData(BUSYID_NAME, null);
            });
        }
    }
}

