/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.utils;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.tcf.te.runtime.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;

public final class ProgressHelper {
    public static final int PROGRESS_DONE = 0;
    public static final int PROGRESS_NONE = -1;

    public static final boolean isCancelOrError(Object caller, IStatus status, IProgressMonitor progress, ICallback callback) {
        if (status == null) {
            status = Status.OK_STATUS;
        }
        if (!status.isOK() || progress != null && progress.isCanceled()) {
            if (status.getSeverity() == 8 || progress != null && progress.isCanceled()) {
                status = new Status(8, status.getPlugin(), status.getCode(), status.getMessage(), (Throwable)new OperationCanceledException());
            } else if (status.getSeverity() == 4) {
                Throwable e = status.getException();
                try {
                    throw e;
                }
                catch (Throwable thrown) {
                    e = thrown;
                    CoreBundleActivator.getTraceHandler().trace(status.getMessage(), 1, "trace/callbacks", status.getSeverity(), caller != null ? caller.getClass() : ProgressHelper.class);
                    status = new Status(4, status.getPlugin(), status.getCode(), status.getMessage(), e);
                }
            }
            if (callback != null) {
                if (caller instanceof ICallback) {
                    Callback.copyProperties((ICallback)caller, callback);
                }
                callback.done(caller, status);
            }
            return true;
        }
        return false;
    }

    public static final boolean isCancel(Object caller, IProgressMonitor progress, ICallback callback) {
        Assert.isNotNull((Object)progress);
        return ProgressHelper.isCancel(caller, null, progress, callback);
    }

    public static final boolean isCancel(Object caller, IStatus status, ICallback callback) {
        Assert.isNotNull((Object)status);
        return ProgressHelper.isCancel(caller, status, null, callback);
    }

    public static final boolean isCancel(Object caller, IStatus status, IProgressMonitor progress, ICallback callback) {
        if (status == null) {
            status = Status.OK_STATUS;
        }
        if (status.getSeverity() == 8 || progress != null && progress.isCanceled()) {
            status = new Status(8, status.getPlugin(), status.getCode(), status.getMessage(), (Throwable)new OperationCanceledException());
            if (callback != null) {
                if (caller instanceof ICallback) {
                    Callback.copyProperties((ICallback)caller, callback);
                }
                callback.done(caller, status);
            }
            return true;
        }
        return false;
    }

    public static final boolean isError(Object caller, IStatus status, ICallback callback) {
        if (status == null) {
            status = Status.OK_STATUS;
        }
        if (!status.isOK() && status.getSeverity() != 8) {
            if (status.getSeverity() == 4) {
                Throwable e = status.getException();
                try {
                    throw e;
                }
                catch (Throwable thrown) {
                    e = thrown;
                    CoreBundleActivator.getTraceHandler().trace(status.getMessage(), 1, "trace/callbacks", status.getSeverity(), caller != null ? caller.getClass() : ProgressHelper.class);
                    status = new Status(4, status.getPlugin(), status.getCode(), status.getMessage(), e);
                }
            }
            if (callback != null) {
                if (caller instanceof ICallback) {
                    Callback.copyProperties((ICallback)caller, callback);
                }
                callback.done(caller, status);
            }
            return true;
        }
        return false;
    }

    public static final IProgressMonitor getProgressMonitor(IProgressMonitor progress, int ticksToUse) {
        progress = progress != null ? new SubProgressMonitor(progress, ticksToUse, 4) : new NullProgressMonitor();
        return progress;
    }

    public static final void beginTask(IProgressMonitor progress, String name, int ticks) {
        if (progress != null) {
            progress.beginTask("", ticks);
            progress.setTaskName(name);
        }
    }

    public static final void setTaskName(IProgressMonitor progress, String taskName) {
        if (progress != null) {
            progress.setTaskName(taskName);
        }
    }

    public static final void setSubTaskName(IProgressMonitor progress, String subTaskName) {
        if (progress != null) {
            progress.subTask(subTaskName);
        }
    }

    public static final void worked(IProgressMonitor progress, int worked) {
        if (progress != null && !progress.isCanceled() && worked > 0) {
            progress.worked(worked);
        }
    }

    public static final void done(IProgressMonitor progress) {
        if (progress != null) {
            progress.setTaskName("");
            progress.subTask("");
            progress.done();
        }
    }

    public static final void cancel(IProgressMonitor progress) {
        if (progress != null && !progress.isCanceled()) {
            progress.setCanceled(true);
        }
    }

    public static final boolean isCanceled(IProgressMonitor progress) {
        if (progress != null) {
            return progress.isCanceled();
        }
        return false;
    }
}

