/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.ide.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.tips.core.ITipManager;
import org.eclipse.tips.core.Tip;
import org.eclipse.tips.core.TipProvider;
import org.eclipse.tips.core.internal.LogUtil;
import org.eclipse.tips.core.internal.TipManager;
import org.eclipse.tips.ide.internal.Messages;
import org.eclipse.tips.ide.internal.Plugin;
import org.eclipse.tips.ide.internal.ProviderLoadJobChangeListener;
import org.eclipse.tips.ide.internal.TipSourceProvider;
import org.eclipse.tips.ide.internal.TipsPreferences;
import org.eclipse.tips.ui.internal.DefaultTipManager;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IEvaluationService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IDETipManager
extends DefaultTipManager {
    private static final String EMPTY = "";
    private TipSourceProvider fSourceProvider = new TipSourceProvider((ITipManager)this);
    private Map<String, List<Integer>> fReadTips = TipsPreferences.getReadState();
    private boolean fNewTips;
    private boolean fSourceProviderAdded;
    private static IDETipManager instance = new IDETipManager();

    public static synchronized ITipManager getInstance() {
        if (instance.isDisposed()) {
            instance = new IDETipManager();
        }
        return instance;
    }

    private IDETipManager() {
    }

    public ITipManager register(TipProvider provider) {
        this.log(LogUtil.info((String)(String.valueOf(Messages.IDETipManager_0) + provider.getID())));
        super.register(provider);
        this.load(provider);
        return this;
    }

    private void load(final TipProvider provider) {
        Job job = new Job(String.valueOf(Messages.IDETipManager_1) + provider.getID()){

            protected IStatus run(IProgressMonitor monitor) {
                return provider.loadNewTips(monitor);
            }
        };
        job.addJobChangeListener((IJobChangeListener)new ProviderLoadJobChangeListener(this, provider));
        job.schedule();
        provider.getManager().log(LogUtil.info((String)MessageFormat.format(Messages.IDETipManager_2, provider.getID())));
    }

    public ITipManager open(boolean startUp) {
        if (this.isOpen()) {
            super.open(startUp);
            return this;
        }
        if (!this.fSourceProviderAdded) {
            IEvaluationService evaluationService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
            evaluationService.addSourceProvider((ISourceProvider)this.fSourceProvider);
            this.fSourceProviderAdded = true;
        }
        return super.open(startUp, Plugin.getInstance().getDialogSettings());
    }

    private void saveReadState(final Map<String, List<Integer>> pReadTips) {
        Job job = new Job(Messages.IDETipManager_3){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
                subMonitor.setTaskName(Messages.IDETipManager_4);
                IStatus status = TipsPreferences.saveReadState(pReadTips);
                subMonitor.done();
                return status;
            }
        };
        job.schedule();
    }

    private void refreshUI() {
        final boolean newTips = this.hasNewTips();
        Job job = new Job(Messages.IDETipManager_5){

            protected IStatus run(IProgressMonitor monitor) {
                IDETipManager.this.setNewTips(newTips);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private boolean hasNewTips() {
        this.log(LogUtil.info((String)"START: Query all providers for new tips."));
        int newTipCount = 0;
        for (TipProvider provider : this.getProviders()) {
            newTipCount += provider.getTips(tip -> !this.isRead((Tip)tip)).size();
        }
        this.log(LogUtil.info((String)("END:   Query all providers for new tips: " + (newTipCount > 0))));
        return newTipCount > 0;
    }

    public int getStartupBehavior() {
        return TipsPreferences.getStartupBehavior();
    }

    public TipManager setStartupBehavior(int startupBehavior) {
        TipsPreferences.setStartupBehavior(startupBehavior);
        return this;
    }

    public boolean mustServeReadTips() {
        return TipsPreferences.isServeReadTips();
    }

    public TipManager setServeReadTips(boolean serveRead) {
        TipsPreferences.setServeReadTips(serveRead);
        return this;
    }

    public ITipManager log(IStatus status) {
        TipsPreferences.log(status);
        return this;
    }

    public boolean isRead(Tip tip) {
        return this.fReadTips.containsKey(tip.getProviderId()) && this.fReadTips.get(tip.getProviderId()).contains(tip.hashCode());
    }

    public synchronized TipManager setAsRead(Tip tip) {
        if (!this.isRead(tip)) {
            List<Integer> readTips = this.fReadTips.get(tip.getProviderId());
            if (readTips == null) {
                readTips = new ArrayList<Integer>();
                this.fReadTips.put(tip.getProviderId(), readTips);
            }
            readTips.add(tip.hashCode());
        }
        return this;
    }

    protected synchronized IDETipManager setNewTips(boolean newTips) {
        boolean newValue;
        this.log(LogUtil.info((String)MessageFormat.format(Messages.IDETipManager_6, String.valueOf(newTips))));
        boolean bl = newValue = newTips && this.getStartupBehavior() != 2;
        if (this.fNewTips != newValue) {
            this.fNewTips = newValue;
            this.fSourceProvider.setStatus(this.fNewTips);
        }
        return this;
    }

    public void dispose() {
        try {
            this.refreshUI();
            this.saveReadState(Collections.unmodifiableMap(this.fReadTips));
        }
        finally {
            super.dispose();
        }
    }

    public int getPriority(TipProvider provider) {
        this.log(LogUtil.info((String)MessageFormat.format(Messages.IDETipManager_8, provider.getExpression())));
        int priority = this.doGetPriority(provider.getExpression());
        this.log(LogUtil.info((String)MessageFormat.format(Messages.IDETipManager_9, priority)));
        return priority;
    }

    private int doGetPriority(String expression) {
        if (expression == null) {
            return 20;
        }
        try {
            String myExpression = "<enablement>" + expression + "</enablement>";
            myExpression = "<?xml version=\"1.0\"?>" + myExpression;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = factory.newDocumentBuilder().parse(new ByteArrayInputStream(myExpression.getBytes()));
            Element element = (Element)doc.getElementsByTagName("enablement").item(0);
            Expression expressionObj = ExpressionConverter.getDefault().perform(element);
            EvaluationResult result = expressionObj.evaluate(IDETipManager.getEvaluationContext());
            if (result == EvaluationResult.TRUE) {
                return 10;
            }
            return 30;
        }
        catch (Exception e) {
            this.log(LogUtil.error((Throwable)e));
            return 20;
        }
    }

    private static IEvaluationContext getEvaluationContext() {
        IEvaluationService evalService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        IEvaluationContext currentState = evalService.getCurrentState();
        return currentState;
    }

    public static File getStateLocation() throws Exception {
        File locationDir;
        String stateLocation = System.getProperty("org.eclipse.tips.statelocation");
        if (stateLocation == null) {
            stateLocation = String.valueOf(System.getProperty("user.home")) + File.separator + ".eclipse" + File.separator + "org.eclipse.tips.state";
        }
        if (!(locationDir = new File(stateLocation)).exists()) {
            locationDir.mkdirs();
        }
        if (!locationDir.canRead() || !locationDir.canWrite()) {
            throw new IOException(MessageFormat.format(Messages.IDETipManager_18, locationDir.getAbsolutePath()));
        }
        return locationDir;
    }
}

