/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.process;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.common.core.process.Messages;
import org.eclipse.tracecompass.internal.common.core.Activator;

public final class ProcessUtils {
    private static final Logger LOGGER = TraceCompassLog.getLogger(ProcessUtils.class);
    private static final int PROGRESS_DURATION = 1000;

    private ProcessUtils() {
    }

    /*
     * Exception decompiling
     */
    public static @Nullable List<String> getOutputFromCommand(List<String> command) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<String> getOutputFromCommandCancellable(List<String> command, IProgressMonitor monitor, String mainTaskName, OutputReaderFunction readerFunction) throws CoreException {
        CancellableRunnable cancellerRunnable = null;
        Thread cancellerThread = null;
        try {
            List<String> list;
            TraceCompassLogUtils.ScopeLog sl;
            block39: {
                Throwable throwable = null;
                Object var7_9 = null;
                sl = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINER, "ProcessUtils#getOutputFromCommandCancellable", "MainTaskName", mainTaskName, "args", command);
                monitor.beginTask(mainTaskName, 1000);
                ProcessBuilder builder = new ProcessBuilder(command);
                builder.redirectErrorStream(false);
                Process p = NonNullUtils.checkNotNull(builder.start());
                cancellerRunnable = new CancellableRunnable(p, monitor);
                cancellerThread = new Thread(cancellerRunnable);
                cancellerThread.start();
                Throwable throwable2 = null;
                Object var12_16 = null;
                BufferedReader stdoutReader = new BufferedReader(new InputStreamReader(p.getInputStream(), Charsets.UTF_8));
                try {
                    List<String> lines = readerFunction.readOutput(stdoutReader, monitor);
                    int ret = p.waitFor();
                    if (monitor.isCanceled()) {
                        Status status = new Status(8, Activator.instance().getPluginId(), null);
                        throw new CoreException((IStatus)status);
                    }
                    if (ret != 0) {
                        BufferedReader stderrReader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                        List stderrOutput = stderrReader.lines().collect(Collectors.toList());
                        MultiStatus status = new MultiStatus(Activator.instance().getPluginId(), 4, Messages.ProcessUtils_ErrorDuringExecution, null);
                        for (String str : stderrOutput) {
                            status.add((IStatus)new Status(4, Activator.instance().getPluginId(), str));
                        }
                        if (stderrOutput.isEmpty()) {
                            status.add((IStatus)new Status(4, Activator.instance().getPluginId(), Messages.ProcessUtils_ErrorNoOutput));
                        }
                        throw new CoreException((IStatus)status);
                    }
                    list = lines;
                    if (stdoutReader == null) break block39;
                }
                catch (Throwable throwable3) {
                    try {
                        if (stdoutReader != null) {
                            stdoutReader.close();
                        }
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        try {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable5) {
                            try {
                                if (sl != null) {
                                    sl.close();
                                }
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                try {
                                    if (throwable == null) {
                                        throwable = throwable6;
                                    } else if (throwable != throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                    throw throwable;
                                }
                                catch (IOException | InterruptedException e) {
                                    Status status = new Status(4, Activator.instance().getPluginId(), Messages.ProcessUtils_ExecutionInterrupted, (Throwable)e);
                                    throw new CoreException((IStatus)status);
                                }
                            }
                        }
                    }
                }
                stdoutReader.close();
            }
            if (sl != null) {
                sl.close();
            }
            if (cancellerRunnable != null) {
                cancellerRunnable.setFinished();
            }
            if (cancellerThread != null) {
                try {
                    cancellerThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            monitor.done();
            return list;
        }
        catch (Throwable throwable) {
            if (cancellerRunnable != null) {
                cancellerRunnable.setFinished();
            }
            if (cancellerThread != null) {
                try {
                    cancellerThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            monitor.done();
            throw throwable;
        }
    }

    private static class CancellableRunnable
    implements Runnable {
        private static final int SLEEP_DURATION = 500;
        private final Process fProcess;
        private final IProgressMonitor fMonitor;
        private boolean fIsFinished = false;

        public CancellableRunnable(Process process, IProgressMonitor monitor) {
            this.fProcess = process;
            this.fMonitor = monitor;
        }

        public void setFinished() {
            this.fIsFinished = true;
        }

        @Override
        public void run() {
            try {
                while (!this.fIsFinished) {
                    Thread.sleep(500L);
                    if (!this.fMonitor.isCanceled()) continue;
                    this.fProcess.destroy();
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @FunctionalInterface
    public static interface OutputReaderFunction {
        public List<String> readOutput(BufferedReader var1, IProgressMonitor var2) throws IOException;
    }
}

