/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.io;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.CTFException;

public final class BitBuffer {
    private static final int BIT_CHAR = 8;
    private static final int BYTE_MASK = 255;
    private static final int BIT_SHORT = 16;
    private static final int SHORT_MASK = 65535;
    private static final int BIT_INT = 32;
    private static final long INT_MASK = 0xFFFFFFFFL;
    private static final int BIT_LONG = 64;
    private final @NonNull ByteBuffer fBuffer;
    private final long fBitCapacity;
    private long fPosition;
    private ByteOrder fByteOrder;

    public BitBuffer() {
        this(ByteBuffer.allocateDirect(0), ByteOrder.BIG_ENDIAN);
    }

    public BitBuffer(@NonNull ByteBuffer buf) {
        this(buf, ByteOrder.BIG_ENDIAN);
    }

    public BitBuffer(@NonNull ByteBuffer buf, ByteOrder order) {
        this.fBuffer = buf;
        this.setByteOrder(order);
        this.resetPosition();
        this.fBitCapacity = (long)this.fBuffer.capacity() * 8L;
    }

    private void resetPosition() {
        this.fPosition = 0L;
    }

    public int getInt() throws CTFException {
        return this.getInt(32, true);
    }

    public long getLong() throws CTFException {
        return this.get(64, true);
    }

    public long get(int length, boolean signed) throws CTFException {
        if (length > 64) {
            throw new CTFException("Cannot read a long longer than 64 bits. Rquested: " + length);
        }
        if (length > 32) {
            long retVal;
            int highShift = length - 32;
            long a = this.getInt();
            long b = this.getInt(highShift, false);
            long l = retVal = this.fByteOrder == ByteOrder.BIG_ENDIAN ? a << highShift | b : (b &= (1L << highShift) - 1L) << 32 | (a &= 0xFFFFFFFFL);
            if (signed) {
                int signExtendBits = 64 - length;
                retVal = retVal << signExtendBits >> signExtendBits;
            }
            return retVal;
        }
        long retVal = this.getInt(length, signed);
        return signed ? retVal : retVal & 0xFFFFFFFFL;
    }

    public void get(byte @NonNull [] dst) {
        this.fBuffer.position((int)(this.fPosition / 8L));
        this.fBuffer.get(dst);
        this.fPosition += (long)(dst.length * 8);
    }

    private int getInt(int length, boolean signed) throws CTFException {
        if (length == 0) {
            return 0;
        }
        if (!this.canRead(length)) {
            throw new CTFException("Cannot read the integer, the buffer does not have enough remaining space. Requested:" + length + " Available:" + (this.fBitCapacity - this.fPosition));
        }
        int val = 0;
        boolean gotIt = false;
        if ((this.fPosition & 7L) == 0L) {
            switch (length) {
                case 8: {
                    val = this.fBuffer.get((int)(this.fPosition / 8L));
                    if (!signed) {
                        val &= 0xFF;
                    }
                    gotIt = true;
                    break;
                }
                case 16: {
                    val = this.fBuffer.getShort((int)(this.fPosition / 8L));
                    if (!signed) {
                        val &= 0xFFFF;
                    }
                    gotIt = true;
                    break;
                }
                case 32: {
                    val = this.fBuffer.getInt((int)(this.fPosition / 8L));
                    gotIt = true;
                    break;
                }
            }
        }
        if (!gotIt) {
            val = this.fByteOrder == ByteOrder.LITTLE_ENDIAN ? this.getIntLE(this.fPosition, length, signed) : this.getIntBE(this.fPosition, length, signed);
        }
        this.fPosition += (long)length;
        return val;
    }

    private int getIntBE(long index, int length, boolean signed) {
        int lshift;
        int cmask;
        int mask;
        boolean isNeg;
        if (length <= 0 || length > 32) {
            throw new IllegalArgumentException("Length must be between 1-32 bits");
        }
        long end = index + (long)length;
        int startByte = (int)(index / 8L);
        int endByte = (int)((end + 7L) / 8L);
        int value = 0;
        int currByte = startByte;
        int cache = this.fBuffer.get(currByte) & 0xFF;
        boolean bl = isNeg = (cache & 1 << (int)(8L - index % 8L - 1L)) != 0;
        if (signed && isNeg) {
            value = -1;
        }
        if (startByte == endByte - 1) {
            int cmask2 = cache >>> (int)((8L - end % 8L) % 8L);
            if (length % 8 > 0) {
                int mask2 = ~(-1 << length);
                cmask2 &= mask2;
            }
            value <<= length;
            return value |= cmask2;
        }
        int cshift = (int)(index % 8L);
        if (cshift > 0) {
            mask = ~(-1 << 8 - cshift);
            cmask = cache & mask;
            lshift = 8 - cshift;
            value <<= lshift;
            value |= cmask;
            ++currByte;
        }
        while (currByte < endByte - 1) {
            value <<= 8;
            value |= this.fBuffer.get(currByte) & 0xFF;
            ++currByte;
        }
        lshift = (int)(end % 8L);
        if (lshift > 0) {
            mask = ~(-1 << lshift);
            cmask = this.fBuffer.get(currByte) & 0xFF;
            cmask >>>= 8 - lshift;
            value <<= lshift;
            value |= (cmask &= mask);
        } else {
            value <<= 8;
            value |= this.fBuffer.get(currByte) & 0xFF;
        }
        return value;
    }

    private int getIntLE(long index, int length, boolean signed) {
        int cmask;
        int mask;
        boolean isNeg;
        if (length <= 0 || length > 32) {
            throw new IllegalArgumentException("Length must be between 1-32 bits");
        }
        long end = index + (long)length;
        int startByte = (int)(index / 8L);
        int endByte = (int)((end + 7L) / 8L);
        int value = 0;
        int currByte = endByte - 1;
        int cache = this.fBuffer.get(currByte) & 0xFF;
        int mod = (int)(end % 8L);
        int lshift = mod > 0 ? mod : 8;
        boolean bl = isNeg = (cache & 1 << lshift - 1) != 0;
        if (signed && isNeg) {
            value = -1;
        }
        if (startByte == endByte - 1) {
            int cmask2 = cache >>> (int)(index % 8L);
            if (length % 8 > 0) {
                int mask2 = ~(-1 << length);
                cmask2 &= mask2;
            }
            value <<= length;
            return value |= cmask2;
        }
        int cshift = (int)(end % 8L);
        if (cshift > 0) {
            mask = ~(-1 << cshift);
            cmask = cache & mask;
            value <<= cshift;
            value |= cmask;
            --currByte;
        }
        while (currByte >= startByte + 1) {
            value <<= 8;
            value |= this.fBuffer.get(currByte) & 0xFF;
            --currByte;
        }
        lshift = (int)(index % 8L);
        if (lshift > 0) {
            mask = ~(-1 << 8 - lshift);
            cmask = this.fBuffer.get(currByte) & 0xFF;
            cmask >>>= lshift;
            value <<= 8 - lshift;
            value |= (cmask &= mask);
        } else {
            value <<= 8;
            value |= this.fBuffer.get(currByte) & 0xFF;
        }
        return value;
    }

    public void putInt(int value) throws CTFException {
        this.putInt(32, value);
    }

    public void putLong(int length, long value) throws CTFException {
        if (!this.canRead(length)) {
            throw new CTFException("Cannot write to bitbuffer, insufficient space. Requested: " + length);
        }
        if (length == 0) {
            return;
        }
        if (length <= 32) {
            this.putInt(length, (int)value);
            return;
        }
        if (this.getByteOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
            this.putInt(32, (int)(value & 0xFFFFFFFFL));
            this.putInt(length - 32, (int)(value >> 32));
            return;
        }
        this.putInt(length - 32, (int)(value >> 32));
        this.putInt(32, (int)(value & 0xFFFFFFFFL));
    }

    public void put(byte[] value) throws CTFException {
        if (value == null || value.length == 0) {
            return;
        }
        if (!this.canRead(value.length)) {
            throw new CTFException("Cannot write to bitbuffer, insufficient space. Requested: " + value.length);
        }
        this.fBuffer.put(value);
    }

    public void put(byte value) throws CTFException {
        if (!this.canRead(8)) {
            throw new CTFException("Cannot write to bitbuffer, insufficient space. Requested: 8");
        }
        this.fBuffer.put(value);
    }

    public void putInt(int length, int value) throws CTFException {
        long curPos = this.fPosition;
        if (!this.canRead(length)) {
            throw new CTFException("Cannot write to bitbuffer, insufficient space. Requested: " + length);
        }
        if (length == 0) {
            return;
        }
        if (this.fByteOrder == ByteOrder.LITTLE_ENDIAN) {
            this.putIntLE(curPos, length, value);
        } else {
            this.putIntBE(curPos, length, value);
        }
        this.fPosition += (long)length;
    }

    private void putIntBE(long index, int length, int value) {
        int b;
        int cmask;
        int mask;
        if (length <= 0 || length > 32) {
            throw new IllegalArgumentException("Length must be between 1-32 bits");
        }
        long end = index + (long)length;
        int startByte = (int)(index / 8L);
        int endByte = (int)((end + 7L) / 8L);
        int correctedValue = value;
        if (length < 32) {
            correctedValue &= ~(-1 << length);
        }
        if (startByte == endByte - 1) {
            int lshift = (int)((8L - end % 8L) % 8L);
            int mask2 = ~(-1 << lshift);
            if (index % 8L > 0L) {
                mask2 |= -1 << (int)(8L - index % 8L);
            }
            int cmask2 = correctedValue << lshift;
            int b2 = this.fBuffer.get(startByte) & 0xFF;
            this.fBuffer.put(startByte, (byte)(b2 & mask2 | (cmask2 &= ~mask2)));
            return;
        }
        int currByte = endByte - 1;
        int cshift = (int)(end % 8L);
        if (cshift > 0) {
            int lshift = 8 - cshift;
            mask = ~(-1 << lshift);
            cmask = correctedValue << lshift;
            b = this.fBuffer.get(currByte) & 0xFF;
            this.fBuffer.put(currByte, (byte)(b & mask | (cmask &= ~mask)));
            correctedValue >>>= cshift;
            --currByte;
        }
        while (currByte >= startByte + 1) {
            this.fBuffer.put(currByte, (byte)correctedValue);
            correctedValue >>>= 8;
            --currByte;
        }
        if (index % 8L > 0L) {
            mask = -1 << (int)(8L - index % 8L);
            cmask = correctedValue & ~mask;
            b = this.fBuffer.get(currByte) & 0xFF;
            this.fBuffer.put(currByte, (byte)(b & mask | cmask));
        } else {
            this.fBuffer.put(currByte, (byte)correctedValue);
        }
    }

    private void putIntLE(long index, int length, int value) {
        int b;
        int cmask;
        int mask;
        if (length <= 0 || length > 32) {
            throw new IllegalArgumentException("Length must be between 1-32 bits");
        }
        long end = index + (long)length;
        int startByte = (int)(index / 8L);
        int endByte = (int)((end + 7L) / 8L);
        int correctedValue = value;
        if (length < 32) {
            correctedValue &= ~(-1 << length);
        }
        if (startByte == endByte - 1) {
            int lshift = (int)(index % 8L);
            int mask2 = ~(-1 << lshift);
            if (end % 8L > 0L) {
                mask2 |= -1 << (int)(end % 8L);
            }
            int cmask2 = correctedValue << lshift;
            int b2 = this.fBuffer.get(startByte) & 0xFF;
            this.fBuffer.put(startByte, (byte)(b2 & mask2 | (cmask2 &= ~mask2)));
            return;
        }
        int currByte = startByte;
        int cshift = (int)(index % 8L);
        if (cshift > 0) {
            mask = ~(-1 << cshift);
            cmask = correctedValue << cshift;
            b = this.fBuffer.get(currByte) & 0xFF;
            this.fBuffer.put(currByte, (byte)(b & mask | (cmask &= ~mask)));
            correctedValue >>>= 8 - cshift;
            ++currByte;
        }
        while (currByte < endByte - 1) {
            this.fBuffer.put(currByte, (byte)correctedValue);
            correctedValue >>>= 8;
            ++currByte;
        }
        if (end % 8L > 0L) {
            mask = -1 << (int)(end % 8L);
            cmask = correctedValue & ~mask;
            b = this.fBuffer.get(currByte) & 0xFF;
            this.fBuffer.put(currByte, (byte)(b & mask | cmask));
        } else {
            this.fBuffer.put(currByte, (byte)correctedValue);
        }
    }

    public boolean canRead(int length) {
        return this.fPosition + (long)length <= this.fBitCapacity;
    }

    public void setByteOrder(ByteOrder order) {
        if (!order.equals(this.fByteOrder)) {
            this.fByteOrder = order;
            this.fBuffer.order(order);
        }
    }

    public ByteOrder getByteOrder() {
        return this.fByteOrder;
    }

    public void position(long newPosition) throws CTFException {
        if (newPosition > this.fBitCapacity) {
            throw new CTFException("Out of bounds exception on a position move, attempting to access position: " + newPosition);
        }
        this.fPosition = newPosition;
    }

    public long position() {
        return this.fPosition;
    }

    public ByteBuffer getByteBuffer() {
        return this.fBuffer;
    }

    public void clear() {
        this.resetPosition();
        this.fBuffer.clear();
    }
}

